//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter shrRndSat_0_xRe_w           = 16;
  parameter shrRndSat_0_xIm_w           = 16;

  // Outputs
  parameter shrRndSat_0_yRe_w           = 12;
  parameter shrRndSat_0_yIm_w           = 12;

  // Input control lines

  // Output control lines

  // Eregs
  parameter shrRndSat_0_run1_w          = 1;
  parameter shrRndSat_0_run1_r          = 0;
  parameter shrRndSat_0_run1_s          = 0;

  // Parameters
  parameter shrRndSat_0_wx              = 16;
  parameter shrRndSat_0_wy              = 12;
  parameter shrRndSat_0_sh              = 4;

  // Iregs
  parameter shrRndSat_0_yReR_w          = 12;
  parameter shrRndSat_0_yReR_n          = 1;
  parameter shrRndSat_0_yReR_m          = `CLOG2(1);
  parameter shrRndSat_0_yImR_w          = 12;
  parameter shrRndSat_0_yImR_n          = 1;
  parameter shrRndSat_0_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam shrRndSat_0.xRe_w           = shrRndSat_0_xRe_w;
  defparam shrRndSat_0.xIm_w           = shrRndSat_0_xIm_w;
  defparam shrRndSat_0.yRe_w           = shrRndSat_0_yRe_w;
  defparam shrRndSat_0.yIm_w           = shrRndSat_0_yIm_w;
  defparam shrRndSat_0.run1_w          = shrRndSat_0_run1_w;
  defparam shrRndSat_0.run1_r          = shrRndSat_0_run1_r;
  defparam shrRndSat_0.run1_s          = shrRndSat_0_run1_s;
  defparam shrRndSat_0.wx              = shrRndSat_0_wx;
  defparam shrRndSat_0.wy              = shrRndSat_0_wy;
  defparam shrRndSat_0.sh              = shrRndSat_0_sh;
  defparam shrRndSat_0.yReR_w          = shrRndSat_0_yReR_w;
  defparam shrRndSat_0.yReR_n          = shrRndSat_0_yReR_n;
  defparam shrRndSat_0.yReR_m          = shrRndSat_0_yReR_m;
  defparam shrRndSat_0.yImR_w          = shrRndSat_0_yImR_w;
  defparam shrRndSat_0.yImR_n          = shrRndSat_0_yImR_n;
  defparam shrRndSat_0.yImR_m          = shrRndSat_0_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_shrRndSat_0_run1                                           = 0;
  defparam  shrRndSat_0.R_run1                                           = R_shrRndSat_0_run1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [shrRndSat_0_yRe_w-1:0]  shrRndSat_0_yRe;
  wire                                      shrRndSat_0_yRe_or;
  wire                                      shrRndSat_0_yRe_ff;
  wire                                      shrRndSat_0_yRe_we;

  wire             [shrRndSat_0_yIm_w-1:0]  shrRndSat_0_yIm;
  wire                                      shrRndSat_0_yIm_or;
  wire                                      shrRndSat_0_yIm_ff;
  wire                                      shrRndSat_0_yIm_we;

  wire             [shrRndSat_0_xRe_w-1:0]  shrRndSat_0_xRe;
  wire                                      shrRndSat_0_xRe_ir;
  wire                                      shrRndSat_0_xRe_fe;
  wire                                      shrRndSat_0_xRe_re;

  wire             [shrRndSat_0_xIm_w-1:0]  shrRndSat_0_xIm;
  wire                                      shrRndSat_0_xIm_ir;
  wire                                      shrRndSat_0_xIm_fe;
  wire                                      shrRndSat_0_xIm_re;

  wire                                      shrRndSat_0_regWe;
  wire                                      shrRndSat_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  shrRndSat shrRndSat_0(shrRndSat_0_yRe, shrRndSat_0_yRe_or, shrRndSat_0_yRe_ff, shrRndSat_0_yRe_we,
                        shrRndSat_0_yIm, shrRndSat_0_yIm_or, shrRndSat_0_yIm_ff, shrRndSat_0_yIm_we,
                        shrRndSat_0_xRe, shrRndSat_0_xRe_ir, shrRndSat_0_xRe_fe, shrRndSat_0_xRe_re, 
                        shrRndSat_0_xIm, shrRndSat_0_xIm_ir, shrRndSat_0_xIm_fe, shrRndSat_0_xIm_re, 
                        regBus, regWe, regRe, shrRndSat_0_regWe, shrRndSat_0_regRe, clk, clk2, reset);


//==============================================================================
