//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter rfMain_0_ctrlIn_w        = VrfCtrlWidth_C;
  parameter rfMain_0_dacRe_w         = VrfAdcDacWidth_C;
  parameter rfMain_0_dacIm_w         = VrfAdcDacWidth_C;
  parameter rfMain_0_ctrlPhy0In_w    = VrfCtrlWidth_C;
  parameter rfMain_0_ctrlPhy1In_w    = VrfCtrlWidth_C;
  parameter rfMain_0_dataPhy1Rx_w    = VrfDataWidth_C;

  // Outputs
  parameter rfMain_0_ctrlOut_w       = VrfCtrlWidth_C;
  parameter rfMain_0_adcRe_w         = VrfAdcDacWidth_C;
  parameter rfMain_0_adcIm_w         = VrfAdcDacWidth_C;
  parameter rfMain_0_ctrlPhy0Out_w   = VrfCtrlWidth_C;
  parameter rfMain_0_ctrlPhy1Out_w   = VrfCtrlWidth_C;
  parameter rfMain_0_dataPhy0Tx_w    = VrfDataWidth_C;

  // Input control lines
  parameter rfMain_0_uartIn_w        = 1;
  parameter rfMain_0_ctrlSel_w       = 1;
  parameter rfMain_0_gainSel_w       = VrfGainSelWidth_C;
  parameter rfMain_0_gpi_w           = VrfGpioWidth_C;

  // Output control lines
  parameter rfMain_0_uartOut_w       = 1;
  parameter rfMain_0_statLed_w       = VrfStatLedWidth_C;
  parameter rfMain_0_resetOut_w      = 1;
  parameter rfMain_0_gpo_w           = VrfGpioWidth_C;

  // Eregs
  parameter rfMain_0_resetReg_w      = 1;
  parameter rfMain_0_resetReg_r      = 0;
  parameter rfMain_0_resetReg_s      = 0;
  parameter rfMain_0_gpoR_w          = VrfGpioWidth_C;
  parameter rfMain_0_gpoR_r          = 0;
  parameter rfMain_0_gpoR_s          = 0;
  parameter rfMain_0_gpiR_w          = VrfGpioWidth_C;
  parameter rfMain_0_gpiR_r          = 0;
  parameter rfMain_0_gpiR_s          = 0;
  parameter rfMain_0_stat_w          = VrfStatLedWidth_C;
  parameter rfMain_0_stat_r          = 0;
  parameter rfMain_0_stat_s          = 0;

  // Parameters
  parameter rfMain_0_w               = VrfAdcDacWidth_C;
  parameter rfMain_0_wd              = VrfDataWidth_C;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter rfMain_0_extIf2Host_w    = VrfCtrlWidth_C;
  parameter rfMain_0_extIf2Host_n    = 24;
  parameter rfMain_0_extIf2Host_m    = 5;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam rfMain_0.ctrlIn_w        = rfMain_0_ctrlIn_w;
  defparam rfMain_0.dacRe_w         = rfMain_0_dacRe_w;
  defparam rfMain_0.dacIm_w         = rfMain_0_dacIm_w;
  defparam rfMain_0.ctrlPhy0In_w    = rfMain_0_ctrlPhy0In_w;
  defparam rfMain_0.ctrlPhy1In_w    = rfMain_0_ctrlPhy1In_w;
  defparam rfMain_0.dataPhy1Rx_w    = rfMain_0_dataPhy1Rx_w;
  defparam rfMain_0.ctrlOut_w       = rfMain_0_ctrlOut_w;
  defparam rfMain_0.adcRe_w         = rfMain_0_adcRe_w;
  defparam rfMain_0.adcIm_w         = rfMain_0_adcIm_w;
  defparam rfMain_0.ctrlPhy0Out_w   = rfMain_0_ctrlPhy0Out_w;
  defparam rfMain_0.ctrlPhy1Out_w   = rfMain_0_ctrlPhy1Out_w;
  defparam rfMain_0.dataPhy0Tx_w    = rfMain_0_dataPhy0Tx_w;
  defparam rfMain_0.uartIn_w        = rfMain_0_uartIn_w;
  defparam rfMain_0.ctrlSel_w       = rfMain_0_ctrlSel_w;
  defparam rfMain_0.gainSel_w       = rfMain_0_gainSel_w;
  defparam rfMain_0.gpi_w           = rfMain_0_gpi_w;
  defparam rfMain_0.uartOut_w       = rfMain_0_uartOut_w;
  defparam rfMain_0.statLed_w       = rfMain_0_statLed_w;
  defparam rfMain_0.resetOut_w      = rfMain_0_resetOut_w;
  defparam rfMain_0.gpo_w           = rfMain_0_gpo_w;
  defparam rfMain_0.resetReg_w      = rfMain_0_resetReg_w;
  defparam rfMain_0.resetReg_r      = rfMain_0_resetReg_r;
  defparam rfMain_0.resetReg_s      = rfMain_0_resetReg_s;
  defparam rfMain_0.gpoR_w          = rfMain_0_gpoR_w;
  defparam rfMain_0.gpoR_r          = rfMain_0_gpoR_r;
  defparam rfMain_0.gpoR_s          = rfMain_0_gpoR_s;
  defparam rfMain_0.gpiR_w          = rfMain_0_gpiR_w;
  defparam rfMain_0.gpiR_r          = rfMain_0_gpiR_r;
  defparam rfMain_0.gpiR_s          = rfMain_0_gpiR_s;
  defparam rfMain_0.stat_w          = rfMain_0_stat_w;
  defparam rfMain_0.stat_r          = rfMain_0_stat_r;
  defparam rfMain_0.stat_s          = rfMain_0_stat_s;
  defparam rfMain_0.w               = rfMain_0_w;
  defparam rfMain_0.wd              = rfMain_0_wd;
  defparam rfMain_0.extIf2Host_w    = rfMain_0_extIf2Host_w;
  defparam rfMain_0.extIf2Host_m    = rfMain_0_extIf2Host_m;
  defparam rfMain_0.extIf2Host_n    = rfMain_0_extIf2Host_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_rfMain_0_resetReg                                          = 0;
  defparam  rfMain_0.R_resetReg                                          = R_rfMain_0_resetReg;
  parameter R_rfMain_0_gpoR                                              = 1;
  defparam  rfMain_0.R_gpoR                                              = R_rfMain_0_gpoR;
  parameter R_rfMain_0_gpiR                                              = 2;
  defparam  rfMain_0.R_gpiR                                              = R_rfMain_0_gpiR;
  parameter R_rfMain_0_stat                                              = 3;
  defparam  rfMain_0.R_stat                                              = R_rfMain_0_stat;
  parameter R_rfMain_0_uart16_vrf_div                                    = 4;
  defparam  rfMain_0.R_uart16_vrf_div                                    = R_rfMain_0_uart16_vrf_div;
  parameter R_rfMain_0_extIf_0_rxDat                                     = 5;
  defparam  rfMain_0.R_extIf_0_rxDat                                     = R_rfMain_0_extIf_0_rxDat;
  parameter R_rfMain_0_extIf_0_rxSt                                      = 6;
  defparam  rfMain_0.R_extIf_0_rxSt                                      = R_rfMain_0_extIf_0_rxSt;
  parameter R_rfMain_0_extIf_0_txDat                                     = 7;
  defparam  rfMain_0.R_extIf_0_txDat                                     = R_rfMain_0_extIf_0_txDat;
  parameter R_rfMain_0_extIf_0_txSt                                      = 8;
  defparam  rfMain_0.R_extIf_0_txSt                                      = R_rfMain_0_extIf_0_txSt;
  parameter R_rfMain_0_extIf_0_ctrlOn                                    = 9;
  defparam  rfMain_0.R_extIf_0_ctrlOn                                    = R_rfMain_0_extIf_0_ctrlOn;
  parameter R_rfMain_0_irqCtrl_rf_run1                                   = 10;
  defparam  rfMain_0.R_irqCtrl_rf_run1                                   = R_rfMain_0_irqCtrl_rf_run1;
  parameter R_rfMain_0_irqCtrl_rf_irqStat                                = 11;
  defparam  rfMain_0.R_irqCtrl_rf_irqStat                                = R_rfMain_0_irqCtrl_rf_irqStat;
  parameter R_rfMain_0_irqCtrl_rf_irqEdgeLevel                           = 12;
  defparam  rfMain_0.R_irqCtrl_rf_irqEdgeLevel                           = R_rfMain_0_irqCtrl_rf_irqEdgeLevel;
  parameter R_rfMain_0_irqCtrl_rf_irqMaskIn                              = 13;
  defparam  rfMain_0.R_irqCtrl_rf_irqMaskIn                              = R_rfMain_0_irqCtrl_rf_irqMaskIn;
  parameter R_rfMain_0_irqCtrl_rf_irqMaskOut                             = 14;
  defparam  rfMain_0.R_irqCtrl_rf_irqMaskOut                             = R_rfMain_0_irqCtrl_rf_irqMaskOut;
  parameter R_rfMain_0_irqCtrl_rf_irqClr                                 = 15;
  defparam  rfMain_0.R_irqCtrl_rf_irqClr                                 = R_rfMain_0_irqCtrl_rf_irqClr;
  parameter R_rfMain_0_irqCtrl_rf_irqSet                                 = 16;
  defparam  rfMain_0.R_irqCtrl_rf_irqSet                                 = R_rfMain_0_irqCtrl_rf_irqSet;
  parameter R_rfMain_0_irqCtrl_rf_irqIdx                                 = 17;
  defparam  rfMain_0.R_irqCtrl_rf_irqIdx                                 = R_rfMain_0_irqCtrl_rf_irqIdx;
  parameter R_rfMain_0_X16_rf_cmd                                        = 18;
  defparam  rfMain_0.R_X16_rf_cmd                                        = R_rfMain_0_X16_rf_cmd;
  parameter R_rfMain_0_X16_rf_pramAdr                                    = 19;
  defparam  rfMain_0.R_X16_rf_pramAdr                                    = R_rfMain_0_X16_rf_pramAdr;
  parameter R_rfMain_0_X16_rf_pramDat                                    = 20;
  defparam  rfMain_0.R_X16_rf_pramDat                                    = R_rfMain_0_X16_rf_pramDat;
  parameter R_rfMain_0_X16_rf_dramAdr                                    = 21;
  defparam  rfMain_0.R_X16_rf_dramAdr                                    = R_rfMain_0_X16_rf_dramAdr;
  parameter R_rfMain_0_X16_rf_dramDat                                    = 22;
  defparam  rfMain_0.R_X16_rf_dramDat                                    = R_rfMain_0_X16_rf_dramDat;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_run1                    = 23;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dacSim_0_run1                    = R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_run1;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_pLo16                   = 24;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dacSim_0_pLo16                   = R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_pLo16;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_pHi16                   = 25;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dacSim_0_pHi16                   = R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_pHi16;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_qLo16                   = 26;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dacSim_0_qLo16                   = R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_qLo16;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_qHi16                   = 27;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dacSim_0_qHi16                   = R_rfMain_0_rfAll_0_mainTx_0_dacSim_0_qHi16;
  parameter R_rfMain_0_rfAll_0_mainTx_0_txScale_0_run1                   = 28;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_txScale_0_run1                   = R_rfMain_0_rfAll_0_mainTx_0_txScale_0_run1;
  parameter R_rfMain_0_rfAll_0_mainTx_0_txScale_0_txFactor               = 29;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_txScale_0_txFactor               = R_rfMain_0_rfAll_0_mainTx_0_txScale_0_txFactor;
  parameter R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_run1                     = 30;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_iqImb_0_run1                     = R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_run1;
  parameter R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_a                        = 31;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_iqImb_0_a                        = R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_a;
  parameter R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_b                        = 32;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_iqImb_0_b                        = R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_b;
  parameter R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_c                        = 33;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_iqImb_0_c                        = R_rfMain_0_rfAll_0_mainTx_0_iqImb_0_c;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dcOff_0_run1                     = 34;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dcOff_0_run1                     = R_rfMain_0_rfAll_0_mainTx_0_dcOff_0_run1;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dcOff_0_dcRe                     = 35;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dcOff_0_dcRe                     = R_rfMain_0_rfAll_0_mainTx_0_dcOff_0_dcRe;
  parameter R_rfMain_0_rfAll_0_mainTx_0_dcOff_0_dcIm                     = 36;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_dcOff_0_dcIm                     = R_rfMain_0_rfAll_0_mainTx_0_dcOff_0_dcIm;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_run1                        = 37;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_run1                        = R_rfMain_0_rfAll_0_mainTx_0_pa_0_run1;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_bypass                      = 38;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_bypass                      = R_rfMain_0_rfAll_0_mainTx_0_pa_0_bypass;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr = 39;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi = 40;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo = 41;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit = 42;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr  = 43;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr  = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi = 44;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo = 45;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo;
  parameter R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit = 46;
  defparam  rfMain_0.R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit = R_rfMain_0_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_run1               = 47;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_run1               = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_run1;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRe    = 48;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRePlIm = 49;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cReMiIm = 50;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRe    = 51;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRePlIm = 52;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cReMiIm = 53;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRe    = 54;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRePlIm = 55;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cReMiIm = 56;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRe    = 57;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRePlIm = 58;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cReMiIm = 59;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRe    = 60;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRePlIm = 61;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cReMiIm = 62;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRe    = 63;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRePlIm = 64;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cReMiIm = 65;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRe    = 66;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRePlIm = 67;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cReMiIm = 68;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRe    = 69;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRePlIm = 70;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cReMiIm = 71;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRe    = 72;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRePlIm = 73;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cReMiIm = 74;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRe    = 75;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRe    = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRePlIm = 76;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRePlIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRePlIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cReMiIm = 77;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cReMiIm = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cReMiIm;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_00_inpSel = 78;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_00_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_00_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_01_inpSel = 79;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_01_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_01_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_02_inpSel = 80;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_02_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_02_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_03_inpSel = 81;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_03_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_03_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_04_inpSel = 82;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_04_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_04_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_05_inpSel = 83;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_05_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_05_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_06_inpSel = 84;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_06_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_06_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_07_inpSel = 85;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_07_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_07_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_08_inpSel = 86;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_08_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_08_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_09_inpSel = 87;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_09_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_09_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_10_inpSel = 88;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_10_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_10_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_11_inpSel = 89;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_11_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_11_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_12_inpSel = 90;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_12_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_12_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_13_inpSel = 91;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_13_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_13_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_14_inpSel = 92;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_14_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_14_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_15_inpSel = 93;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_15_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_15_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_16_inpSel = 94;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_16_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_16_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_17_inpSel = 95;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_17_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_17_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_18_inpSel = 96;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_18_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_18_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_19_inpSel = 97;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_19_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_19_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_20_inpSel = 98;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_20_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_20_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_21_inpSel = 99;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_21_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_21_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_22_inpSel = 100;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_22_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_22_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_23_inpSel = 101;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_23_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_23_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_24_inpSel = 102;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_24_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_24_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_25_inpSel = 103;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_25_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_25_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_26_inpSel = 104;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_26_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_26_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_27_inpSel = 105;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_27_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_27_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_28_inpSel = 106;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_28_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_28_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_29_inpSel = 107;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_29_inpSel = R_rfMain_0_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_29_inpSel;
  parameter R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_firToff_0_run1       = 108;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_timeOff_0_firToff_0_run1       = R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_firToff_0_run1;
  parameter R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_run1     = 109;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_run1     = R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_run1;
  parameter R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_byPass   = 110;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_byPass   = R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_byPass;
  parameter R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffLo16 = 111;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffLo16 = R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffLo16;
  parameter R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffMi16 = 112;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffMi16 = R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffMi16;
  parameter R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffHi16 = 113;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffHi16 = R_rfMain_0_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffHi16;
  parameter R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_run1                 = 114;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_freqOff_0_run1                 = R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_run1;
  parameter R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_freqOffLo16          = 115;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_freqOff_0_freqOffLo16          = R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_freqOffLo16;
  parameter R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_freqOffMi16          = 116;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_freqOff_0_freqOffMi16          = R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_freqOffMi16;
  parameter R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_freqOffHi16          = 117;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_freqOff_0_freqOffHi16          = R_rfMain_0_rfAll_0_mainChan_0_freqOff_0_freqOffHi16;
  parameter R_rfMain_0_rfAll_0_mainChan_0_gainChan_0_run1                = 118;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_gainChan_0_run1                = R_rfMain_0_rfAll_0_mainChan_0_gainChan_0_run1;
  parameter R_rfMain_0_rfAll_0_mainChan_0_gainChan_0_gainFactor          = 119;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_gainChan_0_gainFactor          = R_rfMain_0_rfAll_0_mainChan_0_gainChan_0_gainFactor;
  parameter R_rfMain_0_rfAll_0_mainChan_0_gainChan_0_gainShift           = 120;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_gainChan_0_gainShift           = R_rfMain_0_rfAll_0_mainChan_0_gainChan_0_gainShift;
  parameter R_rfMain_0_rfAll_0_mainRx_0_awgn_0_run1                      = 121;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_awgn_0_run1                      = R_rfMain_0_rfAll_0_mainRx_0_awgn_0_run1;
  parameter R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_run1                  = 122;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_gainCtrl_0_run1                  = R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_run1;
  parameter R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_gainDelay             = 123;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_gainCtrl_0_gainDelay             = R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_gainDelay;
  parameter R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrAdr          = 124;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrAdr          = R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrAdr;
  parameter R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatHi        = 125;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatHi        = R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatHi;
  parameter R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatLo        = 126;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatLo        = R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatLo;
  parameter R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_simInit        = 127;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_simInit        = R_rfMain_0_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_simInit;
  parameter R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_run1                     = 128;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_iqImb_0_run1                     = R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_run1;
  parameter R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_a                        = 129;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_iqImb_0_a                        = R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_a;
  parameter R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_b                        = 130;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_iqImb_0_b                        = R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_b;
  parameter R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_c                        = 131;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_iqImb_0_c                        = R_rfMain_0_rfAll_0_mainRx_0_iqImb_0_c;
  parameter R_rfMain_0_rfAll_0_mainRx_0_dcOff_0_run1                     = 132;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_dcOff_0_run1                     = R_rfMain_0_rfAll_0_mainRx_0_dcOff_0_run1;
  parameter R_rfMain_0_rfAll_0_mainRx_0_dcOff_0_dcRe                     = 133;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_dcOff_0_dcRe                     = R_rfMain_0_rfAll_0_mainRx_0_dcOff_0_dcRe;
  parameter R_rfMain_0_rfAll_0_mainRx_0_dcOff_0_dcIm                     = 134;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_dcOff_0_dcIm                     = R_rfMain_0_rfAll_0_mainRx_0_dcOff_0_dcIm;
  parameter R_rfMain_0_rfAll_0_mainRx_0_shrRndSat_0_run1                 = 135;
  defparam  rfMain_0.R_rfAll_0_mainRx_0_shrRndSat_0_run1                 = R_rfMain_0_rfAll_0_mainRx_0_shrRndSat_0_run1;
  parameter R_rfMain_0_extIf_phy0_rxDat                                  = 136;
  defparam  rfMain_0.R_extIf_phy0_rxDat                                  = R_rfMain_0_extIf_phy0_rxDat;
  parameter R_rfMain_0_extIf_phy0_rxSt                                   = 137;
  defparam  rfMain_0.R_extIf_phy0_rxSt                                   = R_rfMain_0_extIf_phy0_rxSt;
  parameter R_rfMain_0_extIf_phy0_txDat                                  = 138;
  defparam  rfMain_0.R_extIf_phy0_txDat                                  = R_rfMain_0_extIf_phy0_txDat;
  parameter R_rfMain_0_extIf_phy0_txSt                                   = 139;
  defparam  rfMain_0.R_extIf_phy0_txSt                                   = R_rfMain_0_extIf_phy0_txSt;
  parameter R_rfMain_0_extIf_phy0_ctrlOn                                 = 140;
  defparam  rfMain_0.R_extIf_phy0_ctrlOn                                 = R_rfMain_0_extIf_phy0_ctrlOn;
  parameter R_rfMain_0_extIf_phy1_rxDat                                  = 141;
  defparam  rfMain_0.R_extIf_phy1_rxDat                                  = R_rfMain_0_extIf_phy1_rxDat;
  parameter R_rfMain_0_extIf_phy1_rxSt                                   = 142;
  defparam  rfMain_0.R_extIf_phy1_rxSt                                   = R_rfMain_0_extIf_phy1_rxSt;
  parameter R_rfMain_0_extIf_phy1_txDat                                  = 143;
  defparam  rfMain_0.R_extIf_phy1_txDat                                  = R_rfMain_0_extIf_phy1_txDat;
  parameter R_rfMain_0_extIf_phy1_txSt                                   = 144;
  defparam  rfMain_0.R_extIf_phy1_txSt                                   = R_rfMain_0_extIf_phy1_txSt;
  parameter R_rfMain_0_extIf_phy1_ctrlOn                                 = 145;
  defparam  rfMain_0.R_extIf_phy1_ctrlOn                                 = R_rfMain_0_extIf_phy1_ctrlOn;
  parameter R_rfMain_0_datSrc_0_run1                                     = 146;
  defparam  rfMain_0.R_datSrc_0_run1                                     = R_rfMain_0_datSrc_0_run1;
  parameter R_rfMain_0_datSrc_0_cntRnd                                   = 147;
  defparam  rfMain_0.R_datSrc_0_cntRnd                                   = R_rfMain_0_datSrc_0_cntRnd;
  parameter R_rfMain_0_datSrc_0_endZero                                  = 148;
  defparam  rfMain_0.R_datSrc_0_endZero                                  = R_rfMain_0_datSrc_0_endZero;
  parameter R_rfMain_0_datSrc_0_dat                                      = 149;
  defparam  rfMain_0.R_datSrc_0_dat                                      = R_rfMain_0_datSrc_0_dat;
  parameter R_rfMain_0_datSrc_0_numDat                                   = 150;
  defparam  rfMain_0.R_datSrc_0_numDat                                   = R_rfMain_0_datSrc_0_numDat;
  parameter R_rfMain_0_c8To16_0_run1                                     = 151;
  defparam  rfMain_0.R_c8To16_0_run1                                     = R_rfMain_0_c8To16_0_run1;
  parameter R_rfMain_0_c8To16_0_nByte                                    = 152;
  defparam  rfMain_0.R_c8To16_0_nByte                                    = R_rfMain_0_c8To16_0_nByte;
  parameter R_rfMain_0_dataBuf_phy0_run1                                 = 153;
  defparam  rfMain_0.R_dataBuf_phy0_run1                                 = R_rfMain_0_dataBuf_phy0_run1;
  parameter R_rfMain_0_dataBuf_phy0_datAdr                               = 154;
  defparam  rfMain_0.R_dataBuf_phy0_datAdr                               = R_rfMain_0_dataBuf_phy0_datAdr;
  parameter R_rfMain_0_dataBuf_phy0_datVal                               = 155;
  defparam  rfMain_0.R_dataBuf_phy0_datVal                               = R_rfMain_0_dataBuf_phy0_datVal;
  parameter R_rfMain_0_dataBuf_phy1_run1                                 = 156;
  defparam  rfMain_0.R_dataBuf_phy1_run1                                 = R_rfMain_0_dataBuf_phy1_run1;
  parameter R_rfMain_0_dataBuf_phy1_datAdr                               = 157;
  defparam  rfMain_0.R_dataBuf_phy1_datAdr                               = R_rfMain_0_dataBuf_phy1_datAdr;
  parameter R_rfMain_0_dataBuf_phy1_datVal                               = 158;
  defparam  rfMain_0.R_dataBuf_phy1_datVal                               = R_rfMain_0_dataBuf_phy1_datVal;
  parameter R_rfMain_0_c16To8_0_run1                                     = 159;
  defparam  rfMain_0.R_c16To8_0_run1                                     = R_rfMain_0_c16To8_0_run1;
  parameter R_rfMain_0_c16To8_0_nByte                                    = 160;
  defparam  rfMain_0.R_c16To8_0_nByte                                    = R_rfMain_0_c16To8_0_nByte;
  parameter R_rfMain_0_datSnk_0_run1                                     = 161;
  defparam  rfMain_0.R_datSnk_0_run1                                     = R_rfMain_0_datSnk_0_run1;
  parameter R_rfMain_0_datSnk_0_cntRnd                                   = 162;
  defparam  rfMain_0.R_datSnk_0_cntRnd                                   = R_rfMain_0_datSnk_0_cntRnd;
  parameter R_rfMain_0_datSnk_0_endZero                                  = 163;
  defparam  rfMain_0.R_datSnk_0_endZero                                  = R_rfMain_0_datSnk_0_endZero;
  parameter R_rfMain_0_datSnk_0_dat                                      = 164;
  defparam  rfMain_0.R_datSnk_0_dat                                      = R_rfMain_0_datSnk_0_dat;
  parameter R_rfMain_0_datSnk_0_numDat                                   = 165;
  defparam  rfMain_0.R_datSnk_0_numDat                                   = R_rfMain_0_datSnk_0_numDat;
  parameter R_rfMain_0_datSnk_0_err                                      = 166;
  defparam  rfMain_0.R_datSnk_0_err                                      = R_rfMain_0_datSnk_0_err;
  parameter R_rfMain_0_timer_0_run1                                      = 167;
  defparam  rfMain_0.R_timer_0_run1                                      = R_rfMain_0_timer_0_run1;
  parameter R_rfMain_0_timer_0_timeLo                                    = 168;
  defparam  rfMain_0.R_timer_0_timeLo                                    = R_rfMain_0_timer_0_timeLo;
  parameter R_rfMain_0_timer_0_timeHi                                    = 169;
  defparam  rfMain_0.R_timer_0_timeHi                                    = R_rfMain_0_timer_0_timeHi;
  parameter R_rfMain_0_timer_0_irqEn0                                    = 170;
  defparam  rfMain_0.R_timer_0_irqEn0                                    = R_rfMain_0_timer_0_irqEn0;
  parameter R_rfMain_0_timer_0_irqEn1                                    = 171;
  defparam  rfMain_0.R_timer_0_irqEn1                                    = R_rfMain_0_timer_0_irqEn1;
  parameter R_rfMain_0_timer_0_tMatch0Lo                                 = 172;
  defparam  rfMain_0.R_timer_0_tMatch0Lo                                 = R_rfMain_0_timer_0_tMatch0Lo;
  parameter R_rfMain_0_timer_0_tMatch0Hi                                 = 173;
  defparam  rfMain_0.R_timer_0_tMatch0Hi                                 = R_rfMain_0_timer_0_tMatch0Hi;
  parameter R_rfMain_0_timer_0_tMatch1Lo                                 = 174;
  defparam  rfMain_0.R_timer_0_tMatch1Lo                                 = R_rfMain_0_timer_0_tMatch1Lo;
  parameter R_rfMain_0_timer_0_tMatch1Hi                                 = 175;
  defparam  rfMain_0.R_timer_0_tMatch1Hi                                 = R_rfMain_0_timer_0_tMatch1Hi;
  parameter R_rfMain_0_timer_0_pLo16                                     = 176;
  defparam  rfMain_0.R_timer_0_pLo16                                     = R_rfMain_0_timer_0_pLo16;
  parameter R_rfMain_0_timer_0_pHi16                                     = 177;
  defparam  rfMain_0.R_timer_0_pHi16                                     = R_rfMain_0_timer_0_pHi16;
  parameter R_rfMain_0_timer_0_qLo16                                     = 178;
  defparam  rfMain_0.R_timer_0_qLo16                                     = R_rfMain_0_timer_0_qLo16;
  parameter R_rfMain_0_timer_0_qHi16                                     = 179;
  defparam  rfMain_0.R_timer_0_qHi16                                     = R_rfMain_0_timer_0_qHi16;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_rfMain_0_extIf2Host                                        = 180;
  defparam  rfMain_0.R_extIf2Host                                        = R_rfMain_0_extIf2Host;
  parameter R_rfMain_0_rfAll_0_mainChan_0_tOffInRe                       = 181;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_tOffInRe                       = R_rfMain_0_rfAll_0_mainChan_0_tOffInRe;
  parameter R_rfMain_0_rfAll_0_mainChan_0_tOffInIm                       = 182;
  defparam  rfMain_0.R_rfAll_0_mainChan_0_tOffInIm                       = R_rfMain_0_rfAll_0_mainChan_0_tOffInIm;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire            [rfMain_0_ctrlOut_w-1:0]  rfMain_0_ctrlOut;
  wire                                      rfMain_0_ctrlOut_or;
  wire                                      rfMain_0_ctrlOut_ff;
  wire                                      rfMain_0_ctrlOut_we;

  wire              [rfMain_0_adcRe_w-1:0]  rfMain_0_adcRe;
  wire                                      rfMain_0_adcRe_or;
  wire                                      rfMain_0_adcRe_ff;
  wire                                      rfMain_0_adcRe_we;

  wire              [rfMain_0_adcIm_w-1:0]  rfMain_0_adcIm;
  wire                                      rfMain_0_adcIm_or;
  wire                                      rfMain_0_adcIm_ff;
  wire                                      rfMain_0_adcIm_we;

  wire        [rfMain_0_ctrlPhy0Out_w-1:0]  rfMain_0_ctrlPhy0Out;
  wire                                      rfMain_0_ctrlPhy0Out_or;
  wire                                      rfMain_0_ctrlPhy0Out_ff;
  wire                                      rfMain_0_ctrlPhy0Out_we;

  wire        [rfMain_0_ctrlPhy1Out_w-1:0]  rfMain_0_ctrlPhy1Out;
  wire                                      rfMain_0_ctrlPhy1Out_or;
  wire                                      rfMain_0_ctrlPhy1Out_ff;
  wire                                      rfMain_0_ctrlPhy1Out_we;

  wire         [rfMain_0_dataPhy0Tx_w-1:0]  rfMain_0_dataPhy0Tx;
  wire                                      rfMain_0_dataPhy0Tx_or;
  wire                                      rfMain_0_dataPhy0Tx_ff;
  wire                                      rfMain_0_dataPhy0Tx_we;

  wire             [rfMain_0_ctrlIn_w-1:0]  rfMain_0_ctrlIn;
  wire                                      rfMain_0_ctrlIn_ir;
  wire                                      rfMain_0_ctrlIn_fe;
  wire                                      rfMain_0_ctrlIn_re;

  wire              [rfMain_0_dacRe_w-1:0]  rfMain_0_dacRe;
  wire                                      rfMain_0_dacRe_ir;
  wire                                      rfMain_0_dacRe_fe;
  wire                                      rfMain_0_dacRe_re;

  wire              [rfMain_0_dacIm_w-1:0]  rfMain_0_dacIm;
  wire                                      rfMain_0_dacIm_ir;
  wire                                      rfMain_0_dacIm_fe;
  wire                                      rfMain_0_dacIm_re;

  wire         [rfMain_0_ctrlPhy0In_w-1:0]  rfMain_0_ctrlPhy0In;
  wire                                      rfMain_0_ctrlPhy0In_ir;
  wire                                      rfMain_0_ctrlPhy0In_fe;
  wire                                      rfMain_0_ctrlPhy0In_re;

  wire         [rfMain_0_ctrlPhy1In_w-1:0]  rfMain_0_ctrlPhy1In;
  wire                                      rfMain_0_ctrlPhy1In_ir;
  wire                                      rfMain_0_ctrlPhy1In_fe;
  wire                                      rfMain_0_ctrlPhy1In_re;

  wire         [rfMain_0_dataPhy1Rx_w-1:0]  rfMain_0_dataPhy1Rx;
  wire                                      rfMain_0_dataPhy1Rx_ir;
  wire                                      rfMain_0_dataPhy1Rx_fe;
  wire                                      rfMain_0_dataPhy1Rx_re;

  wire            [rfMain_0_uartOut_w-1:0]  rfMain_0_uartOut;
  wire            [rfMain_0_statLed_w-1:0]  rfMain_0_statLed;
  wire           [rfMain_0_resetOut_w-1:0]  rfMain_0_resetOut;
  wire                [rfMain_0_gpo_w-1:0]  rfMain_0_gpo;

  wire             [rfMain_0_uartIn_w-1:0]  rfMain_0_uartIn;
  wire            [rfMain_0_ctrlSel_w-1:0]  rfMain_0_ctrlSel;
  wire            [rfMain_0_gainSel_w-1:0]  rfMain_0_gainSel;
  wire                [rfMain_0_gpi_w-1:0]  rfMain_0_gpi;

  wire                                      rfMain_0_regWe;
  wire                                      rfMain_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  rfMain rfMain_0(rfMain_0_ctrlOut, rfMain_0_ctrlOut_or, rfMain_0_ctrlOut_ff, rfMain_0_ctrlOut_we,
                  rfMain_0_adcRe, rfMain_0_adcRe_or, rfMain_0_adcRe_ff, rfMain_0_adcRe_we,
                  rfMain_0_adcIm, rfMain_0_adcIm_or, rfMain_0_adcIm_ff, rfMain_0_adcIm_we,
                  rfMain_0_ctrlPhy0Out, rfMain_0_ctrlPhy0Out_or, rfMain_0_ctrlPhy0Out_ff, rfMain_0_ctrlPhy0Out_we,
                  rfMain_0_ctrlPhy1Out, rfMain_0_ctrlPhy1Out_or, rfMain_0_ctrlPhy1Out_ff, rfMain_0_ctrlPhy1Out_we,
                  rfMain_0_dataPhy0Tx, rfMain_0_dataPhy0Tx_or, rfMain_0_dataPhy0Tx_ff, rfMain_0_dataPhy0Tx_we,
                  rfMain_0_ctrlIn, rfMain_0_ctrlIn_ir, rfMain_0_ctrlIn_fe, rfMain_0_ctrlIn_re, 
                  rfMain_0_dacRe, rfMain_0_dacRe_ir, rfMain_0_dacRe_fe, rfMain_0_dacRe_re, 
                  rfMain_0_dacIm, rfMain_0_dacIm_ir, rfMain_0_dacIm_fe, rfMain_0_dacIm_re, 
                  rfMain_0_ctrlPhy0In, rfMain_0_ctrlPhy0In_ir, rfMain_0_ctrlPhy0In_fe, rfMain_0_ctrlPhy0In_re, 
                  rfMain_0_ctrlPhy1In, rfMain_0_ctrlPhy1In_ir, rfMain_0_ctrlPhy1In_fe, rfMain_0_ctrlPhy1In_re, 
                  rfMain_0_dataPhy1Rx, rfMain_0_dataPhy1Rx_ir, rfMain_0_dataPhy1Rx_fe, rfMain_0_dataPhy1Rx_re, 
                  rfMain_0_uartOut, 
                  rfMain_0_statLed, 
                  rfMain_0_resetOut, 
                  rfMain_0_gpo, 
                  rfMain_0_uartIn, 
                  rfMain_0_ctrlSel, 
                  rfMain_0_gainSel, 
                  rfMain_0_gpi, 
                  regBus, regWe, regRe, rfMain_0_regWe, rfMain_0_regRe, clk, clk2, reset);


//==============================================================================
