//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter rfAll_0_xRe_w           = 12;
  parameter rfAll_0_xIm_w           = 12;

  // Outputs
  parameter rfAll_0_yRe_w           = 12;
  parameter rfAll_0_yIm_w           = 12;

  // Input control lines
  parameter rfAll_0_gainSel_w       = 7;

  // Output control lines

  // Eregs

  // Parameters
  parameter rfAll_0_wx              = 12;
  parameter rfAll_0_wy              = 12;
  parameter rfAll_0_wg              = 7;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam rfAll_0.xRe_w           = rfAll_0_xRe_w;
  defparam rfAll_0.xIm_w           = rfAll_0_xIm_w;
  defparam rfAll_0.yRe_w           = rfAll_0_yRe_w;
  defparam rfAll_0.yIm_w           = rfAll_0_yIm_w;
  defparam rfAll_0.gainSel_w       = rfAll_0_gainSel_w;
  defparam rfAll_0.wx              = rfAll_0_wx;
  defparam rfAll_0.wy              = rfAll_0_wy;
  defparam rfAll_0.wg              = rfAll_0_wg;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_rfAll_0_mainTx_0_dacSim_0_run1                             = 0;
  defparam  rfAll_0.R_mainTx_0_dacSim_0_run1                             = R_rfAll_0_mainTx_0_dacSim_0_run1;
  parameter R_rfAll_0_mainTx_0_dacSim_0_pLo16                            = 1;
  defparam  rfAll_0.R_mainTx_0_dacSim_0_pLo16                            = R_rfAll_0_mainTx_0_dacSim_0_pLo16;
  parameter R_rfAll_0_mainTx_0_dacSim_0_pHi16                            = 2;
  defparam  rfAll_0.R_mainTx_0_dacSim_0_pHi16                            = R_rfAll_0_mainTx_0_dacSim_0_pHi16;
  parameter R_rfAll_0_mainTx_0_dacSim_0_qLo16                            = 3;
  defparam  rfAll_0.R_mainTx_0_dacSim_0_qLo16                            = R_rfAll_0_mainTx_0_dacSim_0_qLo16;
  parameter R_rfAll_0_mainTx_0_dacSim_0_qHi16                            = 4;
  defparam  rfAll_0.R_mainTx_0_dacSim_0_qHi16                            = R_rfAll_0_mainTx_0_dacSim_0_qHi16;
  parameter R_rfAll_0_mainTx_0_txScale_0_run1                            = 5;
  defparam  rfAll_0.R_mainTx_0_txScale_0_run1                            = R_rfAll_0_mainTx_0_txScale_0_run1;
  parameter R_rfAll_0_mainTx_0_txScale_0_txFactor                        = 6;
  defparam  rfAll_0.R_mainTx_0_txScale_0_txFactor                        = R_rfAll_0_mainTx_0_txScale_0_txFactor;
  parameter R_rfAll_0_mainTx_0_iqImb_0_run1                              = 7;
  defparam  rfAll_0.R_mainTx_0_iqImb_0_run1                              = R_rfAll_0_mainTx_0_iqImb_0_run1;
  parameter R_rfAll_0_mainTx_0_iqImb_0_a                                 = 8;
  defparam  rfAll_0.R_mainTx_0_iqImb_0_a                                 = R_rfAll_0_mainTx_0_iqImb_0_a;
  parameter R_rfAll_0_mainTx_0_iqImb_0_b                                 = 9;
  defparam  rfAll_0.R_mainTx_0_iqImb_0_b                                 = R_rfAll_0_mainTx_0_iqImb_0_b;
  parameter R_rfAll_0_mainTx_0_iqImb_0_c                                 = 10;
  defparam  rfAll_0.R_mainTx_0_iqImb_0_c                                 = R_rfAll_0_mainTx_0_iqImb_0_c;
  parameter R_rfAll_0_mainTx_0_dcOff_0_run1                              = 11;
  defparam  rfAll_0.R_mainTx_0_dcOff_0_run1                              = R_rfAll_0_mainTx_0_dcOff_0_run1;
  parameter R_rfAll_0_mainTx_0_dcOff_0_dcRe                              = 12;
  defparam  rfAll_0.R_mainTx_0_dcOff_0_dcRe                              = R_rfAll_0_mainTx_0_dcOff_0_dcRe;
  parameter R_rfAll_0_mainTx_0_dcOff_0_dcIm                              = 13;
  defparam  rfAll_0.R_mainTx_0_dcOff_0_dcIm                              = R_rfAll_0_mainTx_0_dcOff_0_dcIm;
  parameter R_rfAll_0_mainTx_0_pa_0_run1                                 = 14;
  defparam  rfAll_0.R_mainTx_0_pa_0_run1                                 = R_rfAll_0_mainTx_0_pa_0_run1;
  parameter R_rfAll_0_mainTx_0_pa_0_bypass                               = 15;
  defparam  rfAll_0.R_mainTx_0_pa_0_bypass                               = R_rfAll_0_mainTx_0_pa_0_bypass;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr          = 16;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr          = R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi        = 17;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi        = R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo        = 18;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo        = R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit        = 19;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit        = R_rfAll_0_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr           = 20;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr           = R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi         = 21;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi         = R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo         = 22;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo         = R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo;
  parameter R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit         = 23;
  defparam  rfAll_0.R_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit         = R_rfAll_0_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit;
  parameter R_rfAll_0_mainChan_0_multiPath_0_run1                        = 24;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_run1                        = R_rfAll_0_mainChan_0_multiPath_0_run1;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRe             = 25;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_00_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRePlIm         = 26;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_00_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cReMiIm         = 27;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_00_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_00_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRe             = 28;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_01_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRePlIm         = 29;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_01_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cReMiIm         = 30;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_01_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_01_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRe             = 31;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_02_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRePlIm         = 32;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_02_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cReMiIm         = 33;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_02_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_02_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRe             = 34;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_03_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRePlIm         = 35;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_03_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cReMiIm         = 36;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_03_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_03_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRe             = 37;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_04_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRePlIm         = 38;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_04_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cReMiIm         = 39;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_04_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_04_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRe             = 40;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_05_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRePlIm         = 41;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_05_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cReMiIm         = 42;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_05_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_05_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRe             = 43;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_06_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRePlIm         = 44;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_06_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cReMiIm         = 45;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_06_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_06_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRe             = 46;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_07_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRePlIm         = 47;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_07_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cReMiIm         = 48;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_07_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_07_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRe             = 49;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_08_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRePlIm         = 50;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_08_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cReMiIm         = 51;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_08_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_08_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRe             = 52;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_09_cRe             = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRe;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRePlIm         = 53;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_09_cRePlIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cRePlIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cReMiIm         = 54;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firCxMul_09_cReMiIm         = R_rfAll_0_mainChan_0_multiPath_0_firCxMul_09_cReMiIm;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_00_inpSel         = 55;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_00_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_00_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_01_inpSel         = 56;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_01_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_01_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_02_inpSel         = 57;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_02_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_02_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_03_inpSel         = 58;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_03_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_03_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_04_inpSel         = 59;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_04_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_04_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_05_inpSel         = 60;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_05_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_05_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_06_inpSel         = 61;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_06_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_06_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_07_inpSel         = 62;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_07_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_07_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_08_inpSel         = 63;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_08_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_08_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_09_inpSel         = 64;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_09_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_09_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_10_inpSel         = 65;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_10_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_10_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_11_inpSel         = 66;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_11_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_11_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_12_inpSel         = 67;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_12_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_12_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_13_inpSel         = 68;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_13_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_13_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_14_inpSel         = 69;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_14_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_14_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_15_inpSel         = 70;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_15_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_15_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_16_inpSel         = 71;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_16_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_16_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_17_inpSel         = 72;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_17_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_17_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_18_inpSel         = 73;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_18_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_18_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_19_inpSel         = 74;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_19_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_19_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_20_inpSel         = 75;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_20_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_20_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_21_inpSel         = 76;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_21_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_21_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_22_inpSel         = 77;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_22_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_22_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_23_inpSel         = 78;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_23_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_23_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_24_inpSel         = 79;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_24_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_24_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_25_inpSel         = 80;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_25_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_25_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_26_inpSel         = 81;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_26_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_26_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_27_inpSel         = 82;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_27_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_27_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_28_inpSel         = 83;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_28_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_28_inpSel;
  parameter R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_29_inpSel         = 84;
  defparam  rfAll_0.R_mainChan_0_multiPath_0_firMuxAdd_29_inpSel         = R_rfAll_0_mainChan_0_multiPath_0_firMuxAdd_29_inpSel;
  parameter R_rfAll_0_mainChan_0_timeOff_0_firToff_0_run1                = 85;
  defparam  rfAll_0.R_mainChan_0_timeOff_0_firToff_0_run1                = R_rfAll_0_mainChan_0_timeOff_0_firToff_0_run1;
  parameter R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_run1              = 86;
  defparam  rfAll_0.R_mainChan_0_timeOff_0_coeffToff_0_run1              = R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_run1;
  parameter R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_byPass            = 87;
  defparam  rfAll_0.R_mainChan_0_timeOff_0_coeffToff_0_byPass            = R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_byPass;
  parameter R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffLo16          = 88;
  defparam  rfAll_0.R_mainChan_0_timeOff_0_coeffToff_0_tOffLo16          = R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffLo16;
  parameter R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffMi16          = 89;
  defparam  rfAll_0.R_mainChan_0_timeOff_0_coeffToff_0_tOffMi16          = R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffMi16;
  parameter R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffHi16          = 90;
  defparam  rfAll_0.R_mainChan_0_timeOff_0_coeffToff_0_tOffHi16          = R_rfAll_0_mainChan_0_timeOff_0_coeffToff_0_tOffHi16;
  parameter R_rfAll_0_mainChan_0_freqOff_0_run1                          = 91;
  defparam  rfAll_0.R_mainChan_0_freqOff_0_run1                          = R_rfAll_0_mainChan_0_freqOff_0_run1;
  parameter R_rfAll_0_mainChan_0_freqOff_0_freqOffLo16                   = 92;
  defparam  rfAll_0.R_mainChan_0_freqOff_0_freqOffLo16                   = R_rfAll_0_mainChan_0_freqOff_0_freqOffLo16;
  parameter R_rfAll_0_mainChan_0_freqOff_0_freqOffMi16                   = 93;
  defparam  rfAll_0.R_mainChan_0_freqOff_0_freqOffMi16                   = R_rfAll_0_mainChan_0_freqOff_0_freqOffMi16;
  parameter R_rfAll_0_mainChan_0_freqOff_0_freqOffHi16                   = 94;
  defparam  rfAll_0.R_mainChan_0_freqOff_0_freqOffHi16                   = R_rfAll_0_mainChan_0_freqOff_0_freqOffHi16;
  parameter R_rfAll_0_mainChan_0_gainChan_0_run1                         = 95;
  defparam  rfAll_0.R_mainChan_0_gainChan_0_run1                         = R_rfAll_0_mainChan_0_gainChan_0_run1;
  parameter R_rfAll_0_mainChan_0_gainChan_0_gainFactor                   = 96;
  defparam  rfAll_0.R_mainChan_0_gainChan_0_gainFactor                   = R_rfAll_0_mainChan_0_gainChan_0_gainFactor;
  parameter R_rfAll_0_mainChan_0_gainChan_0_gainShift                    = 97;
  defparam  rfAll_0.R_mainChan_0_gainChan_0_gainShift                    = R_rfAll_0_mainChan_0_gainChan_0_gainShift;
  parameter R_rfAll_0_mainRx_0_awgn_0_run1                               = 98;
  defparam  rfAll_0.R_mainRx_0_awgn_0_run1                               = R_rfAll_0_mainRx_0_awgn_0_run1;
  parameter R_rfAll_0_mainRx_0_gainCtrl_0_run1                           = 99;
  defparam  rfAll_0.R_mainRx_0_gainCtrl_0_run1                           = R_rfAll_0_mainRx_0_gainCtrl_0_run1;
  parameter R_rfAll_0_mainRx_0_gainCtrl_0_gainDelay                      = 100;
  defparam  rfAll_0.R_mainRx_0_gainCtrl_0_gainDelay                      = R_rfAll_0_mainRx_0_gainCtrl_0_gainDelay;
  parameter R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrAdr                   = 101;
  defparam  rfAll_0.R_mainRx_0_gainCtrl_0_lut_gc_wrAdr                   = R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrAdr;
  parameter R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatHi                 = 102;
  defparam  rfAll_0.R_mainRx_0_gainCtrl_0_lut_gc_wrDatHi                 = R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatHi;
  parameter R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatLo                 = 103;
  defparam  rfAll_0.R_mainRx_0_gainCtrl_0_lut_gc_wrDatLo                 = R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_wrDatLo;
  parameter R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_simInit                 = 104;
  defparam  rfAll_0.R_mainRx_0_gainCtrl_0_lut_gc_simInit                 = R_rfAll_0_mainRx_0_gainCtrl_0_lut_gc_simInit;
  parameter R_rfAll_0_mainRx_0_iqImb_0_run1                              = 105;
  defparam  rfAll_0.R_mainRx_0_iqImb_0_run1                              = R_rfAll_0_mainRx_0_iqImb_0_run1;
  parameter R_rfAll_0_mainRx_0_iqImb_0_a                                 = 106;
  defparam  rfAll_0.R_mainRx_0_iqImb_0_a                                 = R_rfAll_0_mainRx_0_iqImb_0_a;
  parameter R_rfAll_0_mainRx_0_iqImb_0_b                                 = 107;
  defparam  rfAll_0.R_mainRx_0_iqImb_0_b                                 = R_rfAll_0_mainRx_0_iqImb_0_b;
  parameter R_rfAll_0_mainRx_0_iqImb_0_c                                 = 108;
  defparam  rfAll_0.R_mainRx_0_iqImb_0_c                                 = R_rfAll_0_mainRx_0_iqImb_0_c;
  parameter R_rfAll_0_mainRx_0_dcOff_0_run1                              = 109;
  defparam  rfAll_0.R_mainRx_0_dcOff_0_run1                              = R_rfAll_0_mainRx_0_dcOff_0_run1;
  parameter R_rfAll_0_mainRx_0_dcOff_0_dcRe                              = 110;
  defparam  rfAll_0.R_mainRx_0_dcOff_0_dcRe                              = R_rfAll_0_mainRx_0_dcOff_0_dcRe;
  parameter R_rfAll_0_mainRx_0_dcOff_0_dcIm                              = 111;
  defparam  rfAll_0.R_mainRx_0_dcOff_0_dcIm                              = R_rfAll_0_mainRx_0_dcOff_0_dcIm;
  parameter R_rfAll_0_mainRx_0_shrRndSat_0_run1                          = 112;
  defparam  rfAll_0.R_mainRx_0_shrRndSat_0_run1                          = R_rfAll_0_mainRx_0_shrRndSat_0_run1;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_rfAll_0_mainChan_0_tOffInRe                                = 113;
  defparam  rfAll_0.R_mainChan_0_tOffInRe                                = R_rfAll_0_mainChan_0_tOffInRe;
  parameter R_rfAll_0_mainChan_0_tOffInIm                                = 114;
  defparam  rfAll_0.R_mainChan_0_tOffInIm                                = R_rfAll_0_mainChan_0_tOffInIm;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [rfAll_0_yRe_w-1:0]  rfAll_0_yRe;
  wire                                      rfAll_0_yRe_or;
  wire                                      rfAll_0_yRe_ff;
  wire                                      rfAll_0_yRe_we;

  wire                 [rfAll_0_yIm_w-1:0]  rfAll_0_yIm;
  wire                                      rfAll_0_yIm_or;
  wire                                      rfAll_0_yIm_ff;
  wire                                      rfAll_0_yIm_we;

  wire                 [rfAll_0_xRe_w-1:0]  rfAll_0_xRe;
  wire                                      rfAll_0_xRe_ir;
  wire                                      rfAll_0_xRe_fe;
  wire                                      rfAll_0_xRe_re;

  wire                 [rfAll_0_xIm_w-1:0]  rfAll_0_xIm;
  wire                                      rfAll_0_xIm_ir;
  wire                                      rfAll_0_xIm_fe;
  wire                                      rfAll_0_xIm_re;

  wire             [rfAll_0_gainSel_w-1:0]  rfAll_0_gainSel;

  wire                                      rfAll_0_regWe;
  wire                                      rfAll_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  rfAll rfAll_0(rfAll_0_yRe, rfAll_0_yRe_or, rfAll_0_yRe_ff, rfAll_0_yRe_we,
                rfAll_0_yIm, rfAll_0_yIm_or, rfAll_0_yIm_ff, rfAll_0_yIm_we,
                rfAll_0_xRe, rfAll_0_xRe_ir, rfAll_0_xRe_fe, rfAll_0_xRe_re, 
                rfAll_0_xIm, rfAll_0_xIm_ir, rfAll_0_xIm_fe, rfAll_0_xIm_re, 
                rfAll_0_gainSel, 
                regBus, regWe, regRe, rfAll_0_regWe, rfAll_0_regRe, clk, clk2, reset);


//==============================================================================
