//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter pa_0_xRe_w           = 16;
  parameter pa_0_xIm_w           = 16;

  // Outputs
  parameter pa_0_yRe_w           = 16;
  parameter pa_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter pa_0_run1_w          = 1;
  parameter pa_0_run1_r          = 0;
  parameter pa_0_run1_s          = 0;
  parameter pa_0_bypass_w        = 1;
  parameter pa_0_bypass_r        = 1;
  parameter pa_0_bypass_s        = 0;

  // Parameters
  parameter pa_0_w               = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam pa_0.xRe_w           = pa_0_xRe_w;
  defparam pa_0.xIm_w           = pa_0_xIm_w;
  defparam pa_0.yRe_w           = pa_0_yRe_w;
  defparam pa_0.yIm_w           = pa_0_yIm_w;
  defparam pa_0.run1_w          = pa_0_run1_w;
  defparam pa_0.run1_r          = pa_0_run1_r;
  defparam pa_0.run1_s          = pa_0_run1_s;
  defparam pa_0.bypass_w        = pa_0_bypass_w;
  defparam pa_0.bypass_r        = pa_0_bypass_r;
  defparam pa_0.bypass_s        = pa_0_bypass_s;
  defparam pa_0.w               = pa_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_pa_0_run1                                                  = 0;
  defparam  pa_0.R_run1                                                  = R_pa_0_run1;
  parameter R_pa_0_bypass                                                = 1;
  defparam  pa_0.R_bypass                                                = R_pa_0_bypass;
  parameter R_pa_0_linInt_amp_lut_linInt_wrAdr                           = 2;
  defparam  pa_0.R_linInt_amp_lut_linInt_wrAdr                           = R_pa_0_linInt_amp_lut_linInt_wrAdr;
  parameter R_pa_0_linInt_amp_lut_linInt_wrDatHi                         = 3;
  defparam  pa_0.R_linInt_amp_lut_linInt_wrDatHi                         = R_pa_0_linInt_amp_lut_linInt_wrDatHi;
  parameter R_pa_0_linInt_amp_lut_linInt_wrDatLo                         = 4;
  defparam  pa_0.R_linInt_amp_lut_linInt_wrDatLo                         = R_pa_0_linInt_amp_lut_linInt_wrDatLo;
  parameter R_pa_0_linInt_amp_lut_linInt_simInit                         = 5;
  defparam  pa_0.R_linInt_amp_lut_linInt_simInit                         = R_pa_0_linInt_amp_lut_linInt_simInit;
  parameter R_pa_0_linInt_ph_lut_linInt_wrAdr                            = 6;
  defparam  pa_0.R_linInt_ph_lut_linInt_wrAdr                            = R_pa_0_linInt_ph_lut_linInt_wrAdr;
  parameter R_pa_0_linInt_ph_lut_linInt_wrDatHi                          = 7;
  defparam  pa_0.R_linInt_ph_lut_linInt_wrDatHi                          = R_pa_0_linInt_ph_lut_linInt_wrDatHi;
  parameter R_pa_0_linInt_ph_lut_linInt_wrDatLo                          = 8;
  defparam  pa_0.R_linInt_ph_lut_linInt_wrDatLo                          = R_pa_0_linInt_ph_lut_linInt_wrDatLo;
  parameter R_pa_0_linInt_ph_lut_linInt_simInit                          = 9;
  defparam  pa_0.R_linInt_ph_lut_linInt_simInit                          = R_pa_0_linInt_ph_lut_linInt_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                    [pa_0_yRe_w-1:0]  pa_0_yRe;
  wire                                      pa_0_yRe_or;
  wire                                      pa_0_yRe_ff;
  wire                                      pa_0_yRe_we;

  wire                    [pa_0_yIm_w-1:0]  pa_0_yIm;
  wire                                      pa_0_yIm_or;
  wire                                      pa_0_yIm_ff;
  wire                                      pa_0_yIm_we;

  wire                    [pa_0_xRe_w-1:0]  pa_0_xRe;
  wire                                      pa_0_xRe_ir;
  wire                                      pa_0_xRe_fe;
  wire                                      pa_0_xRe_re;

  wire                    [pa_0_xIm_w-1:0]  pa_0_xIm;
  wire                                      pa_0_xIm_ir;
  wire                                      pa_0_xIm_fe;
  wire                                      pa_0_xIm_re;

  wire                                      pa_0_regWe;
  wire                                      pa_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  pa pa_0(pa_0_yRe, pa_0_yRe_or, pa_0_yRe_ff, pa_0_yRe_we,
          pa_0_yIm, pa_0_yIm_or, pa_0_yIm_ff, pa_0_yIm_we,
          pa_0_xRe, pa_0_xRe_ir, pa_0_xRe_fe, pa_0_xRe_re, 
          pa_0_xIm, pa_0_xIm_ir, pa_0_xIm_fe, pa_0_xIm_re, 
          regBus, regWe, regRe, pa_0_regWe, pa_0_regRe, clk, clk2, reset);


//==============================================================================
