//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter multiPath_0_xRe_w           = 16;
  parameter multiPath_0_xIm_w           = 16;

  // Outputs
  parameter multiPath_0_yRe_w           = 16;
  parameter multiPath_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter multiPath_0_run1_w          = 1;
  parameter multiPath_0_run1_r          = 0;
  parameter multiPath_0_run1_s          = 0;

  // Parameters
  parameter multiPath_0_w               = 16;
  parameter multiPath_0_nc              = 10;
  parameter multiPath_0_nd              = 30;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires
  parameter multiPath_0_xRePlIm_w       = 17;
  parameter multiPath_0_xRePlIm_fe_w    = 1;

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam multiPath_0.xRe_w           = multiPath_0_xRe_w;
  defparam multiPath_0.xIm_w           = multiPath_0_xIm_w;
  defparam multiPath_0.yRe_w           = multiPath_0_yRe_w;
  defparam multiPath_0.yIm_w           = multiPath_0_yIm_w;
  defparam multiPath_0.run1_w          = multiPath_0_run1_w;
  defparam multiPath_0.run1_r          = multiPath_0_run1_r;
  defparam multiPath_0.run1_s          = multiPath_0_run1_s;
  defparam multiPath_0.w               = multiPath_0_w;
  defparam multiPath_0.nc              = multiPath_0_nc;
  defparam multiPath_0.nd              = multiPath_0_nd;
  defparam multiPath_0.xRePlIm_w       = multiPath_0_xRePlIm_w;
  defparam multiPath_0.xRePlIm_fe_w    = multiPath_0_xRePlIm_fe_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_multiPath_0_run1                                           = 0;
  defparam  multiPath_0.R_run1                                           = R_multiPath_0_run1;
  parameter R_multiPath_0_firCxMul_00_cRe                                = 1;
  defparam  multiPath_0.R_firCxMul_00_cRe                                = R_multiPath_0_firCxMul_00_cRe;
  parameter R_multiPath_0_firCxMul_00_cRePlIm                            = 2;
  defparam  multiPath_0.R_firCxMul_00_cRePlIm                            = R_multiPath_0_firCxMul_00_cRePlIm;
  parameter R_multiPath_0_firCxMul_00_cReMiIm                            = 3;
  defparam  multiPath_0.R_firCxMul_00_cReMiIm                            = R_multiPath_0_firCxMul_00_cReMiIm;
  parameter R_multiPath_0_firCxMul_01_cRe                                = 4;
  defparam  multiPath_0.R_firCxMul_01_cRe                                = R_multiPath_0_firCxMul_01_cRe;
  parameter R_multiPath_0_firCxMul_01_cRePlIm                            = 5;
  defparam  multiPath_0.R_firCxMul_01_cRePlIm                            = R_multiPath_0_firCxMul_01_cRePlIm;
  parameter R_multiPath_0_firCxMul_01_cReMiIm                            = 6;
  defparam  multiPath_0.R_firCxMul_01_cReMiIm                            = R_multiPath_0_firCxMul_01_cReMiIm;
  parameter R_multiPath_0_firCxMul_02_cRe                                = 7;
  defparam  multiPath_0.R_firCxMul_02_cRe                                = R_multiPath_0_firCxMul_02_cRe;
  parameter R_multiPath_0_firCxMul_02_cRePlIm                            = 8;
  defparam  multiPath_0.R_firCxMul_02_cRePlIm                            = R_multiPath_0_firCxMul_02_cRePlIm;
  parameter R_multiPath_0_firCxMul_02_cReMiIm                            = 9;
  defparam  multiPath_0.R_firCxMul_02_cReMiIm                            = R_multiPath_0_firCxMul_02_cReMiIm;
  parameter R_multiPath_0_firCxMul_03_cRe                                = 10;
  defparam  multiPath_0.R_firCxMul_03_cRe                                = R_multiPath_0_firCxMul_03_cRe;
  parameter R_multiPath_0_firCxMul_03_cRePlIm                            = 11;
  defparam  multiPath_0.R_firCxMul_03_cRePlIm                            = R_multiPath_0_firCxMul_03_cRePlIm;
  parameter R_multiPath_0_firCxMul_03_cReMiIm                            = 12;
  defparam  multiPath_0.R_firCxMul_03_cReMiIm                            = R_multiPath_0_firCxMul_03_cReMiIm;
  parameter R_multiPath_0_firCxMul_04_cRe                                = 13;
  defparam  multiPath_0.R_firCxMul_04_cRe                                = R_multiPath_0_firCxMul_04_cRe;
  parameter R_multiPath_0_firCxMul_04_cRePlIm                            = 14;
  defparam  multiPath_0.R_firCxMul_04_cRePlIm                            = R_multiPath_0_firCxMul_04_cRePlIm;
  parameter R_multiPath_0_firCxMul_04_cReMiIm                            = 15;
  defparam  multiPath_0.R_firCxMul_04_cReMiIm                            = R_multiPath_0_firCxMul_04_cReMiIm;
  parameter R_multiPath_0_firCxMul_05_cRe                                = 16;
  defparam  multiPath_0.R_firCxMul_05_cRe                                = R_multiPath_0_firCxMul_05_cRe;
  parameter R_multiPath_0_firCxMul_05_cRePlIm                            = 17;
  defparam  multiPath_0.R_firCxMul_05_cRePlIm                            = R_multiPath_0_firCxMul_05_cRePlIm;
  parameter R_multiPath_0_firCxMul_05_cReMiIm                            = 18;
  defparam  multiPath_0.R_firCxMul_05_cReMiIm                            = R_multiPath_0_firCxMul_05_cReMiIm;
  parameter R_multiPath_0_firCxMul_06_cRe                                = 19;
  defparam  multiPath_0.R_firCxMul_06_cRe                                = R_multiPath_0_firCxMul_06_cRe;
  parameter R_multiPath_0_firCxMul_06_cRePlIm                            = 20;
  defparam  multiPath_0.R_firCxMul_06_cRePlIm                            = R_multiPath_0_firCxMul_06_cRePlIm;
  parameter R_multiPath_0_firCxMul_06_cReMiIm                            = 21;
  defparam  multiPath_0.R_firCxMul_06_cReMiIm                            = R_multiPath_0_firCxMul_06_cReMiIm;
  parameter R_multiPath_0_firCxMul_07_cRe                                = 22;
  defparam  multiPath_0.R_firCxMul_07_cRe                                = R_multiPath_0_firCxMul_07_cRe;
  parameter R_multiPath_0_firCxMul_07_cRePlIm                            = 23;
  defparam  multiPath_0.R_firCxMul_07_cRePlIm                            = R_multiPath_0_firCxMul_07_cRePlIm;
  parameter R_multiPath_0_firCxMul_07_cReMiIm                            = 24;
  defparam  multiPath_0.R_firCxMul_07_cReMiIm                            = R_multiPath_0_firCxMul_07_cReMiIm;
  parameter R_multiPath_0_firCxMul_08_cRe                                = 25;
  defparam  multiPath_0.R_firCxMul_08_cRe                                = R_multiPath_0_firCxMul_08_cRe;
  parameter R_multiPath_0_firCxMul_08_cRePlIm                            = 26;
  defparam  multiPath_0.R_firCxMul_08_cRePlIm                            = R_multiPath_0_firCxMul_08_cRePlIm;
  parameter R_multiPath_0_firCxMul_08_cReMiIm                            = 27;
  defparam  multiPath_0.R_firCxMul_08_cReMiIm                            = R_multiPath_0_firCxMul_08_cReMiIm;
  parameter R_multiPath_0_firCxMul_09_cRe                                = 28;
  defparam  multiPath_0.R_firCxMul_09_cRe                                = R_multiPath_0_firCxMul_09_cRe;
  parameter R_multiPath_0_firCxMul_09_cRePlIm                            = 29;
  defparam  multiPath_0.R_firCxMul_09_cRePlIm                            = R_multiPath_0_firCxMul_09_cRePlIm;
  parameter R_multiPath_0_firCxMul_09_cReMiIm                            = 30;
  defparam  multiPath_0.R_firCxMul_09_cReMiIm                            = R_multiPath_0_firCxMul_09_cReMiIm;
  parameter R_multiPath_0_firMuxAdd_00_inpSel                            = 31;
  defparam  multiPath_0.R_firMuxAdd_00_inpSel                            = R_multiPath_0_firMuxAdd_00_inpSel;
  parameter R_multiPath_0_firMuxAdd_01_inpSel                            = 32;
  defparam  multiPath_0.R_firMuxAdd_01_inpSel                            = R_multiPath_0_firMuxAdd_01_inpSel;
  parameter R_multiPath_0_firMuxAdd_02_inpSel                            = 33;
  defparam  multiPath_0.R_firMuxAdd_02_inpSel                            = R_multiPath_0_firMuxAdd_02_inpSel;
  parameter R_multiPath_0_firMuxAdd_03_inpSel                            = 34;
  defparam  multiPath_0.R_firMuxAdd_03_inpSel                            = R_multiPath_0_firMuxAdd_03_inpSel;
  parameter R_multiPath_0_firMuxAdd_04_inpSel                            = 35;
  defparam  multiPath_0.R_firMuxAdd_04_inpSel                            = R_multiPath_0_firMuxAdd_04_inpSel;
  parameter R_multiPath_0_firMuxAdd_05_inpSel                            = 36;
  defparam  multiPath_0.R_firMuxAdd_05_inpSel                            = R_multiPath_0_firMuxAdd_05_inpSel;
  parameter R_multiPath_0_firMuxAdd_06_inpSel                            = 37;
  defparam  multiPath_0.R_firMuxAdd_06_inpSel                            = R_multiPath_0_firMuxAdd_06_inpSel;
  parameter R_multiPath_0_firMuxAdd_07_inpSel                            = 38;
  defparam  multiPath_0.R_firMuxAdd_07_inpSel                            = R_multiPath_0_firMuxAdd_07_inpSel;
  parameter R_multiPath_0_firMuxAdd_08_inpSel                            = 39;
  defparam  multiPath_0.R_firMuxAdd_08_inpSel                            = R_multiPath_0_firMuxAdd_08_inpSel;
  parameter R_multiPath_0_firMuxAdd_09_inpSel                            = 40;
  defparam  multiPath_0.R_firMuxAdd_09_inpSel                            = R_multiPath_0_firMuxAdd_09_inpSel;
  parameter R_multiPath_0_firMuxAdd_10_inpSel                            = 41;
  defparam  multiPath_0.R_firMuxAdd_10_inpSel                            = R_multiPath_0_firMuxAdd_10_inpSel;
  parameter R_multiPath_0_firMuxAdd_11_inpSel                            = 42;
  defparam  multiPath_0.R_firMuxAdd_11_inpSel                            = R_multiPath_0_firMuxAdd_11_inpSel;
  parameter R_multiPath_0_firMuxAdd_12_inpSel                            = 43;
  defparam  multiPath_0.R_firMuxAdd_12_inpSel                            = R_multiPath_0_firMuxAdd_12_inpSel;
  parameter R_multiPath_0_firMuxAdd_13_inpSel                            = 44;
  defparam  multiPath_0.R_firMuxAdd_13_inpSel                            = R_multiPath_0_firMuxAdd_13_inpSel;
  parameter R_multiPath_0_firMuxAdd_14_inpSel                            = 45;
  defparam  multiPath_0.R_firMuxAdd_14_inpSel                            = R_multiPath_0_firMuxAdd_14_inpSel;
  parameter R_multiPath_0_firMuxAdd_15_inpSel                            = 46;
  defparam  multiPath_0.R_firMuxAdd_15_inpSel                            = R_multiPath_0_firMuxAdd_15_inpSel;
  parameter R_multiPath_0_firMuxAdd_16_inpSel                            = 47;
  defparam  multiPath_0.R_firMuxAdd_16_inpSel                            = R_multiPath_0_firMuxAdd_16_inpSel;
  parameter R_multiPath_0_firMuxAdd_17_inpSel                            = 48;
  defparam  multiPath_0.R_firMuxAdd_17_inpSel                            = R_multiPath_0_firMuxAdd_17_inpSel;
  parameter R_multiPath_0_firMuxAdd_18_inpSel                            = 49;
  defparam  multiPath_0.R_firMuxAdd_18_inpSel                            = R_multiPath_0_firMuxAdd_18_inpSel;
  parameter R_multiPath_0_firMuxAdd_19_inpSel                            = 50;
  defparam  multiPath_0.R_firMuxAdd_19_inpSel                            = R_multiPath_0_firMuxAdd_19_inpSel;
  parameter R_multiPath_0_firMuxAdd_20_inpSel                            = 51;
  defparam  multiPath_0.R_firMuxAdd_20_inpSel                            = R_multiPath_0_firMuxAdd_20_inpSel;
  parameter R_multiPath_0_firMuxAdd_21_inpSel                            = 52;
  defparam  multiPath_0.R_firMuxAdd_21_inpSel                            = R_multiPath_0_firMuxAdd_21_inpSel;
  parameter R_multiPath_0_firMuxAdd_22_inpSel                            = 53;
  defparam  multiPath_0.R_firMuxAdd_22_inpSel                            = R_multiPath_0_firMuxAdd_22_inpSel;
  parameter R_multiPath_0_firMuxAdd_23_inpSel                            = 54;
  defparam  multiPath_0.R_firMuxAdd_23_inpSel                            = R_multiPath_0_firMuxAdd_23_inpSel;
  parameter R_multiPath_0_firMuxAdd_24_inpSel                            = 55;
  defparam  multiPath_0.R_firMuxAdd_24_inpSel                            = R_multiPath_0_firMuxAdd_24_inpSel;
  parameter R_multiPath_0_firMuxAdd_25_inpSel                            = 56;
  defparam  multiPath_0.R_firMuxAdd_25_inpSel                            = R_multiPath_0_firMuxAdd_25_inpSel;
  parameter R_multiPath_0_firMuxAdd_26_inpSel                            = 57;
  defparam  multiPath_0.R_firMuxAdd_26_inpSel                            = R_multiPath_0_firMuxAdd_26_inpSel;
  parameter R_multiPath_0_firMuxAdd_27_inpSel                            = 58;
  defparam  multiPath_0.R_firMuxAdd_27_inpSel                            = R_multiPath_0_firMuxAdd_27_inpSel;
  parameter R_multiPath_0_firMuxAdd_28_inpSel                            = 59;
  defparam  multiPath_0.R_firMuxAdd_28_inpSel                            = R_multiPath_0_firMuxAdd_28_inpSel;
  parameter R_multiPath_0_firMuxAdd_29_inpSel                            = 60;
  defparam  multiPath_0.R_firMuxAdd_29_inpSel                            = R_multiPath_0_firMuxAdd_29_inpSel;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [multiPath_0_yRe_w-1:0]  multiPath_0_yRe;
  wire                                      multiPath_0_yRe_or;
  wire                                      multiPath_0_yRe_ff;
  wire                                      multiPath_0_yRe_we;

  wire             [multiPath_0_yIm_w-1:0]  multiPath_0_yIm;
  wire                                      multiPath_0_yIm_or;
  wire                                      multiPath_0_yIm_ff;
  wire                                      multiPath_0_yIm_we;

  wire             [multiPath_0_xRe_w-1:0]  multiPath_0_xRe;
  wire                                      multiPath_0_xRe_ir;
  wire                                      multiPath_0_xRe_fe;
  wire                                      multiPath_0_xRe_re;

  wire             [multiPath_0_xIm_w-1:0]  multiPath_0_xIm;
  wire                                      multiPath_0_xIm_ir;
  wire                                      multiPath_0_xIm_fe;
  wire                                      multiPath_0_xIm_re;

  wire                                      multiPath_0_regWe;
  wire                                      multiPath_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  multiPath multiPath_0(multiPath_0_yRe, multiPath_0_yRe_or, multiPath_0_yRe_ff, multiPath_0_yRe_we,
                        multiPath_0_yIm, multiPath_0_yIm_or, multiPath_0_yIm_ff, multiPath_0_yIm_we,
                        multiPath_0_xRe, multiPath_0_xRe_ir, multiPath_0_xRe_fe, multiPath_0_xRe_re, 
                        multiPath_0_xIm, multiPath_0_xIm_ir, multiPath_0_xIm_fe, multiPath_0_xIm_re, 
                        regBus, regWe, regRe, multiPath_0_regWe, multiPath_0_regRe, clk, clk2, reset);


//==============================================================================
