//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mainTx_0_xRe_w           = 12;
  parameter mainTx_0_xIm_w           = 12;

  // Outputs
  parameter mainTx_0_yRe_w           = 16;
  parameter mainTx_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter mainTx_0_wx              = 12;
  parameter mainTx_0_wy              = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mainTx_0.xRe_w           = mainTx_0_xRe_w;
  defparam mainTx_0.xIm_w           = mainTx_0_xIm_w;
  defparam mainTx_0.yRe_w           = mainTx_0_yRe_w;
  defparam mainTx_0.yIm_w           = mainTx_0_yIm_w;
  defparam mainTx_0.wx              = mainTx_0_wx;
  defparam mainTx_0.wy              = mainTx_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mainTx_0_dacSim_0_run1                                     = 0;
  defparam  mainTx_0.R_dacSim_0_run1                                     = R_mainTx_0_dacSim_0_run1;
  parameter R_mainTx_0_dacSim_0_pLo16                                    = 1;
  defparam  mainTx_0.R_dacSim_0_pLo16                                    = R_mainTx_0_dacSim_0_pLo16;
  parameter R_mainTx_0_dacSim_0_pHi16                                    = 2;
  defparam  mainTx_0.R_dacSim_0_pHi16                                    = R_mainTx_0_dacSim_0_pHi16;
  parameter R_mainTx_0_dacSim_0_qLo16                                    = 3;
  defparam  mainTx_0.R_dacSim_0_qLo16                                    = R_mainTx_0_dacSim_0_qLo16;
  parameter R_mainTx_0_dacSim_0_qHi16                                    = 4;
  defparam  mainTx_0.R_dacSim_0_qHi16                                    = R_mainTx_0_dacSim_0_qHi16;
  parameter R_mainTx_0_txScale_0_run1                                    = 5;
  defparam  mainTx_0.R_txScale_0_run1                                    = R_mainTx_0_txScale_0_run1;
  parameter R_mainTx_0_txScale_0_txFactor                                = 6;
  defparam  mainTx_0.R_txScale_0_txFactor                                = R_mainTx_0_txScale_0_txFactor;
  parameter R_mainTx_0_iqImb_0_run1                                      = 7;
  defparam  mainTx_0.R_iqImb_0_run1                                      = R_mainTx_0_iqImb_0_run1;
  parameter R_mainTx_0_iqImb_0_a                                         = 8;
  defparam  mainTx_0.R_iqImb_0_a                                         = R_mainTx_0_iqImb_0_a;
  parameter R_mainTx_0_iqImb_0_b                                         = 9;
  defparam  mainTx_0.R_iqImb_0_b                                         = R_mainTx_0_iqImb_0_b;
  parameter R_mainTx_0_iqImb_0_c                                         = 10;
  defparam  mainTx_0.R_iqImb_0_c                                         = R_mainTx_0_iqImb_0_c;
  parameter R_mainTx_0_dcOff_0_run1                                      = 11;
  defparam  mainTx_0.R_dcOff_0_run1                                      = R_mainTx_0_dcOff_0_run1;
  parameter R_mainTx_0_dcOff_0_dcRe                                      = 12;
  defparam  mainTx_0.R_dcOff_0_dcRe                                      = R_mainTx_0_dcOff_0_dcRe;
  parameter R_mainTx_0_dcOff_0_dcIm                                      = 13;
  defparam  mainTx_0.R_dcOff_0_dcIm                                      = R_mainTx_0_dcOff_0_dcIm;
  parameter R_mainTx_0_pa_0_run1                                         = 14;
  defparam  mainTx_0.R_pa_0_run1                                         = R_mainTx_0_pa_0_run1;
  parameter R_mainTx_0_pa_0_bypass                                       = 15;
  defparam  mainTx_0.R_pa_0_bypass                                       = R_mainTx_0_pa_0_bypass;
  parameter R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr                  = 16;
  defparam  mainTx_0.R_pa_0_linInt_amp_lut_linInt_wrAdr                  = R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrAdr;
  parameter R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi                = 17;
  defparam  mainTx_0.R_pa_0_linInt_amp_lut_linInt_wrDatHi                = R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatHi;
  parameter R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo                = 18;
  defparam  mainTx_0.R_pa_0_linInt_amp_lut_linInt_wrDatLo                = R_mainTx_0_pa_0_linInt_amp_lut_linInt_wrDatLo;
  parameter R_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit                = 19;
  defparam  mainTx_0.R_pa_0_linInt_amp_lut_linInt_simInit                = R_mainTx_0_pa_0_linInt_amp_lut_linInt_simInit;
  parameter R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr                   = 20;
  defparam  mainTx_0.R_pa_0_linInt_ph_lut_linInt_wrAdr                   = R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrAdr;
  parameter R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi                 = 21;
  defparam  mainTx_0.R_pa_0_linInt_ph_lut_linInt_wrDatHi                 = R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatHi;
  parameter R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo                 = 22;
  defparam  mainTx_0.R_pa_0_linInt_ph_lut_linInt_wrDatLo                 = R_mainTx_0_pa_0_linInt_ph_lut_linInt_wrDatLo;
  parameter R_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit                 = 23;
  defparam  mainTx_0.R_pa_0_linInt_ph_lut_linInt_simInit                 = R_mainTx_0_pa_0_linInt_ph_lut_linInt_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [mainTx_0_yRe_w-1:0]  mainTx_0_yRe;
  wire                                      mainTx_0_yRe_or;
  wire                                      mainTx_0_yRe_ff;
  wire                                      mainTx_0_yRe_we;

  wire                [mainTx_0_yIm_w-1:0]  mainTx_0_yIm;
  wire                                      mainTx_0_yIm_or;
  wire                                      mainTx_0_yIm_ff;
  wire                                      mainTx_0_yIm_we;

  wire                [mainTx_0_xRe_w-1:0]  mainTx_0_xRe;
  wire                                      mainTx_0_xRe_ir;
  wire                                      mainTx_0_xRe_fe;
  wire                                      mainTx_0_xRe_re;

  wire                [mainTx_0_xIm_w-1:0]  mainTx_0_xIm;
  wire                                      mainTx_0_xIm_ir;
  wire                                      mainTx_0_xIm_fe;
  wire                                      mainTx_0_xIm_re;

  wire                                      mainTx_0_regWe;
  wire                                      mainTx_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mainTx mainTx_0(mainTx_0_yRe, mainTx_0_yRe_or, mainTx_0_yRe_ff, mainTx_0_yRe_we,
                  mainTx_0_yIm, mainTx_0_yIm_or, mainTx_0_yIm_ff, mainTx_0_yIm_we,
                  mainTx_0_xRe, mainTx_0_xRe_ir, mainTx_0_xRe_fe, mainTx_0_xRe_re, 
                  mainTx_0_xIm, mainTx_0_xIm_ir, mainTx_0_xIm_fe, mainTx_0_xIm_re, 
                  regBus, regWe, regRe, mainTx_0_regWe, mainTx_0_regRe, clk, clk2, reset);


//==============================================================================
