//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mainRx_0_xRe_w           = 32;
  parameter mainRx_0_xIm_w           = 32;

  // Outputs
  parameter mainRx_0_yRe_w           = 12;
  parameter mainRx_0_yIm_w           = 12;

  // Input control lines
  parameter mainRx_0_gainSel_w       = 7;

  // Output control lines

  // Eregs

  // Parameters
  parameter mainRx_0_wx              = 32;
  parameter mainRx_0_wy              = 12;
  parameter mainRx_0_wg              = 7;
  parameter mainRx_0_wf              = 8;
  parameter mainRx_0_ws              = 6;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mainRx_0.xRe_w           = mainRx_0_xRe_w;
  defparam mainRx_0.xIm_w           = mainRx_0_xIm_w;
  defparam mainRx_0.yRe_w           = mainRx_0_yRe_w;
  defparam mainRx_0.yIm_w           = mainRx_0_yIm_w;
  defparam mainRx_0.gainSel_w       = mainRx_0_gainSel_w;
  defparam mainRx_0.wx              = mainRx_0_wx;
  defparam mainRx_0.wy              = mainRx_0_wy;
  defparam mainRx_0.wg              = mainRx_0_wg;
  defparam mainRx_0.wf              = mainRx_0_wf;
  defparam mainRx_0.ws              = mainRx_0_ws;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mainRx_0_awgn_0_run1                                       = 0;
  defparam  mainRx_0.R_awgn_0_run1                                       = R_mainRx_0_awgn_0_run1;
  parameter R_mainRx_0_gainCtrl_0_run1                                   = 1;
  defparam  mainRx_0.R_gainCtrl_0_run1                                   = R_mainRx_0_gainCtrl_0_run1;
  parameter R_mainRx_0_gainCtrl_0_gainDelay                              = 2;
  defparam  mainRx_0.R_gainCtrl_0_gainDelay                              = R_mainRx_0_gainCtrl_0_gainDelay;
  parameter R_mainRx_0_gainCtrl_0_lut_gc_wrAdr                           = 3;
  defparam  mainRx_0.R_gainCtrl_0_lut_gc_wrAdr                           = R_mainRx_0_gainCtrl_0_lut_gc_wrAdr;
  parameter R_mainRx_0_gainCtrl_0_lut_gc_wrDatHi                         = 4;
  defparam  mainRx_0.R_gainCtrl_0_lut_gc_wrDatHi                         = R_mainRx_0_gainCtrl_0_lut_gc_wrDatHi;
  parameter R_mainRx_0_gainCtrl_0_lut_gc_wrDatLo                         = 5;
  defparam  mainRx_0.R_gainCtrl_0_lut_gc_wrDatLo                         = R_mainRx_0_gainCtrl_0_lut_gc_wrDatLo;
  parameter R_mainRx_0_gainCtrl_0_lut_gc_simInit                         = 6;
  defparam  mainRx_0.R_gainCtrl_0_lut_gc_simInit                         = R_mainRx_0_gainCtrl_0_lut_gc_simInit;
  parameter R_mainRx_0_iqImb_0_run1                                      = 7;
  defparam  mainRx_0.R_iqImb_0_run1                                      = R_mainRx_0_iqImb_0_run1;
  parameter R_mainRx_0_iqImb_0_a                                         = 8;
  defparam  mainRx_0.R_iqImb_0_a                                         = R_mainRx_0_iqImb_0_a;
  parameter R_mainRx_0_iqImb_0_b                                         = 9;
  defparam  mainRx_0.R_iqImb_0_b                                         = R_mainRx_0_iqImb_0_b;
  parameter R_mainRx_0_iqImb_0_c                                         = 10;
  defparam  mainRx_0.R_iqImb_0_c                                         = R_mainRx_0_iqImb_0_c;
  parameter R_mainRx_0_dcOff_0_run1                                      = 11;
  defparam  mainRx_0.R_dcOff_0_run1                                      = R_mainRx_0_dcOff_0_run1;
  parameter R_mainRx_0_dcOff_0_dcRe                                      = 12;
  defparam  mainRx_0.R_dcOff_0_dcRe                                      = R_mainRx_0_dcOff_0_dcRe;
  parameter R_mainRx_0_dcOff_0_dcIm                                      = 13;
  defparam  mainRx_0.R_dcOff_0_dcIm                                      = R_mainRx_0_dcOff_0_dcIm;
  parameter R_mainRx_0_shrRndSat_0_run1                                  = 14;
  defparam  mainRx_0.R_shrRndSat_0_run1                                  = R_mainRx_0_shrRndSat_0_run1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [mainRx_0_yRe_w-1:0]  mainRx_0_yRe;
  wire                                      mainRx_0_yRe_or;
  wire                                      mainRx_0_yRe_ff;
  wire                                      mainRx_0_yRe_we;

  wire                [mainRx_0_yIm_w-1:0]  mainRx_0_yIm;
  wire                                      mainRx_0_yIm_or;
  wire                                      mainRx_0_yIm_ff;
  wire                                      mainRx_0_yIm_we;

  wire                [mainRx_0_xRe_w-1:0]  mainRx_0_xRe;
  wire                                      mainRx_0_xRe_ir;
  wire                                      mainRx_0_xRe_fe;
  wire                                      mainRx_0_xRe_re;

  wire                [mainRx_0_xIm_w-1:0]  mainRx_0_xIm;
  wire                                      mainRx_0_xIm_ir;
  wire                                      mainRx_0_xIm_fe;
  wire                                      mainRx_0_xIm_re;

  wire            [mainRx_0_gainSel_w-1:0]  mainRx_0_gainSel;

  wire                                      mainRx_0_regWe;
  wire                                      mainRx_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mainRx mainRx_0(mainRx_0_yRe, mainRx_0_yRe_or, mainRx_0_yRe_ff, mainRx_0_yRe_we,
                  mainRx_0_yIm, mainRx_0_yIm_or, mainRx_0_yIm_ff, mainRx_0_yIm_we,
                  mainRx_0_xRe, mainRx_0_xRe_ir, mainRx_0_xRe_fe, mainRx_0_xRe_re, 
                  mainRx_0_xIm, mainRx_0_xIm_ir, mainRx_0_xIm_fe, mainRx_0_xIm_re, 
                  mainRx_0_gainSel, 
                  regBus, regWe, regRe, mainRx_0_regWe, mainRx_0_regRe, clk, clk2, reset);


//==============================================================================
