//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mainChan_0_xRe_w           = 16;
  parameter mainChan_0_xIm_w           = 16;

  // Outputs
  parameter mainChan_0_yRe_w           = 32;
  parameter mainChan_0_yIm_w           = 32;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter mainChan_0_wx              = 16;
  parameter mainChan_0_wy              = 32;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter mainChan_0_tOffInRe_w      = 16;
  parameter mainChan_0_tOffInRe_n      = 3;
  parameter mainChan_0_tOffInRe_m      = 2;
  parameter mainChan_0_tOffInIm_w      = 16;
  parameter mainChan_0_tOffInIm_n      = 3;
  parameter mainChan_0_tOffInIm_m      = 2;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mainChan_0.xRe_w           = mainChan_0_xRe_w;
  defparam mainChan_0.xIm_w           = mainChan_0_xIm_w;
  defparam mainChan_0.yRe_w           = mainChan_0_yRe_w;
  defparam mainChan_0.yIm_w           = mainChan_0_yIm_w;
  defparam mainChan_0.wx              = mainChan_0_wx;
  defparam mainChan_0.wy              = mainChan_0_wy;
  defparam mainChan_0.tOffInRe_w      = mainChan_0_tOffInRe_w;
  defparam mainChan_0.tOffInRe_m      = mainChan_0_tOffInRe_m;
  defparam mainChan_0.tOffInRe_n      = mainChan_0_tOffInRe_n;
  defparam mainChan_0.tOffInIm_w      = mainChan_0_tOffInIm_w;
  defparam mainChan_0.tOffInIm_m      = mainChan_0_tOffInIm_m;
  defparam mainChan_0.tOffInIm_n      = mainChan_0_tOffInIm_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mainChan_0_multiPath_0_run1                                = 0;
  defparam  mainChan_0.R_multiPath_0_run1                                = R_mainChan_0_multiPath_0_run1;
  parameter R_mainChan_0_multiPath_0_firCxMul_00_cRe                     = 1;
  defparam  mainChan_0.R_multiPath_0_firCxMul_00_cRe                     = R_mainChan_0_multiPath_0_firCxMul_00_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_00_cRePlIm                 = 2;
  defparam  mainChan_0.R_multiPath_0_firCxMul_00_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_00_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_00_cReMiIm                 = 3;
  defparam  mainChan_0.R_multiPath_0_firCxMul_00_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_00_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_01_cRe                     = 4;
  defparam  mainChan_0.R_multiPath_0_firCxMul_01_cRe                     = R_mainChan_0_multiPath_0_firCxMul_01_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_01_cRePlIm                 = 5;
  defparam  mainChan_0.R_multiPath_0_firCxMul_01_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_01_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_01_cReMiIm                 = 6;
  defparam  mainChan_0.R_multiPath_0_firCxMul_01_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_01_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_02_cRe                     = 7;
  defparam  mainChan_0.R_multiPath_0_firCxMul_02_cRe                     = R_mainChan_0_multiPath_0_firCxMul_02_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_02_cRePlIm                 = 8;
  defparam  mainChan_0.R_multiPath_0_firCxMul_02_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_02_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_02_cReMiIm                 = 9;
  defparam  mainChan_0.R_multiPath_0_firCxMul_02_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_02_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_03_cRe                     = 10;
  defparam  mainChan_0.R_multiPath_0_firCxMul_03_cRe                     = R_mainChan_0_multiPath_0_firCxMul_03_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_03_cRePlIm                 = 11;
  defparam  mainChan_0.R_multiPath_0_firCxMul_03_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_03_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_03_cReMiIm                 = 12;
  defparam  mainChan_0.R_multiPath_0_firCxMul_03_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_03_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_04_cRe                     = 13;
  defparam  mainChan_0.R_multiPath_0_firCxMul_04_cRe                     = R_mainChan_0_multiPath_0_firCxMul_04_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_04_cRePlIm                 = 14;
  defparam  mainChan_0.R_multiPath_0_firCxMul_04_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_04_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_04_cReMiIm                 = 15;
  defparam  mainChan_0.R_multiPath_0_firCxMul_04_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_04_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_05_cRe                     = 16;
  defparam  mainChan_0.R_multiPath_0_firCxMul_05_cRe                     = R_mainChan_0_multiPath_0_firCxMul_05_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_05_cRePlIm                 = 17;
  defparam  mainChan_0.R_multiPath_0_firCxMul_05_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_05_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_05_cReMiIm                 = 18;
  defparam  mainChan_0.R_multiPath_0_firCxMul_05_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_05_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_06_cRe                     = 19;
  defparam  mainChan_0.R_multiPath_0_firCxMul_06_cRe                     = R_mainChan_0_multiPath_0_firCxMul_06_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_06_cRePlIm                 = 20;
  defparam  mainChan_0.R_multiPath_0_firCxMul_06_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_06_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_06_cReMiIm                 = 21;
  defparam  mainChan_0.R_multiPath_0_firCxMul_06_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_06_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_07_cRe                     = 22;
  defparam  mainChan_0.R_multiPath_0_firCxMul_07_cRe                     = R_mainChan_0_multiPath_0_firCxMul_07_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_07_cRePlIm                 = 23;
  defparam  mainChan_0.R_multiPath_0_firCxMul_07_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_07_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_07_cReMiIm                 = 24;
  defparam  mainChan_0.R_multiPath_0_firCxMul_07_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_07_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_08_cRe                     = 25;
  defparam  mainChan_0.R_multiPath_0_firCxMul_08_cRe                     = R_mainChan_0_multiPath_0_firCxMul_08_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_08_cRePlIm                 = 26;
  defparam  mainChan_0.R_multiPath_0_firCxMul_08_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_08_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_08_cReMiIm                 = 27;
  defparam  mainChan_0.R_multiPath_0_firCxMul_08_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_08_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_09_cRe                     = 28;
  defparam  mainChan_0.R_multiPath_0_firCxMul_09_cRe                     = R_mainChan_0_multiPath_0_firCxMul_09_cRe;
  parameter R_mainChan_0_multiPath_0_firCxMul_09_cRePlIm                 = 29;
  defparam  mainChan_0.R_multiPath_0_firCxMul_09_cRePlIm                 = R_mainChan_0_multiPath_0_firCxMul_09_cRePlIm;
  parameter R_mainChan_0_multiPath_0_firCxMul_09_cReMiIm                 = 30;
  defparam  mainChan_0.R_multiPath_0_firCxMul_09_cReMiIm                 = R_mainChan_0_multiPath_0_firCxMul_09_cReMiIm;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_00_inpSel                 = 31;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_00_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_00_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_01_inpSel                 = 32;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_01_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_01_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_02_inpSel                 = 33;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_02_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_02_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_03_inpSel                 = 34;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_03_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_03_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_04_inpSel                 = 35;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_04_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_04_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_05_inpSel                 = 36;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_05_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_05_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_06_inpSel                 = 37;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_06_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_06_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_07_inpSel                 = 38;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_07_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_07_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_08_inpSel                 = 39;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_08_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_08_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_09_inpSel                 = 40;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_09_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_09_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_10_inpSel                 = 41;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_10_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_10_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_11_inpSel                 = 42;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_11_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_11_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_12_inpSel                 = 43;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_12_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_12_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_13_inpSel                 = 44;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_13_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_13_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_14_inpSel                 = 45;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_14_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_14_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_15_inpSel                 = 46;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_15_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_15_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_16_inpSel                 = 47;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_16_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_16_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_17_inpSel                 = 48;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_17_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_17_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_18_inpSel                 = 49;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_18_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_18_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_19_inpSel                 = 50;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_19_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_19_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_20_inpSel                 = 51;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_20_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_20_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_21_inpSel                 = 52;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_21_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_21_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_22_inpSel                 = 53;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_22_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_22_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_23_inpSel                 = 54;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_23_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_23_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_24_inpSel                 = 55;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_24_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_24_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_25_inpSel                 = 56;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_25_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_25_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_26_inpSel                 = 57;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_26_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_26_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_27_inpSel                 = 58;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_27_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_27_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_28_inpSel                 = 59;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_28_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_28_inpSel;
  parameter R_mainChan_0_multiPath_0_firMuxAdd_29_inpSel                 = 60;
  defparam  mainChan_0.R_multiPath_0_firMuxAdd_29_inpSel                 = R_mainChan_0_multiPath_0_firMuxAdd_29_inpSel;
  parameter R_mainChan_0_timeOff_0_firToff_0_run1                        = 61;
  defparam  mainChan_0.R_timeOff_0_firToff_0_run1                        = R_mainChan_0_timeOff_0_firToff_0_run1;
  parameter R_mainChan_0_timeOff_0_coeffToff_0_run1                      = 62;
  defparam  mainChan_0.R_timeOff_0_coeffToff_0_run1                      = R_mainChan_0_timeOff_0_coeffToff_0_run1;
  parameter R_mainChan_0_timeOff_0_coeffToff_0_byPass                    = 63;
  defparam  mainChan_0.R_timeOff_0_coeffToff_0_byPass                    = R_mainChan_0_timeOff_0_coeffToff_0_byPass;
  parameter R_mainChan_0_timeOff_0_coeffToff_0_tOffLo16                  = 64;
  defparam  mainChan_0.R_timeOff_0_coeffToff_0_tOffLo16                  = R_mainChan_0_timeOff_0_coeffToff_0_tOffLo16;
  parameter R_mainChan_0_timeOff_0_coeffToff_0_tOffMi16                  = 65;
  defparam  mainChan_0.R_timeOff_0_coeffToff_0_tOffMi16                  = R_mainChan_0_timeOff_0_coeffToff_0_tOffMi16;
  parameter R_mainChan_0_timeOff_0_coeffToff_0_tOffHi16                  = 66;
  defparam  mainChan_0.R_timeOff_0_coeffToff_0_tOffHi16                  = R_mainChan_0_timeOff_0_coeffToff_0_tOffHi16;
  parameter R_mainChan_0_freqOff_0_run1                                  = 67;
  defparam  mainChan_0.R_freqOff_0_run1                                  = R_mainChan_0_freqOff_0_run1;
  parameter R_mainChan_0_freqOff_0_freqOffLo16                           = 68;
  defparam  mainChan_0.R_freqOff_0_freqOffLo16                           = R_mainChan_0_freqOff_0_freqOffLo16;
  parameter R_mainChan_0_freqOff_0_freqOffMi16                           = 69;
  defparam  mainChan_0.R_freqOff_0_freqOffMi16                           = R_mainChan_0_freqOff_0_freqOffMi16;
  parameter R_mainChan_0_freqOff_0_freqOffHi16                           = 70;
  defparam  mainChan_0.R_freqOff_0_freqOffHi16                           = R_mainChan_0_freqOff_0_freqOffHi16;
  parameter R_mainChan_0_gainChan_0_run1                                 = 71;
  defparam  mainChan_0.R_gainChan_0_run1                                 = R_mainChan_0_gainChan_0_run1;
  parameter R_mainChan_0_gainChan_0_gainFactor                           = 72;
  defparam  mainChan_0.R_gainChan_0_gainFactor                           = R_mainChan_0_gainChan_0_gainFactor;
  parameter R_mainChan_0_gainChan_0_gainShift                            = 73;
  defparam  mainChan_0.R_gainChan_0_gainShift                            = R_mainChan_0_gainChan_0_gainShift;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_mainChan_0_tOffInRe                                        = 74;
  defparam  mainChan_0.R_tOffInRe                                        = R_mainChan_0_tOffInRe;
  parameter R_mainChan_0_tOffInIm                                        = 75;
  defparam  mainChan_0.R_tOffInIm                                        = R_mainChan_0_tOffInIm;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [mainChan_0_yRe_w-1:0]  mainChan_0_yRe;
  wire                                      mainChan_0_yRe_or;
  wire                                      mainChan_0_yRe_ff;
  wire                                      mainChan_0_yRe_we;

  wire              [mainChan_0_yIm_w-1:0]  mainChan_0_yIm;
  wire                                      mainChan_0_yIm_or;
  wire                                      mainChan_0_yIm_ff;
  wire                                      mainChan_0_yIm_we;

  wire              [mainChan_0_xRe_w-1:0]  mainChan_0_xRe;
  wire                                      mainChan_0_xRe_ir;
  wire                                      mainChan_0_xRe_fe;
  wire                                      mainChan_0_xRe_re;

  wire              [mainChan_0_xIm_w-1:0]  mainChan_0_xIm;
  wire                                      mainChan_0_xIm_ir;
  wire                                      mainChan_0_xIm_fe;
  wire                                      mainChan_0_xIm_re;

  wire                                      mainChan_0_regWe;
  wire                                      mainChan_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mainChan mainChan_0(mainChan_0_yRe, mainChan_0_yRe_or, mainChan_0_yRe_ff, mainChan_0_yRe_we,
                      mainChan_0_yIm, mainChan_0_yIm_or, mainChan_0_yIm_ff, mainChan_0_yIm_we,
                      mainChan_0_xRe, mainChan_0_xRe_ir, mainChan_0_xRe_fe, mainChan_0_xRe_re, 
                      mainChan_0_xIm, mainChan_0_xIm_ir, mainChan_0_xIm_fe, mainChan_0_xIm_re, 
                      regBus, regWe, regRe, mainChan_0_regWe, mainChan_0_regRe, clk, clk2, reset);


//==============================================================================
