//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lut_linInt_adr_w           = 9;

  // Outputs
  parameter lut_linInt_dat_w           = 32;

  // Input control lines

  // Output control lines

  // Eregs
  parameter lut_linInt_wrAdr_w         = 9;
  parameter lut_linInt_wrAdr_r         = 0;
  parameter lut_linInt_wrAdr_s         = 0;
  parameter lut_linInt_wrDatHi_w       = 16;
  parameter lut_linInt_wrDatHi_r       = 0;
  parameter lut_linInt_wrDatHi_s       = 0;
  parameter lut_linInt_wrDatLo_w       = 16;
  parameter lut_linInt_wrDatLo_r       = 0;
  parameter lut_linInt_wrDatLo_s       = 0;
  parameter lut_linInt_simInit_w       = 1;
  parameter lut_linInt_simInit_r       = 0;
  parameter lut_linInt_simInit_s       = 0;

  // Parameters
  parameter lut_linInt_w               = 32;
  parameter lut_linInt_n               = 512;
  parameter lut_linInt_m               = 9;
  parameter lut_linInt_lutDat          = 0;

  // Iregs

  // Single ported memories
  parameter lut_linInt_lutMem_w        = 32;
  parameter lut_linInt_lutMem_n        = 512;
  parameter lut_linInt_lutMem_m        = `CLOG2(512);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lut_linInt.adr_w           = lut_linInt_adr_w;
  defparam lut_linInt.dat_w           = lut_linInt_dat_w;
  defparam lut_linInt.wrAdr_w         = lut_linInt_wrAdr_w;
  defparam lut_linInt.wrAdr_r         = lut_linInt_wrAdr_r;
  defparam lut_linInt.wrAdr_s         = lut_linInt_wrAdr_s;
  defparam lut_linInt.wrDatHi_w       = lut_linInt_wrDatHi_w;
  defparam lut_linInt.wrDatHi_r       = lut_linInt_wrDatHi_r;
  defparam lut_linInt.wrDatHi_s       = lut_linInt_wrDatHi_s;
  defparam lut_linInt.wrDatLo_w       = lut_linInt_wrDatLo_w;
  defparam lut_linInt.wrDatLo_r       = lut_linInt_wrDatLo_r;
  defparam lut_linInt.wrDatLo_s       = lut_linInt_wrDatLo_s;
  defparam lut_linInt.simInit_w       = lut_linInt_simInit_w;
  defparam lut_linInt.simInit_r       = lut_linInt_simInit_r;
  defparam lut_linInt.simInit_s       = lut_linInt_simInit_s;
  defparam lut_linInt.w               = lut_linInt_w;
  defparam lut_linInt.n               = lut_linInt_n;
  defparam lut_linInt.m               = lut_linInt_m;
  defparam lut_linInt.lutDat          = lut_linInt_lutDat;
  defparam lut_linInt.lutMem_w        = lut_linInt_lutMem_w;
  defparam lut_linInt.lutMem_n        = lut_linInt_lutMem_n;
  defparam lut_linInt.lutMem_m        = lut_linInt_lutMem_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_lut_linInt_wrAdr                                           = 0;
  defparam  lut_linInt.R_wrAdr                                           = R_lut_linInt_wrAdr;
  parameter R_lut_linInt_wrDatHi                                         = 1;
  defparam  lut_linInt.R_wrDatHi                                         = R_lut_linInt_wrDatHi;
  parameter R_lut_linInt_wrDatLo                                         = 2;
  defparam  lut_linInt.R_wrDatLo                                         = R_lut_linInt_wrDatLo;
  parameter R_lut_linInt_simInit                                         = 3;
  defparam  lut_linInt.R_simInit                                         = R_lut_linInt_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [lut_linInt_dat_w-1:0]  lut_linInt_dat;
  wire                                      lut_linInt_dat_or;
  wire                                      lut_linInt_dat_ff;
  wire                                      lut_linInt_dat_we;

  wire              [lut_linInt_adr_w-1:0]  lut_linInt_adr;
  wire                                      lut_linInt_adr_ir;
  wire                                      lut_linInt_adr_fe;
  wire                                      lut_linInt_adr_re;

  wire                                      lut_linInt_regWe;
  wire                                      lut_linInt_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lut lut_linInt(lut_linInt_dat, lut_linInt_dat_or, lut_linInt_dat_ff, lut_linInt_dat_we,
                 lut_linInt_adr, lut_linInt_adr_ir, lut_linInt_adr_fe, lut_linInt_adr_re, 
                 regBus, regWe, regRe, lut_linInt_regWe, lut_linInt_regRe, clk, clk2, reset);


//==============================================================================
