//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lut_gc_adr_w           = 7;

  // Outputs
  parameter lut_gc_dat_w           = 14;

  // Input control lines

  // Output control lines

  // Eregs
  parameter lut_gc_wrAdr_w         = 7;
  parameter lut_gc_wrAdr_r         = 0;
  parameter lut_gc_wrAdr_s         = 0;
  parameter lut_gc_wrDatHi_w       = 16;
  parameter lut_gc_wrDatHi_r       = 0;
  parameter lut_gc_wrDatHi_s       = 0;
  parameter lut_gc_wrDatLo_w       = 16;
  parameter lut_gc_wrDatLo_r       = 0;
  parameter lut_gc_wrDatLo_s       = 0;
  parameter lut_gc_simInit_w       = 1;
  parameter lut_gc_simInit_r       = 0;
  parameter lut_gc_simInit_s       = 0;

  // Parameters
  parameter lut_gc_w               = 14;
  parameter lut_gc_n               = 128;
  parameter lut_gc_m               = 7;
  parameter lut_gc_lutDat          = 0;

  // Iregs

  // Single ported memories
  parameter lut_gc_lutMem_w        = 14;
  parameter lut_gc_lutMem_n        = 128;
  parameter lut_gc_lutMem_m        = `CLOG2(128);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lut_gc.adr_w           = lut_gc_adr_w;
  defparam lut_gc.dat_w           = lut_gc_dat_w;
  defparam lut_gc.wrAdr_w         = lut_gc_wrAdr_w;
  defparam lut_gc.wrAdr_r         = lut_gc_wrAdr_r;
  defparam lut_gc.wrAdr_s         = lut_gc_wrAdr_s;
  defparam lut_gc.wrDatHi_w       = lut_gc_wrDatHi_w;
  defparam lut_gc.wrDatHi_r       = lut_gc_wrDatHi_r;
  defparam lut_gc.wrDatHi_s       = lut_gc_wrDatHi_s;
  defparam lut_gc.wrDatLo_w       = lut_gc_wrDatLo_w;
  defparam lut_gc.wrDatLo_r       = lut_gc_wrDatLo_r;
  defparam lut_gc.wrDatLo_s       = lut_gc_wrDatLo_s;
  defparam lut_gc.simInit_w       = lut_gc_simInit_w;
  defparam lut_gc.simInit_r       = lut_gc_simInit_r;
  defparam lut_gc.simInit_s       = lut_gc_simInit_s;
  defparam lut_gc.w               = lut_gc_w;
  defparam lut_gc.n               = lut_gc_n;
  defparam lut_gc.m               = lut_gc_m;
  defparam lut_gc.lutDat          = lut_gc_lutDat;
  defparam lut_gc.lutMem_w        = lut_gc_lutMem_w;
  defparam lut_gc.lutMem_n        = lut_gc_lutMem_n;
  defparam lut_gc.lutMem_m        = lut_gc_lutMem_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_lut_gc_wrAdr                                               = 0;
  defparam  lut_gc.R_wrAdr                                               = R_lut_gc_wrAdr;
  parameter R_lut_gc_wrDatHi                                             = 1;
  defparam  lut_gc.R_wrDatHi                                             = R_lut_gc_wrDatHi;
  parameter R_lut_gc_wrDatLo                                             = 2;
  defparam  lut_gc.R_wrDatLo                                             = R_lut_gc_wrDatLo;
  parameter R_lut_gc_simInit                                             = 3;
  defparam  lut_gc.R_simInit                                             = R_lut_gc_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [lut_gc_dat_w-1:0]  lut_gc_dat;
  wire                                      lut_gc_dat_or;
  wire                                      lut_gc_dat_ff;
  wire                                      lut_gc_dat_we;

  wire                  [lut_gc_adr_w-1:0]  lut_gc_adr;
  wire                                      lut_gc_adr_ir;
  wire                                      lut_gc_adr_fe;
  wire                                      lut_gc_adr_re;

  wire                                      lut_gc_regWe;
  wire                                      lut_gc_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lut lut_gc(lut_gc_dat, lut_gc_dat_or, lut_gc_dat_ff, lut_gc_dat_we,
             lut_gc_adr, lut_gc_adr_ir, lut_gc_adr_fe, lut_gc_adr_re, 
             regBus, regWe, regRe, lut_gc_regWe, lut_gc_regRe, clk, clk2, reset);


//==============================================================================
