//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter linInt_ph_x_w             = 15;

  // Outputs
  parameter linInt_ph_y_w             = 16;

  // Input control lines
  parameter linInt_ph_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter linInt_ph_wa              = 9;
  parameter linInt_ph_wf              = 6;
  parameter linInt_ph_wb              = 16;
  parameter linInt_ph_wd              = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam linInt_ph.x_w             = linInt_ph_x_w;
  defparam linInt_ph.y_w             = linInt_ph_y_w;
  defparam linInt_ph.run1_w          = linInt_ph_run1_w;
  defparam linInt_ph.wa              = linInt_ph_wa;
  defparam linInt_ph.wf              = linInt_ph_wf;
  defparam linInt_ph.wb              = linInt_ph_wb;
  defparam linInt_ph.wd              = linInt_ph_wd;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_linInt_ph_lut_linInt_wrAdr                                 = 0;
  defparam  linInt_ph.R_lut_linInt_wrAdr                                 = R_linInt_ph_lut_linInt_wrAdr;
  parameter R_linInt_ph_lut_linInt_wrDatHi                               = 1;
  defparam  linInt_ph.R_lut_linInt_wrDatHi                               = R_linInt_ph_lut_linInt_wrDatHi;
  parameter R_linInt_ph_lut_linInt_wrDatLo                               = 2;
  defparam  linInt_ph.R_lut_linInt_wrDatLo                               = R_linInt_ph_lut_linInt_wrDatLo;
  parameter R_linInt_ph_lut_linInt_simInit                               = 3;
  defparam  linInt_ph.R_lut_linInt_simInit                               = R_linInt_ph_lut_linInt_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [linInt_ph_y_w-1:0]  linInt_ph_y;
  wire                                      linInt_ph_y_or;
  wire                                      linInt_ph_y_ff;
  wire                                      linInt_ph_y_we;

  wire                 [linInt_ph_x_w-1:0]  linInt_ph_x;
  wire                                      linInt_ph_x_ir;
  wire                                      linInt_ph_x_fe;
  wire                                      linInt_ph_x_re;

  wire              [linInt_ph_run1_w-1:0]  linInt_ph_run1;

  wire                                      linInt_ph_regWe;
  wire                                      linInt_ph_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  linInt linInt_ph(linInt_ph_y, linInt_ph_y_or, linInt_ph_y_ff, linInt_ph_y_we,
                   linInt_ph_x, linInt_ph_x_ir, linInt_ph_x_fe, linInt_ph_x_re, 
                   linInt_ph_run1, 
                   regBus, regWe, regRe, linInt_ph_regWe, linInt_ph_regRe, clk, clk2, reset);


//==============================================================================
