//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter linInt_amp_x_w             = 15;

  // Outputs
  parameter linInt_amp_y_w             = 16;

  // Input control lines
  parameter linInt_amp_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter linInt_amp_wa              = 9;
  parameter linInt_amp_wf              = 6;
  parameter linInt_amp_wb              = 16;
  parameter linInt_amp_wd              = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam linInt_amp.x_w             = linInt_amp_x_w;
  defparam linInt_amp.y_w             = linInt_amp_y_w;
  defparam linInt_amp.run1_w          = linInt_amp_run1_w;
  defparam linInt_amp.wa              = linInt_amp_wa;
  defparam linInt_amp.wf              = linInt_amp_wf;
  defparam linInt_amp.wb              = linInt_amp_wb;
  defparam linInt_amp.wd              = linInt_amp_wd;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_linInt_amp_lut_linInt_wrAdr                                = 0;
  defparam  linInt_amp.R_lut_linInt_wrAdr                                = R_linInt_amp_lut_linInt_wrAdr;
  parameter R_linInt_amp_lut_linInt_wrDatHi                              = 1;
  defparam  linInt_amp.R_lut_linInt_wrDatHi                              = R_linInt_amp_lut_linInt_wrDatHi;
  parameter R_linInt_amp_lut_linInt_wrDatLo                              = 2;
  defparam  linInt_amp.R_lut_linInt_wrDatLo                              = R_linInt_amp_lut_linInt_wrDatLo;
  parameter R_linInt_amp_lut_linInt_simInit                              = 3;
  defparam  linInt_amp.R_lut_linInt_simInit                              = R_linInt_amp_lut_linInt_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [linInt_amp_y_w-1:0]  linInt_amp_y;
  wire                                      linInt_amp_y_or;
  wire                                      linInt_amp_y_ff;
  wire                                      linInt_amp_y_we;

  wire                [linInt_amp_x_w-1:0]  linInt_amp_x;
  wire                                      linInt_amp_x_ir;
  wire                                      linInt_amp_x_fe;
  wire                                      linInt_amp_x_re;

  wire             [linInt_amp_run1_w-1:0]  linInt_amp_run1;

  wire                                      linInt_amp_regWe;
  wire                                      linInt_amp_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  linInt linInt_amp(linInt_amp_y, linInt_amp_y_or, linInt_amp_y_ff, linInt_amp_y_we,
                    linInt_amp_x, linInt_amp_x_ir, linInt_amp_x_fe, linInt_amp_x_re, 
                    linInt_amp_run1, 
                    regBus, regWe, regRe, linInt_amp_regWe, linInt_amp_regRe, clk, clk2, reset);


//==============================================================================
