//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines
  parameter irqCtrl_rf_irqIn_w         = 6;

  // Output control lines
  parameter irqCtrl_rf_irqOut_w        = 1;

  // Eregs
  parameter irqCtrl_rf_run1_w          = 1;
  parameter irqCtrl_rf_run1_r          = 0;
  parameter irqCtrl_rf_run1_s          = 0;
  parameter irqCtrl_rf_irqStat_w       = 6;
  parameter irqCtrl_rf_irqStat_r       = 0;
  parameter irqCtrl_rf_irqStat_s       = 0;
  parameter irqCtrl_rf_irqEdgeLevel_w  = 6;
  parameter irqCtrl_rf_irqEdgeLevel_r  = 0;
  parameter irqCtrl_rf_irqEdgeLevel_s  = 0;
  parameter irqCtrl_rf_irqMaskIn_w     = 6;
  parameter irqCtrl_rf_irqMaskIn_r     = 0;
  parameter irqCtrl_rf_irqMaskIn_s     = 0;
  parameter irqCtrl_rf_irqMaskOut_w    = 6;
  parameter irqCtrl_rf_irqMaskOut_r    = 0;
  parameter irqCtrl_rf_irqMaskOut_s    = 0;
  parameter irqCtrl_rf_irqClr_w        = 0;
  parameter irqCtrl_rf_irqClr_r        = 0;
  parameter irqCtrl_rf_irqClr_s        = 0;
  parameter irqCtrl_rf_irqSet_w        = 0;
  parameter irqCtrl_rf_irqSet_r        = 0;
  parameter irqCtrl_rf_irqSet_s        = 0;
  parameter irqCtrl_rf_irqIdx_w        = 4;
  parameter irqCtrl_rf_irqIdx_r        = 0;
  parameter irqCtrl_rf_irqIdx_s        = 0;

  // Parameters
  parameter irqCtrl_rf_w               = 6;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam irqCtrl_rf.irqIn_w         = irqCtrl_rf_irqIn_w;
  defparam irqCtrl_rf.irqOut_w        = irqCtrl_rf_irqOut_w;
  defparam irqCtrl_rf.run1_w          = irqCtrl_rf_run1_w;
  defparam irqCtrl_rf.run1_r          = irqCtrl_rf_run1_r;
  defparam irqCtrl_rf.run1_s          = irqCtrl_rf_run1_s;
  defparam irqCtrl_rf.irqStat_w       = irqCtrl_rf_irqStat_w;
  defparam irqCtrl_rf.irqStat_r       = irqCtrl_rf_irqStat_r;
  defparam irqCtrl_rf.irqStat_s       = irqCtrl_rf_irqStat_s;
  defparam irqCtrl_rf.irqEdgeLevel_w  = irqCtrl_rf_irqEdgeLevel_w;
  defparam irqCtrl_rf.irqEdgeLevel_r  = irqCtrl_rf_irqEdgeLevel_r;
  defparam irqCtrl_rf.irqEdgeLevel_s  = irqCtrl_rf_irqEdgeLevel_s;
  defparam irqCtrl_rf.irqMaskIn_w     = irqCtrl_rf_irqMaskIn_w;
  defparam irqCtrl_rf.irqMaskIn_r     = irqCtrl_rf_irqMaskIn_r;
  defparam irqCtrl_rf.irqMaskIn_s     = irqCtrl_rf_irqMaskIn_s;
  defparam irqCtrl_rf.irqMaskOut_w    = irqCtrl_rf_irqMaskOut_w;
  defparam irqCtrl_rf.irqMaskOut_r    = irqCtrl_rf_irqMaskOut_r;
  defparam irqCtrl_rf.irqMaskOut_s    = irqCtrl_rf_irqMaskOut_s;
  defparam irqCtrl_rf.irqClr_w        = irqCtrl_rf_irqClr_w;
  defparam irqCtrl_rf.irqClr_r        = irqCtrl_rf_irqClr_r;
  defparam irqCtrl_rf.irqClr_s        = irqCtrl_rf_irqClr_s;
  defparam irqCtrl_rf.irqSet_w        = irqCtrl_rf_irqSet_w;
  defparam irqCtrl_rf.irqSet_r        = irqCtrl_rf_irqSet_r;
  defparam irqCtrl_rf.irqSet_s        = irqCtrl_rf_irqSet_s;
  defparam irqCtrl_rf.irqIdx_w        = irqCtrl_rf_irqIdx_w;
  defparam irqCtrl_rf.irqIdx_r        = irqCtrl_rf_irqIdx_r;
  defparam irqCtrl_rf.irqIdx_s        = irqCtrl_rf_irqIdx_s;
  defparam irqCtrl_rf.w               = irqCtrl_rf_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_irqCtrl_rf_run1                                            = 0;
  defparam  irqCtrl_rf.R_run1                                            = R_irqCtrl_rf_run1;
  parameter R_irqCtrl_rf_irqStat                                         = 1;
  defparam  irqCtrl_rf.R_irqStat                                         = R_irqCtrl_rf_irqStat;
  parameter R_irqCtrl_rf_irqEdgeLevel                                    = 2;
  defparam  irqCtrl_rf.R_irqEdgeLevel                                    = R_irqCtrl_rf_irqEdgeLevel;
  parameter R_irqCtrl_rf_irqMaskIn                                       = 3;
  defparam  irqCtrl_rf.R_irqMaskIn                                       = R_irqCtrl_rf_irqMaskIn;
  parameter R_irqCtrl_rf_irqMaskOut                                      = 4;
  defparam  irqCtrl_rf.R_irqMaskOut                                      = R_irqCtrl_rf_irqMaskOut;
  parameter R_irqCtrl_rf_irqClr                                          = 5;
  defparam  irqCtrl_rf.R_irqClr                                          = R_irqCtrl_rf_irqClr;
  parameter R_irqCtrl_rf_irqSet                                          = 6;
  defparam  irqCtrl_rf.R_irqSet                                          = R_irqCtrl_rf_irqSet;
  parameter R_irqCtrl_rf_irqIdx                                          = 7;
  defparam  irqCtrl_rf.R_irqIdx                                          = R_irqCtrl_rf_irqIdx;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire           [irqCtrl_rf_irqOut_w-1:0]  irqCtrl_rf_irqOut;

  wire            [irqCtrl_rf_irqIn_w-1:0]  irqCtrl_rf_irqIn;

  wire                                      irqCtrl_rf_regWe;
  wire                                      irqCtrl_rf_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  irqCtrl irqCtrl_rf(irqCtrl_rf_irqOut, 
                     irqCtrl_rf_irqIn, 
                     regBus, regWe, regRe, irqCtrl_rf_regWe, irqCtrl_rf_regRe, clk, clk2, reset);


//==============================================================================
