//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter iqImb_0_xRe_w           = 16;
  parameter iqImb_0_xIm_w           = 16;

  // Outputs
  parameter iqImb_0_yRe_w           = 16;
  parameter iqImb_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter iqImb_0_run1_w          = 1;
  parameter iqImb_0_run1_r          = 0;
  parameter iqImb_0_run1_s          = 0;
  parameter iqImb_0_a_w             = 16;
  parameter iqImb_0_a_r             = 16384;
  parameter iqImb_0_a_s             = 1;
  parameter iqImb_0_b_w             = 16;
  parameter iqImb_0_b_r             = 16384;
  parameter iqImb_0_b_s             = 1;
  parameter iqImb_0_c_w             = 16;
  parameter iqImb_0_c_r             = 0;
  parameter iqImb_0_c_s             = 1;

  // Parameters
  parameter iqImb_0_w               = 16;

  // Iregs
  parameter iqImb_0_yReR_w          = 16;
  parameter iqImb_0_yReR_n          = 1;
  parameter iqImb_0_yReR_m          = `CLOG2(1);
  parameter iqImb_0_yImR_w          = 16;
  parameter iqImb_0_yImR_n          = 1;
  parameter iqImb_0_yImR_m          = `CLOG2(1);
  parameter iqImb_0_mA_w            = 31;
  parameter iqImb_0_mA_n            = 1;
  parameter iqImb_0_mA_m            = `CLOG2(1);
  parameter iqImb_0_mB_w            = 31;
  parameter iqImb_0_mB_n            = 1;
  parameter iqImb_0_mB_m            = `CLOG2(1);
  parameter iqImb_0_mC_w            = 31;
  parameter iqImb_0_mC_n            = 1;
  parameter iqImb_0_mC_m            = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam iqImb_0.xRe_w           = iqImb_0_xRe_w;
  defparam iqImb_0.xIm_w           = iqImb_0_xIm_w;
  defparam iqImb_0.yRe_w           = iqImb_0_yRe_w;
  defparam iqImb_0.yIm_w           = iqImb_0_yIm_w;
  defparam iqImb_0.run1_w          = iqImb_0_run1_w;
  defparam iqImb_0.run1_r          = iqImb_0_run1_r;
  defparam iqImb_0.run1_s          = iqImb_0_run1_s;
  defparam iqImb_0.a_w             = iqImb_0_a_w;
  defparam iqImb_0.a_r             = iqImb_0_a_r;
  defparam iqImb_0.a_s             = iqImb_0_a_s;
  defparam iqImb_0.b_w             = iqImb_0_b_w;
  defparam iqImb_0.b_r             = iqImb_0_b_r;
  defparam iqImb_0.b_s             = iqImb_0_b_s;
  defparam iqImb_0.c_w             = iqImb_0_c_w;
  defparam iqImb_0.c_r             = iqImb_0_c_r;
  defparam iqImb_0.c_s             = iqImb_0_c_s;
  defparam iqImb_0.w               = iqImb_0_w;
  defparam iqImb_0.yReR_w          = iqImb_0_yReR_w;
  defparam iqImb_0.yReR_n          = iqImb_0_yReR_n;
  defparam iqImb_0.yReR_m          = iqImb_0_yReR_m;
  defparam iqImb_0.yImR_w          = iqImb_0_yImR_w;
  defparam iqImb_0.yImR_n          = iqImb_0_yImR_n;
  defparam iqImb_0.yImR_m          = iqImb_0_yImR_m;
  defparam iqImb_0.mA_w            = iqImb_0_mA_w;
  defparam iqImb_0.mA_n            = iqImb_0_mA_n;
  defparam iqImb_0.mA_m            = iqImb_0_mA_m;
  defparam iqImb_0.mB_w            = iqImb_0_mB_w;
  defparam iqImb_0.mB_n            = iqImb_0_mB_n;
  defparam iqImb_0.mB_m            = iqImb_0_mB_m;
  defparam iqImb_0.mC_w            = iqImb_0_mC_w;
  defparam iqImb_0.mC_n            = iqImb_0_mC_n;
  defparam iqImb_0.mC_m            = iqImb_0_mC_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_iqImb_0_run1                                               = 0;
  defparam  iqImb_0.R_run1                                               = R_iqImb_0_run1;
  parameter R_iqImb_0_a                                                  = 1;
  defparam  iqImb_0.R_a                                                  = R_iqImb_0_a;
  parameter R_iqImb_0_b                                                  = 2;
  defparam  iqImb_0.R_b                                                  = R_iqImb_0_b;
  parameter R_iqImb_0_c                                                  = 3;
  defparam  iqImb_0.R_c                                                  = R_iqImb_0_c;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [iqImb_0_yRe_w-1:0]  iqImb_0_yRe;
  wire                                      iqImb_0_yRe_or;
  wire                                      iqImb_0_yRe_ff;
  wire                                      iqImb_0_yRe_we;

  wire                 [iqImb_0_yIm_w-1:0]  iqImb_0_yIm;
  wire                                      iqImb_0_yIm_or;
  wire                                      iqImb_0_yIm_ff;
  wire                                      iqImb_0_yIm_we;

  wire                 [iqImb_0_xRe_w-1:0]  iqImb_0_xRe;
  wire                                      iqImb_0_xRe_ir;
  wire                                      iqImb_0_xRe_fe;
  wire                                      iqImb_0_xRe_re;

  wire                 [iqImb_0_xIm_w-1:0]  iqImb_0_xIm;
  wire                                      iqImb_0_xIm_ir;
  wire                                      iqImb_0_xIm_fe;
  wire                                      iqImb_0_xIm_re;

  wire                                      iqImb_0_regWe;
  wire                                      iqImb_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  iqImb iqImb_0(iqImb_0_yRe, iqImb_0_yRe_or, iqImb_0_yRe_ff, iqImb_0_yRe_we,
                iqImb_0_yIm, iqImb_0_yIm_or, iqImb_0_yIm_ff, iqImb_0_yIm_we,
                iqImb_0_xRe, iqImb_0_xRe_ir, iqImb_0_xRe_fe, iqImb_0_xRe_re, 
                iqImb_0_xIm, iqImb_0_xIm_ir, iqImb_0_xIm_fe, iqImb_0_xIm_re, 
                regBus, regWe, regRe, iqImb_0_regWe, iqImb_0_regRe, clk, clk2, reset);


//==============================================================================
