//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter gain_re_x_w             = 32;

  // Outputs
  parameter gain_re_y_w             = 32;

  // Input control lines
  parameter gain_re_gainShift_w     = 6;
  parameter gain_re_gainFactor_w    = 8;

  // Output control lines

  // Eregs

  // Parameters
  parameter gain_re_w               = 32;
  parameter gain_re_wf              = 8;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam gain_re.x_w             = gain_re_x_w;
  defparam gain_re.y_w             = gain_re_y_w;
  defparam gain_re.gainShift_w     = gain_re_gainShift_w;
  defparam gain_re.gainFactor_w    = gain_re_gainFactor_w;
  defparam gain_re.w               = gain_re_w;
  defparam gain_re.wf              = gain_re_wf;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [gain_re_y_w-1:0]  gain_re_y;
  wire                                      gain_re_y_or;
  wire                                      gain_re_y_ff;
  wire                                      gain_re_y_we;

  wire                   [gain_re_x_w-1:0]  gain_re_x;
  wire                                      gain_re_x_ir;
  wire                                      gain_re_x_fe;
  wire                                      gain_re_x_re;

  wire           [gain_re_gainShift_w-1:0]  gain_re_gainShift;
  wire          [gain_re_gainFactor_w-1:0]  gain_re_gainFactor;

  wire                                      gain_re_regWe;
  wire                                      gain_re_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  gain gain_re(gain_re_y, gain_re_y_or, gain_re_y_ff, gain_re_y_we,
               gain_re_x, gain_re_x_ir, gain_re_x_fe, gain_re_x_re, 
               gain_re_gainShift, 
               gain_re_gainFactor, 
               regBus, regWe, regRe, gain_re_regWe, gain_re_regRe, clk, clk2, reset);


//==============================================================================
