//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter gain_im_x_w             = 32;

  // Outputs
  parameter gain_im_y_w             = 32;

  // Input control lines
  parameter gain_im_gainShift_w     = 6;
  parameter gain_im_gainFactor_w    = 8;

  // Output control lines

  // Eregs

  // Parameters
  parameter gain_im_w               = 32;
  parameter gain_im_wf              = 8;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam gain_im.x_w             = gain_im_x_w;
  defparam gain_im.y_w             = gain_im_y_w;
  defparam gain_im.gainShift_w     = gain_im_gainShift_w;
  defparam gain_im.gainFactor_w    = gain_im_gainFactor_w;
  defparam gain_im.w               = gain_im_w;
  defparam gain_im.wf              = gain_im_wf;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [gain_im_y_w-1:0]  gain_im_y;
  wire                                      gain_im_y_or;
  wire                                      gain_im_y_ff;
  wire                                      gain_im_y_we;

  wire                   [gain_im_x_w-1:0]  gain_im_x;
  wire                                      gain_im_x_ir;
  wire                                      gain_im_x_fe;
  wire                                      gain_im_x_re;

  wire           [gain_im_gainShift_w-1:0]  gain_im_gainShift;
  wire          [gain_im_gainFactor_w-1:0]  gain_im_gainFactor;

  wire                                      gain_im_regWe;
  wire                                      gain_im_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  gain gain_im(gain_im_y, gain_im_y_or, gain_im_y_ff, gain_im_y_we,
               gain_im_x, gain_im_x_ir, gain_im_x_fe, gain_im_x_re, 
               gain_im_gainShift, 
               gain_im_gainFactor, 
               regBus, regWe, regRe, gain_im_regWe, gain_im_regRe, clk, clk2, reset);


//==============================================================================
