//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter gainCtrl_0_xRe_w           = 32;
  parameter gainCtrl_0_xIm_w           = 32;

  // Outputs
  parameter gainCtrl_0_yRe_w           = 16;
  parameter gainCtrl_0_yIm_w           = 16;

  // Input control lines
  parameter gainCtrl_0_gainSel_w       = 7;

  // Output control lines

  // Eregs
  parameter gainCtrl_0_run1_w          = 1;
  parameter gainCtrl_0_run1_r          = 0;
  parameter gainCtrl_0_run1_s          = 0;
  parameter gainCtrl_0_gainDelay_w     = 10;
  parameter gainCtrl_0_gainDelay_r     = 0;
  parameter gainCtrl_0_gainDelay_s     = 0;

  // Parameters
  parameter gainCtrl_0_wx              = 32;
  parameter gainCtrl_0_wy              = 16;
  parameter gainCtrl_0_wg              = 7;
  parameter gainCtrl_0_wf              = 8;
  parameter gainCtrl_0_ws              = 6;

  // Iregs
  parameter gainCtrl_0_gainSetting_w   = 14;
  parameter gainCtrl_0_gainSetting_n   = 1;
  parameter gainCtrl_0_gainSetting_m   = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam gainCtrl_0.xRe_w           = gainCtrl_0_xRe_w;
  defparam gainCtrl_0.xIm_w           = gainCtrl_0_xIm_w;
  defparam gainCtrl_0.yRe_w           = gainCtrl_0_yRe_w;
  defparam gainCtrl_0.yIm_w           = gainCtrl_0_yIm_w;
  defparam gainCtrl_0.gainSel_w       = gainCtrl_0_gainSel_w;
  defparam gainCtrl_0.run1_w          = gainCtrl_0_run1_w;
  defparam gainCtrl_0.run1_r          = gainCtrl_0_run1_r;
  defparam gainCtrl_0.run1_s          = gainCtrl_0_run1_s;
  defparam gainCtrl_0.gainDelay_w     = gainCtrl_0_gainDelay_w;
  defparam gainCtrl_0.gainDelay_r     = gainCtrl_0_gainDelay_r;
  defparam gainCtrl_0.gainDelay_s     = gainCtrl_0_gainDelay_s;
  defparam gainCtrl_0.wx              = gainCtrl_0_wx;
  defparam gainCtrl_0.wy              = gainCtrl_0_wy;
  defparam gainCtrl_0.wg              = gainCtrl_0_wg;
  defparam gainCtrl_0.wf              = gainCtrl_0_wf;
  defparam gainCtrl_0.ws              = gainCtrl_0_ws;
  defparam gainCtrl_0.gainSetting_w   = gainCtrl_0_gainSetting_w;
  defparam gainCtrl_0.gainSetting_n   = gainCtrl_0_gainSetting_n;
  defparam gainCtrl_0.gainSetting_m   = gainCtrl_0_gainSetting_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_gainCtrl_0_run1                                            = 0;
  defparam  gainCtrl_0.R_run1                                            = R_gainCtrl_0_run1;
  parameter R_gainCtrl_0_gainDelay                                       = 1;
  defparam  gainCtrl_0.R_gainDelay                                       = R_gainCtrl_0_gainDelay;
  parameter R_gainCtrl_0_lut_gc_wrAdr                                    = 2;
  defparam  gainCtrl_0.R_lut_gc_wrAdr                                    = R_gainCtrl_0_lut_gc_wrAdr;
  parameter R_gainCtrl_0_lut_gc_wrDatHi                                  = 3;
  defparam  gainCtrl_0.R_lut_gc_wrDatHi                                  = R_gainCtrl_0_lut_gc_wrDatHi;
  parameter R_gainCtrl_0_lut_gc_wrDatLo                                  = 4;
  defparam  gainCtrl_0.R_lut_gc_wrDatLo                                  = R_gainCtrl_0_lut_gc_wrDatLo;
  parameter R_gainCtrl_0_lut_gc_simInit                                  = 5;
  defparam  gainCtrl_0.R_lut_gc_simInit                                  = R_gainCtrl_0_lut_gc_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [gainCtrl_0_yRe_w-1:0]  gainCtrl_0_yRe;
  wire                                      gainCtrl_0_yRe_or;
  wire                                      gainCtrl_0_yRe_ff;
  wire                                      gainCtrl_0_yRe_we;

  wire              [gainCtrl_0_yIm_w-1:0]  gainCtrl_0_yIm;
  wire                                      gainCtrl_0_yIm_or;
  wire                                      gainCtrl_0_yIm_ff;
  wire                                      gainCtrl_0_yIm_we;

  wire              [gainCtrl_0_xRe_w-1:0]  gainCtrl_0_xRe;
  wire                                      gainCtrl_0_xRe_ir;
  wire                                      gainCtrl_0_xRe_fe;
  wire                                      gainCtrl_0_xRe_re;

  wire              [gainCtrl_0_xIm_w-1:0]  gainCtrl_0_xIm;
  wire                                      gainCtrl_0_xIm_ir;
  wire                                      gainCtrl_0_xIm_fe;
  wire                                      gainCtrl_0_xIm_re;

  wire          [gainCtrl_0_gainSel_w-1:0]  gainCtrl_0_gainSel;

  wire                                      gainCtrl_0_regWe;
  wire                                      gainCtrl_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  gainCtrl gainCtrl_0(gainCtrl_0_yRe, gainCtrl_0_yRe_or, gainCtrl_0_yRe_ff, gainCtrl_0_yRe_we,
                      gainCtrl_0_yIm, gainCtrl_0_yIm_or, gainCtrl_0_yIm_ff, gainCtrl_0_yIm_we,
                      gainCtrl_0_xRe, gainCtrl_0_xRe_ir, gainCtrl_0_xRe_fe, gainCtrl_0_xRe_re, 
                      gainCtrl_0_xIm, gainCtrl_0_xIm_ir, gainCtrl_0_xIm_fe, gainCtrl_0_xIm_re, 
                      gainCtrl_0_gainSel, 
                      regBus, regWe, regRe, gainCtrl_0_regWe, gainCtrl_0_regRe, clk, clk2, reset);


//==============================================================================
