//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter gainChan_0_xRe_w           = 16;
  parameter gainChan_0_xIm_w           = 16;

  // Outputs
  parameter gainChan_0_yRe_w           = 32;
  parameter gainChan_0_yIm_w           = 32;

  // Input control lines

  // Output control lines

  // Eregs
  parameter gainChan_0_run1_w          = 1;
  parameter gainChan_0_run1_r          = 0;
  parameter gainChan_0_run1_s          = 0;
  parameter gainChan_0_gainFactor_w    = 8;
  parameter gainChan_0_gainFactor_r    = 0;
  parameter gainChan_0_gainFactor_s    = 0;
  parameter gainChan_0_gainShift_w     = 6;
  parameter gainChan_0_gainShift_r     = 0;
  parameter gainChan_0_gainShift_s     = 0;

  // Parameters
  parameter gainChan_0_wx              = 16;
  parameter gainChan_0_wy              = 32;
  parameter gainChan_0_wf              = 8;
  parameter gainChan_0_ws              = 6;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam gainChan_0.xRe_w           = gainChan_0_xRe_w;
  defparam gainChan_0.xIm_w           = gainChan_0_xIm_w;
  defparam gainChan_0.yRe_w           = gainChan_0_yRe_w;
  defparam gainChan_0.yIm_w           = gainChan_0_yIm_w;
  defparam gainChan_0.run1_w          = gainChan_0_run1_w;
  defparam gainChan_0.run1_r          = gainChan_0_run1_r;
  defparam gainChan_0.run1_s          = gainChan_0_run1_s;
  defparam gainChan_0.gainFactor_w    = gainChan_0_gainFactor_w;
  defparam gainChan_0.gainFactor_r    = gainChan_0_gainFactor_r;
  defparam gainChan_0.gainFactor_s    = gainChan_0_gainFactor_s;
  defparam gainChan_0.gainShift_w     = gainChan_0_gainShift_w;
  defparam gainChan_0.gainShift_r     = gainChan_0_gainShift_r;
  defparam gainChan_0.gainShift_s     = gainChan_0_gainShift_s;
  defparam gainChan_0.wx              = gainChan_0_wx;
  defparam gainChan_0.wy              = gainChan_0_wy;
  defparam gainChan_0.wf              = gainChan_0_wf;
  defparam gainChan_0.ws              = gainChan_0_ws;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_gainChan_0_run1                                            = 0;
  defparam  gainChan_0.R_run1                                            = R_gainChan_0_run1;
  parameter R_gainChan_0_gainFactor                                      = 1;
  defparam  gainChan_0.R_gainFactor                                      = R_gainChan_0_gainFactor;
  parameter R_gainChan_0_gainShift                                       = 2;
  defparam  gainChan_0.R_gainShift                                       = R_gainChan_0_gainShift;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [gainChan_0_yRe_w-1:0]  gainChan_0_yRe;
  wire                                      gainChan_0_yRe_or;
  wire                                      gainChan_0_yRe_ff;
  wire                                      gainChan_0_yRe_we;

  wire              [gainChan_0_yIm_w-1:0]  gainChan_0_yIm;
  wire                                      gainChan_0_yIm_or;
  wire                                      gainChan_0_yIm_ff;
  wire                                      gainChan_0_yIm_we;

  wire              [gainChan_0_xRe_w-1:0]  gainChan_0_xRe;
  wire                                      gainChan_0_xRe_ir;
  wire                                      gainChan_0_xRe_fe;
  wire                                      gainChan_0_xRe_re;

  wire              [gainChan_0_xIm_w-1:0]  gainChan_0_xIm;
  wire                                      gainChan_0_xIm_ir;
  wire                                      gainChan_0_xIm_fe;
  wire                                      gainChan_0_xIm_re;

  wire                                      gainChan_0_regWe;
  wire                                      gainChan_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  gainChan gainChan_0(gainChan_0_yRe, gainChan_0_yRe_or, gainChan_0_yRe_ff, gainChan_0_yRe_we,
                      gainChan_0_yIm, gainChan_0_yIm_or, gainChan_0_yIm_ff, gainChan_0_yIm_we,
                      gainChan_0_xRe, gainChan_0_xRe_ir, gainChan_0_xRe_fe, gainChan_0_xRe_re, 
                      gainChan_0_xIm, gainChan_0_xIm_ir, gainChan_0_xIm_fe, gainChan_0_xIm_re, 
                      regBus, regWe, regRe, gainChan_0_regWe, gainChan_0_regRe, clk, clk2, reset);


//==============================================================================
