//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter freqOff_0_xRe_w           = 16;
  parameter freqOff_0_xIm_w           = 16;

  // Outputs
  parameter freqOff_0_yRe_w           = 16;
  parameter freqOff_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter freqOff_0_run1_w          = 1;
  parameter freqOff_0_run1_r          = 0;
  parameter freqOff_0_run1_s          = 0;
  parameter freqOff_0_freqOffLo16_w   = 16;
  parameter freqOff_0_freqOffLo16_r   = 0;
  parameter freqOff_0_freqOffLo16_s   = 0;
  parameter freqOff_0_freqOffMi16_w   = 16;
  parameter freqOff_0_freqOffMi16_r   = 0;
  parameter freqOff_0_freqOffMi16_s   = 0;
  parameter freqOff_0_freqOffHi16_w   = 16;
  parameter freqOff_0_freqOffHi16_r   = 0;
  parameter freqOff_0_freqOffHi16_s   = 0;

  // Parameters
  parameter freqOff_0_w               = 16;
  parameter freqOff_0_wp              = 20;

  // Iregs
  parameter freqOff_0_phAcc_w         = 48;
  parameter freqOff_0_phAcc_n         = 1;
  parameter freqOff_0_phAcc_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam freqOff_0.xRe_w           = freqOff_0_xRe_w;
  defparam freqOff_0.xIm_w           = freqOff_0_xIm_w;
  defparam freqOff_0.yRe_w           = freqOff_0_yRe_w;
  defparam freqOff_0.yIm_w           = freqOff_0_yIm_w;
  defparam freqOff_0.run1_w          = freqOff_0_run1_w;
  defparam freqOff_0.run1_r          = freqOff_0_run1_r;
  defparam freqOff_0.run1_s          = freqOff_0_run1_s;
  defparam freqOff_0.freqOffLo16_w   = freqOff_0_freqOffLo16_w;
  defparam freqOff_0.freqOffLo16_r   = freqOff_0_freqOffLo16_r;
  defparam freqOff_0.freqOffLo16_s   = freqOff_0_freqOffLo16_s;
  defparam freqOff_0.freqOffMi16_w   = freqOff_0_freqOffMi16_w;
  defparam freqOff_0.freqOffMi16_r   = freqOff_0_freqOffMi16_r;
  defparam freqOff_0.freqOffMi16_s   = freqOff_0_freqOffMi16_s;
  defparam freqOff_0.freqOffHi16_w   = freqOff_0_freqOffHi16_w;
  defparam freqOff_0.freqOffHi16_r   = freqOff_0_freqOffHi16_r;
  defparam freqOff_0.freqOffHi16_s   = freqOff_0_freqOffHi16_s;
  defparam freqOff_0.w               = freqOff_0_w;
  defparam freqOff_0.wp              = freqOff_0_wp;
  defparam freqOff_0.phAcc_w         = freqOff_0_phAcc_w;
  defparam freqOff_0.phAcc_n         = freqOff_0_phAcc_n;
  defparam freqOff_0.phAcc_m         = freqOff_0_phAcc_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_freqOff_0_run1                                             = 0;
  defparam  freqOff_0.R_run1                                             = R_freqOff_0_run1;
  parameter R_freqOff_0_freqOffLo16                                      = 1;
  defparam  freqOff_0.R_freqOffLo16                                      = R_freqOff_0_freqOffLo16;
  parameter R_freqOff_0_freqOffMi16                                      = 2;
  defparam  freqOff_0.R_freqOffMi16                                      = R_freqOff_0_freqOffMi16;
  parameter R_freqOff_0_freqOffHi16                                      = 3;
  defparam  freqOff_0.R_freqOffHi16                                      = R_freqOff_0_freqOffHi16;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [freqOff_0_yRe_w-1:0]  freqOff_0_yRe;
  wire                                      freqOff_0_yRe_or;
  wire                                      freqOff_0_yRe_ff;
  wire                                      freqOff_0_yRe_we;

  wire               [freqOff_0_yIm_w-1:0]  freqOff_0_yIm;
  wire                                      freqOff_0_yIm_or;
  wire                                      freqOff_0_yIm_ff;
  wire                                      freqOff_0_yIm_we;

  wire               [freqOff_0_xRe_w-1:0]  freqOff_0_xRe;
  wire                                      freqOff_0_xRe_ir;
  wire                                      freqOff_0_xRe_fe;
  wire                                      freqOff_0_xRe_re;

  wire               [freqOff_0_xIm_w-1:0]  freqOff_0_xIm;
  wire                                      freqOff_0_xIm_ir;
  wire                                      freqOff_0_xIm_fe;
  wire                                      freqOff_0_xIm_re;

  wire                                      freqOff_0_regWe;
  wire                                      freqOff_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  freqOff freqOff_0(freqOff_0_yRe, freqOff_0_yRe_or, freqOff_0_yRe_ff, freqOff_0_yRe_we,
                    freqOff_0_yIm, freqOff_0_yIm_or, freqOff_0_yIm_ff, freqOff_0_yIm_we,
                    freqOff_0_xRe, freqOff_0_xRe_ir, freqOff_0_xRe_fe, freqOff_0_xRe_re, 
                    freqOff_0_xIm, freqOff_0_xIm_ir, freqOff_0_xIm_fe, freqOff_0_xIm_re, 
                    regBus, regWe, regRe, freqOff_0_regWe, freqOff_0_regRe, clk, clk2, reset);


//==============================================================================
