//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_09_xRe_w           = 16;
  parameter firCxMul_09_xIm_w           = 16;
  parameter firCxMul_09_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_09_yRe_w           = 16;
  parameter firCxMul_09_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_09_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_09_cRe_w           = 16;
  parameter firCxMul_09_cRe_r           = 0;
  parameter firCxMul_09_cRe_s           = 0;
  parameter firCxMul_09_cRePlIm_w       = 16;
  parameter firCxMul_09_cRePlIm_r       = 0;
  parameter firCxMul_09_cRePlIm_s       = 0;
  parameter firCxMul_09_cReMiIm_w       = 16;
  parameter firCxMul_09_cReMiIm_r       = 0;
  parameter firCxMul_09_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_09_w               = 16;
  parameter firCxMul_09_qc              = 13;

  // Iregs
  parameter firCxMul_09_mA_w            = 21;
  parameter firCxMul_09_mA_n            = 1;
  parameter firCxMul_09_mA_m            = `CLOG2(1);
  parameter firCxMul_09_mB_w            = 21;
  parameter firCxMul_09_mB_n            = 1;
  parameter firCxMul_09_mB_m            = `CLOG2(1);
  parameter firCxMul_09_mC_w            = 21;
  parameter firCxMul_09_mC_n            = 1;
  parameter firCxMul_09_mC_m            = `CLOG2(1);
  parameter firCxMul_09_yReR_w          = 16;
  parameter firCxMul_09_yReR_n          = 1;
  parameter firCxMul_09_yReR_m          = `CLOG2(1);
  parameter firCxMul_09_yImR_w          = 16;
  parameter firCxMul_09_yImR_n          = 1;
  parameter firCxMul_09_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_09.xRe_w           = firCxMul_09_xRe_w;
  defparam firCxMul_09.xIm_w           = firCxMul_09_xIm_w;
  defparam firCxMul_09.xRePlIm_w       = firCxMul_09_xRePlIm_w;
  defparam firCxMul_09.yRe_w           = firCxMul_09_yRe_w;
  defparam firCxMul_09.yIm_w           = firCxMul_09_yIm_w;
  defparam firCxMul_09.run1_w          = firCxMul_09_run1_w;
  defparam firCxMul_09.cRe_w           = firCxMul_09_cRe_w;
  defparam firCxMul_09.cRe_r           = firCxMul_09_cRe_r;
  defparam firCxMul_09.cRe_s           = firCxMul_09_cRe_s;
  defparam firCxMul_09.cRePlIm_w       = firCxMul_09_cRePlIm_w;
  defparam firCxMul_09.cRePlIm_r       = firCxMul_09_cRePlIm_r;
  defparam firCxMul_09.cRePlIm_s       = firCxMul_09_cRePlIm_s;
  defparam firCxMul_09.cReMiIm_w       = firCxMul_09_cReMiIm_w;
  defparam firCxMul_09.cReMiIm_r       = firCxMul_09_cReMiIm_r;
  defparam firCxMul_09.cReMiIm_s       = firCxMul_09_cReMiIm_s;
  defparam firCxMul_09.w               = firCxMul_09_w;
  defparam firCxMul_09.qc              = firCxMul_09_qc;
  defparam firCxMul_09.mA_w            = firCxMul_09_mA_w;
  defparam firCxMul_09.mA_n            = firCxMul_09_mA_n;
  defparam firCxMul_09.mA_m            = firCxMul_09_mA_m;
  defparam firCxMul_09.mB_w            = firCxMul_09_mB_w;
  defparam firCxMul_09.mB_n            = firCxMul_09_mB_n;
  defparam firCxMul_09.mB_m            = firCxMul_09_mB_m;
  defparam firCxMul_09.mC_w            = firCxMul_09_mC_w;
  defparam firCxMul_09.mC_n            = firCxMul_09_mC_n;
  defparam firCxMul_09.mC_m            = firCxMul_09_mC_m;
  defparam firCxMul_09.yReR_w          = firCxMul_09_yReR_w;
  defparam firCxMul_09.yReR_n          = firCxMul_09_yReR_n;
  defparam firCxMul_09.yReR_m          = firCxMul_09_yReR_m;
  defparam firCxMul_09.yImR_w          = firCxMul_09_yImR_w;
  defparam firCxMul_09.yImR_n          = firCxMul_09_yImR_n;
  defparam firCxMul_09.yImR_m          = firCxMul_09_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_09_cRe                                            = 0;
  defparam  firCxMul_09.R_cRe                                            = R_firCxMul_09_cRe;
  parameter R_firCxMul_09_cRePlIm                                        = 1;
  defparam  firCxMul_09.R_cRePlIm                                        = R_firCxMul_09_cRePlIm;
  parameter R_firCxMul_09_cReMiIm                                        = 2;
  defparam  firCxMul_09.R_cReMiIm                                        = R_firCxMul_09_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_09_yRe_w-1:0]  firCxMul_09_yRe;
  wire                                      firCxMul_09_yRe_or;
  wire                                      firCxMul_09_yRe_ff;
  wire                                      firCxMul_09_yRe_we;

  wire             [firCxMul_09_yIm_w-1:0]  firCxMul_09_yIm;
  wire                                      firCxMul_09_yIm_or;
  wire                                      firCxMul_09_yIm_ff;
  wire                                      firCxMul_09_yIm_we;

  wire             [firCxMul_09_xRe_w-1:0]  firCxMul_09_xRe;
  wire                                      firCxMul_09_xRe_ir;
  wire                                      firCxMul_09_xRe_fe;
  wire                                      firCxMul_09_xRe_re;

  wire             [firCxMul_09_xIm_w-1:0]  firCxMul_09_xIm;
  wire                                      firCxMul_09_xIm_ir;
  wire                                      firCxMul_09_xIm_fe;
  wire                                      firCxMul_09_xIm_re;

  wire         [firCxMul_09_xRePlIm_w-1:0]  firCxMul_09_xRePlIm;
  wire                                      firCxMul_09_xRePlIm_ir;
  wire                                      firCxMul_09_xRePlIm_fe;
  wire                                      firCxMul_09_xRePlIm_re;

  wire            [firCxMul_09_run1_w-1:0]  firCxMul_09_run1;

  wire                                      firCxMul_09_regWe;
  wire                                      firCxMul_09_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_09(firCxMul_09_yRe, firCxMul_09_yRe_or, firCxMul_09_yRe_ff, firCxMul_09_yRe_we,
                       firCxMul_09_yIm, firCxMul_09_yIm_or, firCxMul_09_yIm_ff, firCxMul_09_yIm_we,
                       firCxMul_09_xRe, firCxMul_09_xRe_ir, firCxMul_09_xRe_fe, firCxMul_09_xRe_re, 
                       firCxMul_09_xIm, firCxMul_09_xIm_ir, firCxMul_09_xIm_fe, firCxMul_09_xIm_re, 
                       firCxMul_09_xRePlIm, firCxMul_09_xRePlIm_ir, firCxMul_09_xRePlIm_fe, firCxMul_09_xRePlIm_re, 
                       firCxMul_09_run1, 
                       regBus, regWe, regRe, firCxMul_09_regWe, firCxMul_09_regRe, clk, clk2, reset);


//==============================================================================
