//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_08_xRe_w           = 16;
  parameter firCxMul_08_xIm_w           = 16;
  parameter firCxMul_08_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_08_yRe_w           = 16;
  parameter firCxMul_08_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_08_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_08_cRe_w           = 16;
  parameter firCxMul_08_cRe_r           = 0;
  parameter firCxMul_08_cRe_s           = 0;
  parameter firCxMul_08_cRePlIm_w       = 16;
  parameter firCxMul_08_cRePlIm_r       = 0;
  parameter firCxMul_08_cRePlIm_s       = 0;
  parameter firCxMul_08_cReMiIm_w       = 16;
  parameter firCxMul_08_cReMiIm_r       = 0;
  parameter firCxMul_08_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_08_w               = 16;
  parameter firCxMul_08_qc              = 13;

  // Iregs
  parameter firCxMul_08_mA_w            = 21;
  parameter firCxMul_08_mA_n            = 1;
  parameter firCxMul_08_mA_m            = `CLOG2(1);
  parameter firCxMul_08_mB_w            = 21;
  parameter firCxMul_08_mB_n            = 1;
  parameter firCxMul_08_mB_m            = `CLOG2(1);
  parameter firCxMul_08_mC_w            = 21;
  parameter firCxMul_08_mC_n            = 1;
  parameter firCxMul_08_mC_m            = `CLOG2(1);
  parameter firCxMul_08_yReR_w          = 16;
  parameter firCxMul_08_yReR_n          = 1;
  parameter firCxMul_08_yReR_m          = `CLOG2(1);
  parameter firCxMul_08_yImR_w          = 16;
  parameter firCxMul_08_yImR_n          = 1;
  parameter firCxMul_08_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_08.xRe_w           = firCxMul_08_xRe_w;
  defparam firCxMul_08.xIm_w           = firCxMul_08_xIm_w;
  defparam firCxMul_08.xRePlIm_w       = firCxMul_08_xRePlIm_w;
  defparam firCxMul_08.yRe_w           = firCxMul_08_yRe_w;
  defparam firCxMul_08.yIm_w           = firCxMul_08_yIm_w;
  defparam firCxMul_08.run1_w          = firCxMul_08_run1_w;
  defparam firCxMul_08.cRe_w           = firCxMul_08_cRe_w;
  defparam firCxMul_08.cRe_r           = firCxMul_08_cRe_r;
  defparam firCxMul_08.cRe_s           = firCxMul_08_cRe_s;
  defparam firCxMul_08.cRePlIm_w       = firCxMul_08_cRePlIm_w;
  defparam firCxMul_08.cRePlIm_r       = firCxMul_08_cRePlIm_r;
  defparam firCxMul_08.cRePlIm_s       = firCxMul_08_cRePlIm_s;
  defparam firCxMul_08.cReMiIm_w       = firCxMul_08_cReMiIm_w;
  defparam firCxMul_08.cReMiIm_r       = firCxMul_08_cReMiIm_r;
  defparam firCxMul_08.cReMiIm_s       = firCxMul_08_cReMiIm_s;
  defparam firCxMul_08.w               = firCxMul_08_w;
  defparam firCxMul_08.qc              = firCxMul_08_qc;
  defparam firCxMul_08.mA_w            = firCxMul_08_mA_w;
  defparam firCxMul_08.mA_n            = firCxMul_08_mA_n;
  defparam firCxMul_08.mA_m            = firCxMul_08_mA_m;
  defparam firCxMul_08.mB_w            = firCxMul_08_mB_w;
  defparam firCxMul_08.mB_n            = firCxMul_08_mB_n;
  defparam firCxMul_08.mB_m            = firCxMul_08_mB_m;
  defparam firCxMul_08.mC_w            = firCxMul_08_mC_w;
  defparam firCxMul_08.mC_n            = firCxMul_08_mC_n;
  defparam firCxMul_08.mC_m            = firCxMul_08_mC_m;
  defparam firCxMul_08.yReR_w          = firCxMul_08_yReR_w;
  defparam firCxMul_08.yReR_n          = firCxMul_08_yReR_n;
  defparam firCxMul_08.yReR_m          = firCxMul_08_yReR_m;
  defparam firCxMul_08.yImR_w          = firCxMul_08_yImR_w;
  defparam firCxMul_08.yImR_n          = firCxMul_08_yImR_n;
  defparam firCxMul_08.yImR_m          = firCxMul_08_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_08_cRe                                            = 0;
  defparam  firCxMul_08.R_cRe                                            = R_firCxMul_08_cRe;
  parameter R_firCxMul_08_cRePlIm                                        = 1;
  defparam  firCxMul_08.R_cRePlIm                                        = R_firCxMul_08_cRePlIm;
  parameter R_firCxMul_08_cReMiIm                                        = 2;
  defparam  firCxMul_08.R_cReMiIm                                        = R_firCxMul_08_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_08_yRe_w-1:0]  firCxMul_08_yRe;
  wire                                      firCxMul_08_yRe_or;
  wire                                      firCxMul_08_yRe_ff;
  wire                                      firCxMul_08_yRe_we;

  wire             [firCxMul_08_yIm_w-1:0]  firCxMul_08_yIm;
  wire                                      firCxMul_08_yIm_or;
  wire                                      firCxMul_08_yIm_ff;
  wire                                      firCxMul_08_yIm_we;

  wire             [firCxMul_08_xRe_w-1:0]  firCxMul_08_xRe;
  wire                                      firCxMul_08_xRe_ir;
  wire                                      firCxMul_08_xRe_fe;
  wire                                      firCxMul_08_xRe_re;

  wire             [firCxMul_08_xIm_w-1:0]  firCxMul_08_xIm;
  wire                                      firCxMul_08_xIm_ir;
  wire                                      firCxMul_08_xIm_fe;
  wire                                      firCxMul_08_xIm_re;

  wire         [firCxMul_08_xRePlIm_w-1:0]  firCxMul_08_xRePlIm;
  wire                                      firCxMul_08_xRePlIm_ir;
  wire                                      firCxMul_08_xRePlIm_fe;
  wire                                      firCxMul_08_xRePlIm_re;

  wire            [firCxMul_08_run1_w-1:0]  firCxMul_08_run1;

  wire                                      firCxMul_08_regWe;
  wire                                      firCxMul_08_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_08(firCxMul_08_yRe, firCxMul_08_yRe_or, firCxMul_08_yRe_ff, firCxMul_08_yRe_we,
                       firCxMul_08_yIm, firCxMul_08_yIm_or, firCxMul_08_yIm_ff, firCxMul_08_yIm_we,
                       firCxMul_08_xRe, firCxMul_08_xRe_ir, firCxMul_08_xRe_fe, firCxMul_08_xRe_re, 
                       firCxMul_08_xIm, firCxMul_08_xIm_ir, firCxMul_08_xIm_fe, firCxMul_08_xIm_re, 
                       firCxMul_08_xRePlIm, firCxMul_08_xRePlIm_ir, firCxMul_08_xRePlIm_fe, firCxMul_08_xRePlIm_re, 
                       firCxMul_08_run1, 
                       regBus, regWe, regRe, firCxMul_08_regWe, firCxMul_08_regRe, clk, clk2, reset);


//==============================================================================
