//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_07_xRe_w           = 16;
  parameter firCxMul_07_xIm_w           = 16;
  parameter firCxMul_07_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_07_yRe_w           = 16;
  parameter firCxMul_07_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_07_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_07_cRe_w           = 16;
  parameter firCxMul_07_cRe_r           = 0;
  parameter firCxMul_07_cRe_s           = 0;
  parameter firCxMul_07_cRePlIm_w       = 16;
  parameter firCxMul_07_cRePlIm_r       = 0;
  parameter firCxMul_07_cRePlIm_s       = 0;
  parameter firCxMul_07_cReMiIm_w       = 16;
  parameter firCxMul_07_cReMiIm_r       = 0;
  parameter firCxMul_07_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_07_w               = 16;
  parameter firCxMul_07_qc              = 13;

  // Iregs
  parameter firCxMul_07_mA_w            = 21;
  parameter firCxMul_07_mA_n            = 1;
  parameter firCxMul_07_mA_m            = `CLOG2(1);
  parameter firCxMul_07_mB_w            = 21;
  parameter firCxMul_07_mB_n            = 1;
  parameter firCxMul_07_mB_m            = `CLOG2(1);
  parameter firCxMul_07_mC_w            = 21;
  parameter firCxMul_07_mC_n            = 1;
  parameter firCxMul_07_mC_m            = `CLOG2(1);
  parameter firCxMul_07_yReR_w          = 16;
  parameter firCxMul_07_yReR_n          = 1;
  parameter firCxMul_07_yReR_m          = `CLOG2(1);
  parameter firCxMul_07_yImR_w          = 16;
  parameter firCxMul_07_yImR_n          = 1;
  parameter firCxMul_07_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_07.xRe_w           = firCxMul_07_xRe_w;
  defparam firCxMul_07.xIm_w           = firCxMul_07_xIm_w;
  defparam firCxMul_07.xRePlIm_w       = firCxMul_07_xRePlIm_w;
  defparam firCxMul_07.yRe_w           = firCxMul_07_yRe_w;
  defparam firCxMul_07.yIm_w           = firCxMul_07_yIm_w;
  defparam firCxMul_07.run1_w          = firCxMul_07_run1_w;
  defparam firCxMul_07.cRe_w           = firCxMul_07_cRe_w;
  defparam firCxMul_07.cRe_r           = firCxMul_07_cRe_r;
  defparam firCxMul_07.cRe_s           = firCxMul_07_cRe_s;
  defparam firCxMul_07.cRePlIm_w       = firCxMul_07_cRePlIm_w;
  defparam firCxMul_07.cRePlIm_r       = firCxMul_07_cRePlIm_r;
  defparam firCxMul_07.cRePlIm_s       = firCxMul_07_cRePlIm_s;
  defparam firCxMul_07.cReMiIm_w       = firCxMul_07_cReMiIm_w;
  defparam firCxMul_07.cReMiIm_r       = firCxMul_07_cReMiIm_r;
  defparam firCxMul_07.cReMiIm_s       = firCxMul_07_cReMiIm_s;
  defparam firCxMul_07.w               = firCxMul_07_w;
  defparam firCxMul_07.qc              = firCxMul_07_qc;
  defparam firCxMul_07.mA_w            = firCxMul_07_mA_w;
  defparam firCxMul_07.mA_n            = firCxMul_07_mA_n;
  defparam firCxMul_07.mA_m            = firCxMul_07_mA_m;
  defparam firCxMul_07.mB_w            = firCxMul_07_mB_w;
  defparam firCxMul_07.mB_n            = firCxMul_07_mB_n;
  defparam firCxMul_07.mB_m            = firCxMul_07_mB_m;
  defparam firCxMul_07.mC_w            = firCxMul_07_mC_w;
  defparam firCxMul_07.mC_n            = firCxMul_07_mC_n;
  defparam firCxMul_07.mC_m            = firCxMul_07_mC_m;
  defparam firCxMul_07.yReR_w          = firCxMul_07_yReR_w;
  defparam firCxMul_07.yReR_n          = firCxMul_07_yReR_n;
  defparam firCxMul_07.yReR_m          = firCxMul_07_yReR_m;
  defparam firCxMul_07.yImR_w          = firCxMul_07_yImR_w;
  defparam firCxMul_07.yImR_n          = firCxMul_07_yImR_n;
  defparam firCxMul_07.yImR_m          = firCxMul_07_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_07_cRe                                            = 0;
  defparam  firCxMul_07.R_cRe                                            = R_firCxMul_07_cRe;
  parameter R_firCxMul_07_cRePlIm                                        = 1;
  defparam  firCxMul_07.R_cRePlIm                                        = R_firCxMul_07_cRePlIm;
  parameter R_firCxMul_07_cReMiIm                                        = 2;
  defparam  firCxMul_07.R_cReMiIm                                        = R_firCxMul_07_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_07_yRe_w-1:0]  firCxMul_07_yRe;
  wire                                      firCxMul_07_yRe_or;
  wire                                      firCxMul_07_yRe_ff;
  wire                                      firCxMul_07_yRe_we;

  wire             [firCxMul_07_yIm_w-1:0]  firCxMul_07_yIm;
  wire                                      firCxMul_07_yIm_or;
  wire                                      firCxMul_07_yIm_ff;
  wire                                      firCxMul_07_yIm_we;

  wire             [firCxMul_07_xRe_w-1:0]  firCxMul_07_xRe;
  wire                                      firCxMul_07_xRe_ir;
  wire                                      firCxMul_07_xRe_fe;
  wire                                      firCxMul_07_xRe_re;

  wire             [firCxMul_07_xIm_w-1:0]  firCxMul_07_xIm;
  wire                                      firCxMul_07_xIm_ir;
  wire                                      firCxMul_07_xIm_fe;
  wire                                      firCxMul_07_xIm_re;

  wire         [firCxMul_07_xRePlIm_w-1:0]  firCxMul_07_xRePlIm;
  wire                                      firCxMul_07_xRePlIm_ir;
  wire                                      firCxMul_07_xRePlIm_fe;
  wire                                      firCxMul_07_xRePlIm_re;

  wire            [firCxMul_07_run1_w-1:0]  firCxMul_07_run1;

  wire                                      firCxMul_07_regWe;
  wire                                      firCxMul_07_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_07(firCxMul_07_yRe, firCxMul_07_yRe_or, firCxMul_07_yRe_ff, firCxMul_07_yRe_we,
                       firCxMul_07_yIm, firCxMul_07_yIm_or, firCxMul_07_yIm_ff, firCxMul_07_yIm_we,
                       firCxMul_07_xRe, firCxMul_07_xRe_ir, firCxMul_07_xRe_fe, firCxMul_07_xRe_re, 
                       firCxMul_07_xIm, firCxMul_07_xIm_ir, firCxMul_07_xIm_fe, firCxMul_07_xIm_re, 
                       firCxMul_07_xRePlIm, firCxMul_07_xRePlIm_ir, firCxMul_07_xRePlIm_fe, firCxMul_07_xRePlIm_re, 
                       firCxMul_07_run1, 
                       regBus, regWe, regRe, firCxMul_07_regWe, firCxMul_07_regRe, clk, clk2, reset);


//==============================================================================
