//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_06_xRe_w           = 16;
  parameter firCxMul_06_xIm_w           = 16;
  parameter firCxMul_06_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_06_yRe_w           = 16;
  parameter firCxMul_06_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_06_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_06_cRe_w           = 16;
  parameter firCxMul_06_cRe_r           = 0;
  parameter firCxMul_06_cRe_s           = 0;
  parameter firCxMul_06_cRePlIm_w       = 16;
  parameter firCxMul_06_cRePlIm_r       = 0;
  parameter firCxMul_06_cRePlIm_s       = 0;
  parameter firCxMul_06_cReMiIm_w       = 16;
  parameter firCxMul_06_cReMiIm_r       = 0;
  parameter firCxMul_06_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_06_w               = 16;
  parameter firCxMul_06_qc              = 13;

  // Iregs
  parameter firCxMul_06_mA_w            = 21;
  parameter firCxMul_06_mA_n            = 1;
  parameter firCxMul_06_mA_m            = `CLOG2(1);
  parameter firCxMul_06_mB_w            = 21;
  parameter firCxMul_06_mB_n            = 1;
  parameter firCxMul_06_mB_m            = `CLOG2(1);
  parameter firCxMul_06_mC_w            = 21;
  parameter firCxMul_06_mC_n            = 1;
  parameter firCxMul_06_mC_m            = `CLOG2(1);
  parameter firCxMul_06_yReR_w          = 16;
  parameter firCxMul_06_yReR_n          = 1;
  parameter firCxMul_06_yReR_m          = `CLOG2(1);
  parameter firCxMul_06_yImR_w          = 16;
  parameter firCxMul_06_yImR_n          = 1;
  parameter firCxMul_06_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_06.xRe_w           = firCxMul_06_xRe_w;
  defparam firCxMul_06.xIm_w           = firCxMul_06_xIm_w;
  defparam firCxMul_06.xRePlIm_w       = firCxMul_06_xRePlIm_w;
  defparam firCxMul_06.yRe_w           = firCxMul_06_yRe_w;
  defparam firCxMul_06.yIm_w           = firCxMul_06_yIm_w;
  defparam firCxMul_06.run1_w          = firCxMul_06_run1_w;
  defparam firCxMul_06.cRe_w           = firCxMul_06_cRe_w;
  defparam firCxMul_06.cRe_r           = firCxMul_06_cRe_r;
  defparam firCxMul_06.cRe_s           = firCxMul_06_cRe_s;
  defparam firCxMul_06.cRePlIm_w       = firCxMul_06_cRePlIm_w;
  defparam firCxMul_06.cRePlIm_r       = firCxMul_06_cRePlIm_r;
  defparam firCxMul_06.cRePlIm_s       = firCxMul_06_cRePlIm_s;
  defparam firCxMul_06.cReMiIm_w       = firCxMul_06_cReMiIm_w;
  defparam firCxMul_06.cReMiIm_r       = firCxMul_06_cReMiIm_r;
  defparam firCxMul_06.cReMiIm_s       = firCxMul_06_cReMiIm_s;
  defparam firCxMul_06.w               = firCxMul_06_w;
  defparam firCxMul_06.qc              = firCxMul_06_qc;
  defparam firCxMul_06.mA_w            = firCxMul_06_mA_w;
  defparam firCxMul_06.mA_n            = firCxMul_06_mA_n;
  defparam firCxMul_06.mA_m            = firCxMul_06_mA_m;
  defparam firCxMul_06.mB_w            = firCxMul_06_mB_w;
  defparam firCxMul_06.mB_n            = firCxMul_06_mB_n;
  defparam firCxMul_06.mB_m            = firCxMul_06_mB_m;
  defparam firCxMul_06.mC_w            = firCxMul_06_mC_w;
  defparam firCxMul_06.mC_n            = firCxMul_06_mC_n;
  defparam firCxMul_06.mC_m            = firCxMul_06_mC_m;
  defparam firCxMul_06.yReR_w          = firCxMul_06_yReR_w;
  defparam firCxMul_06.yReR_n          = firCxMul_06_yReR_n;
  defparam firCxMul_06.yReR_m          = firCxMul_06_yReR_m;
  defparam firCxMul_06.yImR_w          = firCxMul_06_yImR_w;
  defparam firCxMul_06.yImR_n          = firCxMul_06_yImR_n;
  defparam firCxMul_06.yImR_m          = firCxMul_06_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_06_cRe                                            = 0;
  defparam  firCxMul_06.R_cRe                                            = R_firCxMul_06_cRe;
  parameter R_firCxMul_06_cRePlIm                                        = 1;
  defparam  firCxMul_06.R_cRePlIm                                        = R_firCxMul_06_cRePlIm;
  parameter R_firCxMul_06_cReMiIm                                        = 2;
  defparam  firCxMul_06.R_cReMiIm                                        = R_firCxMul_06_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_06_yRe_w-1:0]  firCxMul_06_yRe;
  wire                                      firCxMul_06_yRe_or;
  wire                                      firCxMul_06_yRe_ff;
  wire                                      firCxMul_06_yRe_we;

  wire             [firCxMul_06_yIm_w-1:0]  firCxMul_06_yIm;
  wire                                      firCxMul_06_yIm_or;
  wire                                      firCxMul_06_yIm_ff;
  wire                                      firCxMul_06_yIm_we;

  wire             [firCxMul_06_xRe_w-1:0]  firCxMul_06_xRe;
  wire                                      firCxMul_06_xRe_ir;
  wire                                      firCxMul_06_xRe_fe;
  wire                                      firCxMul_06_xRe_re;

  wire             [firCxMul_06_xIm_w-1:0]  firCxMul_06_xIm;
  wire                                      firCxMul_06_xIm_ir;
  wire                                      firCxMul_06_xIm_fe;
  wire                                      firCxMul_06_xIm_re;

  wire         [firCxMul_06_xRePlIm_w-1:0]  firCxMul_06_xRePlIm;
  wire                                      firCxMul_06_xRePlIm_ir;
  wire                                      firCxMul_06_xRePlIm_fe;
  wire                                      firCxMul_06_xRePlIm_re;

  wire            [firCxMul_06_run1_w-1:0]  firCxMul_06_run1;

  wire                                      firCxMul_06_regWe;
  wire                                      firCxMul_06_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_06(firCxMul_06_yRe, firCxMul_06_yRe_or, firCxMul_06_yRe_ff, firCxMul_06_yRe_we,
                       firCxMul_06_yIm, firCxMul_06_yIm_or, firCxMul_06_yIm_ff, firCxMul_06_yIm_we,
                       firCxMul_06_xRe, firCxMul_06_xRe_ir, firCxMul_06_xRe_fe, firCxMul_06_xRe_re, 
                       firCxMul_06_xIm, firCxMul_06_xIm_ir, firCxMul_06_xIm_fe, firCxMul_06_xIm_re, 
                       firCxMul_06_xRePlIm, firCxMul_06_xRePlIm_ir, firCxMul_06_xRePlIm_fe, firCxMul_06_xRePlIm_re, 
                       firCxMul_06_run1, 
                       regBus, regWe, regRe, firCxMul_06_regWe, firCxMul_06_regRe, clk, clk2, reset);


//==============================================================================
