//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_05_xRe_w           = 16;
  parameter firCxMul_05_xIm_w           = 16;
  parameter firCxMul_05_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_05_yRe_w           = 16;
  parameter firCxMul_05_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_05_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_05_cRe_w           = 16;
  parameter firCxMul_05_cRe_r           = 0;
  parameter firCxMul_05_cRe_s           = 0;
  parameter firCxMul_05_cRePlIm_w       = 16;
  parameter firCxMul_05_cRePlIm_r       = 0;
  parameter firCxMul_05_cRePlIm_s       = 0;
  parameter firCxMul_05_cReMiIm_w       = 16;
  parameter firCxMul_05_cReMiIm_r       = 0;
  parameter firCxMul_05_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_05_w               = 16;
  parameter firCxMul_05_qc              = 13;

  // Iregs
  parameter firCxMul_05_mA_w            = 21;
  parameter firCxMul_05_mA_n            = 1;
  parameter firCxMul_05_mA_m            = `CLOG2(1);
  parameter firCxMul_05_mB_w            = 21;
  parameter firCxMul_05_mB_n            = 1;
  parameter firCxMul_05_mB_m            = `CLOG2(1);
  parameter firCxMul_05_mC_w            = 21;
  parameter firCxMul_05_mC_n            = 1;
  parameter firCxMul_05_mC_m            = `CLOG2(1);
  parameter firCxMul_05_yReR_w          = 16;
  parameter firCxMul_05_yReR_n          = 1;
  parameter firCxMul_05_yReR_m          = `CLOG2(1);
  parameter firCxMul_05_yImR_w          = 16;
  parameter firCxMul_05_yImR_n          = 1;
  parameter firCxMul_05_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_05.xRe_w           = firCxMul_05_xRe_w;
  defparam firCxMul_05.xIm_w           = firCxMul_05_xIm_w;
  defparam firCxMul_05.xRePlIm_w       = firCxMul_05_xRePlIm_w;
  defparam firCxMul_05.yRe_w           = firCxMul_05_yRe_w;
  defparam firCxMul_05.yIm_w           = firCxMul_05_yIm_w;
  defparam firCxMul_05.run1_w          = firCxMul_05_run1_w;
  defparam firCxMul_05.cRe_w           = firCxMul_05_cRe_w;
  defparam firCxMul_05.cRe_r           = firCxMul_05_cRe_r;
  defparam firCxMul_05.cRe_s           = firCxMul_05_cRe_s;
  defparam firCxMul_05.cRePlIm_w       = firCxMul_05_cRePlIm_w;
  defparam firCxMul_05.cRePlIm_r       = firCxMul_05_cRePlIm_r;
  defparam firCxMul_05.cRePlIm_s       = firCxMul_05_cRePlIm_s;
  defparam firCxMul_05.cReMiIm_w       = firCxMul_05_cReMiIm_w;
  defparam firCxMul_05.cReMiIm_r       = firCxMul_05_cReMiIm_r;
  defparam firCxMul_05.cReMiIm_s       = firCxMul_05_cReMiIm_s;
  defparam firCxMul_05.w               = firCxMul_05_w;
  defparam firCxMul_05.qc              = firCxMul_05_qc;
  defparam firCxMul_05.mA_w            = firCxMul_05_mA_w;
  defparam firCxMul_05.mA_n            = firCxMul_05_mA_n;
  defparam firCxMul_05.mA_m            = firCxMul_05_mA_m;
  defparam firCxMul_05.mB_w            = firCxMul_05_mB_w;
  defparam firCxMul_05.mB_n            = firCxMul_05_mB_n;
  defparam firCxMul_05.mB_m            = firCxMul_05_mB_m;
  defparam firCxMul_05.mC_w            = firCxMul_05_mC_w;
  defparam firCxMul_05.mC_n            = firCxMul_05_mC_n;
  defparam firCxMul_05.mC_m            = firCxMul_05_mC_m;
  defparam firCxMul_05.yReR_w          = firCxMul_05_yReR_w;
  defparam firCxMul_05.yReR_n          = firCxMul_05_yReR_n;
  defparam firCxMul_05.yReR_m          = firCxMul_05_yReR_m;
  defparam firCxMul_05.yImR_w          = firCxMul_05_yImR_w;
  defparam firCxMul_05.yImR_n          = firCxMul_05_yImR_n;
  defparam firCxMul_05.yImR_m          = firCxMul_05_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_05_cRe                                            = 0;
  defparam  firCxMul_05.R_cRe                                            = R_firCxMul_05_cRe;
  parameter R_firCxMul_05_cRePlIm                                        = 1;
  defparam  firCxMul_05.R_cRePlIm                                        = R_firCxMul_05_cRePlIm;
  parameter R_firCxMul_05_cReMiIm                                        = 2;
  defparam  firCxMul_05.R_cReMiIm                                        = R_firCxMul_05_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_05_yRe_w-1:0]  firCxMul_05_yRe;
  wire                                      firCxMul_05_yRe_or;
  wire                                      firCxMul_05_yRe_ff;
  wire                                      firCxMul_05_yRe_we;

  wire             [firCxMul_05_yIm_w-1:0]  firCxMul_05_yIm;
  wire                                      firCxMul_05_yIm_or;
  wire                                      firCxMul_05_yIm_ff;
  wire                                      firCxMul_05_yIm_we;

  wire             [firCxMul_05_xRe_w-1:0]  firCxMul_05_xRe;
  wire                                      firCxMul_05_xRe_ir;
  wire                                      firCxMul_05_xRe_fe;
  wire                                      firCxMul_05_xRe_re;

  wire             [firCxMul_05_xIm_w-1:0]  firCxMul_05_xIm;
  wire                                      firCxMul_05_xIm_ir;
  wire                                      firCxMul_05_xIm_fe;
  wire                                      firCxMul_05_xIm_re;

  wire         [firCxMul_05_xRePlIm_w-1:0]  firCxMul_05_xRePlIm;
  wire                                      firCxMul_05_xRePlIm_ir;
  wire                                      firCxMul_05_xRePlIm_fe;
  wire                                      firCxMul_05_xRePlIm_re;

  wire            [firCxMul_05_run1_w-1:0]  firCxMul_05_run1;

  wire                                      firCxMul_05_regWe;
  wire                                      firCxMul_05_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_05(firCxMul_05_yRe, firCxMul_05_yRe_or, firCxMul_05_yRe_ff, firCxMul_05_yRe_we,
                       firCxMul_05_yIm, firCxMul_05_yIm_or, firCxMul_05_yIm_ff, firCxMul_05_yIm_we,
                       firCxMul_05_xRe, firCxMul_05_xRe_ir, firCxMul_05_xRe_fe, firCxMul_05_xRe_re, 
                       firCxMul_05_xIm, firCxMul_05_xIm_ir, firCxMul_05_xIm_fe, firCxMul_05_xIm_re, 
                       firCxMul_05_xRePlIm, firCxMul_05_xRePlIm_ir, firCxMul_05_xRePlIm_fe, firCxMul_05_xRePlIm_re, 
                       firCxMul_05_run1, 
                       regBus, regWe, regRe, firCxMul_05_regWe, firCxMul_05_regRe, clk, clk2, reset);


//==============================================================================
