//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_04_xRe_w           = 16;
  parameter firCxMul_04_xIm_w           = 16;
  parameter firCxMul_04_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_04_yRe_w           = 16;
  parameter firCxMul_04_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_04_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_04_cRe_w           = 16;
  parameter firCxMul_04_cRe_r           = 0;
  parameter firCxMul_04_cRe_s           = 0;
  parameter firCxMul_04_cRePlIm_w       = 16;
  parameter firCxMul_04_cRePlIm_r       = 0;
  parameter firCxMul_04_cRePlIm_s       = 0;
  parameter firCxMul_04_cReMiIm_w       = 16;
  parameter firCxMul_04_cReMiIm_r       = 0;
  parameter firCxMul_04_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_04_w               = 16;
  parameter firCxMul_04_qc              = 13;

  // Iregs
  parameter firCxMul_04_mA_w            = 21;
  parameter firCxMul_04_mA_n            = 1;
  parameter firCxMul_04_mA_m            = `CLOG2(1);
  parameter firCxMul_04_mB_w            = 21;
  parameter firCxMul_04_mB_n            = 1;
  parameter firCxMul_04_mB_m            = `CLOG2(1);
  parameter firCxMul_04_mC_w            = 21;
  parameter firCxMul_04_mC_n            = 1;
  parameter firCxMul_04_mC_m            = `CLOG2(1);
  parameter firCxMul_04_yReR_w          = 16;
  parameter firCxMul_04_yReR_n          = 1;
  parameter firCxMul_04_yReR_m          = `CLOG2(1);
  parameter firCxMul_04_yImR_w          = 16;
  parameter firCxMul_04_yImR_n          = 1;
  parameter firCxMul_04_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_04.xRe_w           = firCxMul_04_xRe_w;
  defparam firCxMul_04.xIm_w           = firCxMul_04_xIm_w;
  defparam firCxMul_04.xRePlIm_w       = firCxMul_04_xRePlIm_w;
  defparam firCxMul_04.yRe_w           = firCxMul_04_yRe_w;
  defparam firCxMul_04.yIm_w           = firCxMul_04_yIm_w;
  defparam firCxMul_04.run1_w          = firCxMul_04_run1_w;
  defparam firCxMul_04.cRe_w           = firCxMul_04_cRe_w;
  defparam firCxMul_04.cRe_r           = firCxMul_04_cRe_r;
  defparam firCxMul_04.cRe_s           = firCxMul_04_cRe_s;
  defparam firCxMul_04.cRePlIm_w       = firCxMul_04_cRePlIm_w;
  defparam firCxMul_04.cRePlIm_r       = firCxMul_04_cRePlIm_r;
  defparam firCxMul_04.cRePlIm_s       = firCxMul_04_cRePlIm_s;
  defparam firCxMul_04.cReMiIm_w       = firCxMul_04_cReMiIm_w;
  defparam firCxMul_04.cReMiIm_r       = firCxMul_04_cReMiIm_r;
  defparam firCxMul_04.cReMiIm_s       = firCxMul_04_cReMiIm_s;
  defparam firCxMul_04.w               = firCxMul_04_w;
  defparam firCxMul_04.qc              = firCxMul_04_qc;
  defparam firCxMul_04.mA_w            = firCxMul_04_mA_w;
  defparam firCxMul_04.mA_n            = firCxMul_04_mA_n;
  defparam firCxMul_04.mA_m            = firCxMul_04_mA_m;
  defparam firCxMul_04.mB_w            = firCxMul_04_mB_w;
  defparam firCxMul_04.mB_n            = firCxMul_04_mB_n;
  defparam firCxMul_04.mB_m            = firCxMul_04_mB_m;
  defparam firCxMul_04.mC_w            = firCxMul_04_mC_w;
  defparam firCxMul_04.mC_n            = firCxMul_04_mC_n;
  defparam firCxMul_04.mC_m            = firCxMul_04_mC_m;
  defparam firCxMul_04.yReR_w          = firCxMul_04_yReR_w;
  defparam firCxMul_04.yReR_n          = firCxMul_04_yReR_n;
  defparam firCxMul_04.yReR_m          = firCxMul_04_yReR_m;
  defparam firCxMul_04.yImR_w          = firCxMul_04_yImR_w;
  defparam firCxMul_04.yImR_n          = firCxMul_04_yImR_n;
  defparam firCxMul_04.yImR_m          = firCxMul_04_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_04_cRe                                            = 0;
  defparam  firCxMul_04.R_cRe                                            = R_firCxMul_04_cRe;
  parameter R_firCxMul_04_cRePlIm                                        = 1;
  defparam  firCxMul_04.R_cRePlIm                                        = R_firCxMul_04_cRePlIm;
  parameter R_firCxMul_04_cReMiIm                                        = 2;
  defparam  firCxMul_04.R_cReMiIm                                        = R_firCxMul_04_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_04_yRe_w-1:0]  firCxMul_04_yRe;
  wire                                      firCxMul_04_yRe_or;
  wire                                      firCxMul_04_yRe_ff;
  wire                                      firCxMul_04_yRe_we;

  wire             [firCxMul_04_yIm_w-1:0]  firCxMul_04_yIm;
  wire                                      firCxMul_04_yIm_or;
  wire                                      firCxMul_04_yIm_ff;
  wire                                      firCxMul_04_yIm_we;

  wire             [firCxMul_04_xRe_w-1:0]  firCxMul_04_xRe;
  wire                                      firCxMul_04_xRe_ir;
  wire                                      firCxMul_04_xRe_fe;
  wire                                      firCxMul_04_xRe_re;

  wire             [firCxMul_04_xIm_w-1:0]  firCxMul_04_xIm;
  wire                                      firCxMul_04_xIm_ir;
  wire                                      firCxMul_04_xIm_fe;
  wire                                      firCxMul_04_xIm_re;

  wire         [firCxMul_04_xRePlIm_w-1:0]  firCxMul_04_xRePlIm;
  wire                                      firCxMul_04_xRePlIm_ir;
  wire                                      firCxMul_04_xRePlIm_fe;
  wire                                      firCxMul_04_xRePlIm_re;

  wire            [firCxMul_04_run1_w-1:0]  firCxMul_04_run1;

  wire                                      firCxMul_04_regWe;
  wire                                      firCxMul_04_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_04(firCxMul_04_yRe, firCxMul_04_yRe_or, firCxMul_04_yRe_ff, firCxMul_04_yRe_we,
                       firCxMul_04_yIm, firCxMul_04_yIm_or, firCxMul_04_yIm_ff, firCxMul_04_yIm_we,
                       firCxMul_04_xRe, firCxMul_04_xRe_ir, firCxMul_04_xRe_fe, firCxMul_04_xRe_re, 
                       firCxMul_04_xIm, firCxMul_04_xIm_ir, firCxMul_04_xIm_fe, firCxMul_04_xIm_re, 
                       firCxMul_04_xRePlIm, firCxMul_04_xRePlIm_ir, firCxMul_04_xRePlIm_fe, firCxMul_04_xRePlIm_re, 
                       firCxMul_04_run1, 
                       regBus, regWe, regRe, firCxMul_04_regWe, firCxMul_04_regRe, clk, clk2, reset);


//==============================================================================
