//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_03_xRe_w           = 16;
  parameter firCxMul_03_xIm_w           = 16;
  parameter firCxMul_03_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_03_yRe_w           = 16;
  parameter firCxMul_03_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_03_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_03_cRe_w           = 16;
  parameter firCxMul_03_cRe_r           = 0;
  parameter firCxMul_03_cRe_s           = 0;
  parameter firCxMul_03_cRePlIm_w       = 16;
  parameter firCxMul_03_cRePlIm_r       = 0;
  parameter firCxMul_03_cRePlIm_s       = 0;
  parameter firCxMul_03_cReMiIm_w       = 16;
  parameter firCxMul_03_cReMiIm_r       = 0;
  parameter firCxMul_03_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_03_w               = 16;
  parameter firCxMul_03_qc              = 13;

  // Iregs
  parameter firCxMul_03_mA_w            = 21;
  parameter firCxMul_03_mA_n            = 1;
  parameter firCxMul_03_mA_m            = `CLOG2(1);
  parameter firCxMul_03_mB_w            = 21;
  parameter firCxMul_03_mB_n            = 1;
  parameter firCxMul_03_mB_m            = `CLOG2(1);
  parameter firCxMul_03_mC_w            = 21;
  parameter firCxMul_03_mC_n            = 1;
  parameter firCxMul_03_mC_m            = `CLOG2(1);
  parameter firCxMul_03_yReR_w          = 16;
  parameter firCxMul_03_yReR_n          = 1;
  parameter firCxMul_03_yReR_m          = `CLOG2(1);
  parameter firCxMul_03_yImR_w          = 16;
  parameter firCxMul_03_yImR_n          = 1;
  parameter firCxMul_03_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_03.xRe_w           = firCxMul_03_xRe_w;
  defparam firCxMul_03.xIm_w           = firCxMul_03_xIm_w;
  defparam firCxMul_03.xRePlIm_w       = firCxMul_03_xRePlIm_w;
  defparam firCxMul_03.yRe_w           = firCxMul_03_yRe_w;
  defparam firCxMul_03.yIm_w           = firCxMul_03_yIm_w;
  defparam firCxMul_03.run1_w          = firCxMul_03_run1_w;
  defparam firCxMul_03.cRe_w           = firCxMul_03_cRe_w;
  defparam firCxMul_03.cRe_r           = firCxMul_03_cRe_r;
  defparam firCxMul_03.cRe_s           = firCxMul_03_cRe_s;
  defparam firCxMul_03.cRePlIm_w       = firCxMul_03_cRePlIm_w;
  defparam firCxMul_03.cRePlIm_r       = firCxMul_03_cRePlIm_r;
  defparam firCxMul_03.cRePlIm_s       = firCxMul_03_cRePlIm_s;
  defparam firCxMul_03.cReMiIm_w       = firCxMul_03_cReMiIm_w;
  defparam firCxMul_03.cReMiIm_r       = firCxMul_03_cReMiIm_r;
  defparam firCxMul_03.cReMiIm_s       = firCxMul_03_cReMiIm_s;
  defparam firCxMul_03.w               = firCxMul_03_w;
  defparam firCxMul_03.qc              = firCxMul_03_qc;
  defparam firCxMul_03.mA_w            = firCxMul_03_mA_w;
  defparam firCxMul_03.mA_n            = firCxMul_03_mA_n;
  defparam firCxMul_03.mA_m            = firCxMul_03_mA_m;
  defparam firCxMul_03.mB_w            = firCxMul_03_mB_w;
  defparam firCxMul_03.mB_n            = firCxMul_03_mB_n;
  defparam firCxMul_03.mB_m            = firCxMul_03_mB_m;
  defparam firCxMul_03.mC_w            = firCxMul_03_mC_w;
  defparam firCxMul_03.mC_n            = firCxMul_03_mC_n;
  defparam firCxMul_03.mC_m            = firCxMul_03_mC_m;
  defparam firCxMul_03.yReR_w          = firCxMul_03_yReR_w;
  defparam firCxMul_03.yReR_n          = firCxMul_03_yReR_n;
  defparam firCxMul_03.yReR_m          = firCxMul_03_yReR_m;
  defparam firCxMul_03.yImR_w          = firCxMul_03_yImR_w;
  defparam firCxMul_03.yImR_n          = firCxMul_03_yImR_n;
  defparam firCxMul_03.yImR_m          = firCxMul_03_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_03_cRe                                            = 0;
  defparam  firCxMul_03.R_cRe                                            = R_firCxMul_03_cRe;
  parameter R_firCxMul_03_cRePlIm                                        = 1;
  defparam  firCxMul_03.R_cRePlIm                                        = R_firCxMul_03_cRePlIm;
  parameter R_firCxMul_03_cReMiIm                                        = 2;
  defparam  firCxMul_03.R_cReMiIm                                        = R_firCxMul_03_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_03_yRe_w-1:0]  firCxMul_03_yRe;
  wire                                      firCxMul_03_yRe_or;
  wire                                      firCxMul_03_yRe_ff;
  wire                                      firCxMul_03_yRe_we;

  wire             [firCxMul_03_yIm_w-1:0]  firCxMul_03_yIm;
  wire                                      firCxMul_03_yIm_or;
  wire                                      firCxMul_03_yIm_ff;
  wire                                      firCxMul_03_yIm_we;

  wire             [firCxMul_03_xRe_w-1:0]  firCxMul_03_xRe;
  wire                                      firCxMul_03_xRe_ir;
  wire                                      firCxMul_03_xRe_fe;
  wire                                      firCxMul_03_xRe_re;

  wire             [firCxMul_03_xIm_w-1:0]  firCxMul_03_xIm;
  wire                                      firCxMul_03_xIm_ir;
  wire                                      firCxMul_03_xIm_fe;
  wire                                      firCxMul_03_xIm_re;

  wire         [firCxMul_03_xRePlIm_w-1:0]  firCxMul_03_xRePlIm;
  wire                                      firCxMul_03_xRePlIm_ir;
  wire                                      firCxMul_03_xRePlIm_fe;
  wire                                      firCxMul_03_xRePlIm_re;

  wire            [firCxMul_03_run1_w-1:0]  firCxMul_03_run1;

  wire                                      firCxMul_03_regWe;
  wire                                      firCxMul_03_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_03(firCxMul_03_yRe, firCxMul_03_yRe_or, firCxMul_03_yRe_ff, firCxMul_03_yRe_we,
                       firCxMul_03_yIm, firCxMul_03_yIm_or, firCxMul_03_yIm_ff, firCxMul_03_yIm_we,
                       firCxMul_03_xRe, firCxMul_03_xRe_ir, firCxMul_03_xRe_fe, firCxMul_03_xRe_re, 
                       firCxMul_03_xIm, firCxMul_03_xIm_ir, firCxMul_03_xIm_fe, firCxMul_03_xIm_re, 
                       firCxMul_03_xRePlIm, firCxMul_03_xRePlIm_ir, firCxMul_03_xRePlIm_fe, firCxMul_03_xRePlIm_re, 
                       firCxMul_03_run1, 
                       regBus, regWe, regRe, firCxMul_03_regWe, firCxMul_03_regRe, clk, clk2, reset);


//==============================================================================
