//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_02_xRe_w           = 16;
  parameter firCxMul_02_xIm_w           = 16;
  parameter firCxMul_02_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_02_yRe_w           = 16;
  parameter firCxMul_02_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_02_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_02_cRe_w           = 16;
  parameter firCxMul_02_cRe_r           = 0;
  parameter firCxMul_02_cRe_s           = 0;
  parameter firCxMul_02_cRePlIm_w       = 16;
  parameter firCxMul_02_cRePlIm_r       = 0;
  parameter firCxMul_02_cRePlIm_s       = 0;
  parameter firCxMul_02_cReMiIm_w       = 16;
  parameter firCxMul_02_cReMiIm_r       = 0;
  parameter firCxMul_02_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_02_w               = 16;
  parameter firCxMul_02_qc              = 13;

  // Iregs
  parameter firCxMul_02_mA_w            = 21;
  parameter firCxMul_02_mA_n            = 1;
  parameter firCxMul_02_mA_m            = `CLOG2(1);
  parameter firCxMul_02_mB_w            = 21;
  parameter firCxMul_02_mB_n            = 1;
  parameter firCxMul_02_mB_m            = `CLOG2(1);
  parameter firCxMul_02_mC_w            = 21;
  parameter firCxMul_02_mC_n            = 1;
  parameter firCxMul_02_mC_m            = `CLOG2(1);
  parameter firCxMul_02_yReR_w          = 16;
  parameter firCxMul_02_yReR_n          = 1;
  parameter firCxMul_02_yReR_m          = `CLOG2(1);
  parameter firCxMul_02_yImR_w          = 16;
  parameter firCxMul_02_yImR_n          = 1;
  parameter firCxMul_02_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_02.xRe_w           = firCxMul_02_xRe_w;
  defparam firCxMul_02.xIm_w           = firCxMul_02_xIm_w;
  defparam firCxMul_02.xRePlIm_w       = firCxMul_02_xRePlIm_w;
  defparam firCxMul_02.yRe_w           = firCxMul_02_yRe_w;
  defparam firCxMul_02.yIm_w           = firCxMul_02_yIm_w;
  defparam firCxMul_02.run1_w          = firCxMul_02_run1_w;
  defparam firCxMul_02.cRe_w           = firCxMul_02_cRe_w;
  defparam firCxMul_02.cRe_r           = firCxMul_02_cRe_r;
  defparam firCxMul_02.cRe_s           = firCxMul_02_cRe_s;
  defparam firCxMul_02.cRePlIm_w       = firCxMul_02_cRePlIm_w;
  defparam firCxMul_02.cRePlIm_r       = firCxMul_02_cRePlIm_r;
  defparam firCxMul_02.cRePlIm_s       = firCxMul_02_cRePlIm_s;
  defparam firCxMul_02.cReMiIm_w       = firCxMul_02_cReMiIm_w;
  defparam firCxMul_02.cReMiIm_r       = firCxMul_02_cReMiIm_r;
  defparam firCxMul_02.cReMiIm_s       = firCxMul_02_cReMiIm_s;
  defparam firCxMul_02.w               = firCxMul_02_w;
  defparam firCxMul_02.qc              = firCxMul_02_qc;
  defparam firCxMul_02.mA_w            = firCxMul_02_mA_w;
  defparam firCxMul_02.mA_n            = firCxMul_02_mA_n;
  defparam firCxMul_02.mA_m            = firCxMul_02_mA_m;
  defparam firCxMul_02.mB_w            = firCxMul_02_mB_w;
  defparam firCxMul_02.mB_n            = firCxMul_02_mB_n;
  defparam firCxMul_02.mB_m            = firCxMul_02_mB_m;
  defparam firCxMul_02.mC_w            = firCxMul_02_mC_w;
  defparam firCxMul_02.mC_n            = firCxMul_02_mC_n;
  defparam firCxMul_02.mC_m            = firCxMul_02_mC_m;
  defparam firCxMul_02.yReR_w          = firCxMul_02_yReR_w;
  defparam firCxMul_02.yReR_n          = firCxMul_02_yReR_n;
  defparam firCxMul_02.yReR_m          = firCxMul_02_yReR_m;
  defparam firCxMul_02.yImR_w          = firCxMul_02_yImR_w;
  defparam firCxMul_02.yImR_n          = firCxMul_02_yImR_n;
  defparam firCxMul_02.yImR_m          = firCxMul_02_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_02_cRe                                            = 0;
  defparam  firCxMul_02.R_cRe                                            = R_firCxMul_02_cRe;
  parameter R_firCxMul_02_cRePlIm                                        = 1;
  defparam  firCxMul_02.R_cRePlIm                                        = R_firCxMul_02_cRePlIm;
  parameter R_firCxMul_02_cReMiIm                                        = 2;
  defparam  firCxMul_02.R_cReMiIm                                        = R_firCxMul_02_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_02_yRe_w-1:0]  firCxMul_02_yRe;
  wire                                      firCxMul_02_yRe_or;
  wire                                      firCxMul_02_yRe_ff;
  wire                                      firCxMul_02_yRe_we;

  wire             [firCxMul_02_yIm_w-1:0]  firCxMul_02_yIm;
  wire                                      firCxMul_02_yIm_or;
  wire                                      firCxMul_02_yIm_ff;
  wire                                      firCxMul_02_yIm_we;

  wire             [firCxMul_02_xRe_w-1:0]  firCxMul_02_xRe;
  wire                                      firCxMul_02_xRe_ir;
  wire                                      firCxMul_02_xRe_fe;
  wire                                      firCxMul_02_xRe_re;

  wire             [firCxMul_02_xIm_w-1:0]  firCxMul_02_xIm;
  wire                                      firCxMul_02_xIm_ir;
  wire                                      firCxMul_02_xIm_fe;
  wire                                      firCxMul_02_xIm_re;

  wire         [firCxMul_02_xRePlIm_w-1:0]  firCxMul_02_xRePlIm;
  wire                                      firCxMul_02_xRePlIm_ir;
  wire                                      firCxMul_02_xRePlIm_fe;
  wire                                      firCxMul_02_xRePlIm_re;

  wire            [firCxMul_02_run1_w-1:0]  firCxMul_02_run1;

  wire                                      firCxMul_02_regWe;
  wire                                      firCxMul_02_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_02(firCxMul_02_yRe, firCxMul_02_yRe_or, firCxMul_02_yRe_ff, firCxMul_02_yRe_we,
                       firCxMul_02_yIm, firCxMul_02_yIm_or, firCxMul_02_yIm_ff, firCxMul_02_yIm_we,
                       firCxMul_02_xRe, firCxMul_02_xRe_ir, firCxMul_02_xRe_fe, firCxMul_02_xRe_re, 
                       firCxMul_02_xIm, firCxMul_02_xIm_ir, firCxMul_02_xIm_fe, firCxMul_02_xIm_re, 
                       firCxMul_02_xRePlIm, firCxMul_02_xRePlIm_ir, firCxMul_02_xRePlIm_fe, firCxMul_02_xRePlIm_re, 
                       firCxMul_02_run1, 
                       regBus, regWe, regRe, firCxMul_02_regWe, firCxMul_02_regRe, clk, clk2, reset);


//==============================================================================
