//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_01_xRe_w           = 16;
  parameter firCxMul_01_xIm_w           = 16;
  parameter firCxMul_01_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_01_yRe_w           = 16;
  parameter firCxMul_01_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_01_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_01_cRe_w           = 16;
  parameter firCxMul_01_cRe_r           = 0;
  parameter firCxMul_01_cRe_s           = 0;
  parameter firCxMul_01_cRePlIm_w       = 16;
  parameter firCxMul_01_cRePlIm_r       = 0;
  parameter firCxMul_01_cRePlIm_s       = 0;
  parameter firCxMul_01_cReMiIm_w       = 16;
  parameter firCxMul_01_cReMiIm_r       = 0;
  parameter firCxMul_01_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_01_w               = 16;
  parameter firCxMul_01_qc              = 13;

  // Iregs
  parameter firCxMul_01_mA_w            = 21;
  parameter firCxMul_01_mA_n            = 1;
  parameter firCxMul_01_mA_m            = `CLOG2(1);
  parameter firCxMul_01_mB_w            = 21;
  parameter firCxMul_01_mB_n            = 1;
  parameter firCxMul_01_mB_m            = `CLOG2(1);
  parameter firCxMul_01_mC_w            = 21;
  parameter firCxMul_01_mC_n            = 1;
  parameter firCxMul_01_mC_m            = `CLOG2(1);
  parameter firCxMul_01_yReR_w          = 16;
  parameter firCxMul_01_yReR_n          = 1;
  parameter firCxMul_01_yReR_m          = `CLOG2(1);
  parameter firCxMul_01_yImR_w          = 16;
  parameter firCxMul_01_yImR_n          = 1;
  parameter firCxMul_01_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_01.xRe_w           = firCxMul_01_xRe_w;
  defparam firCxMul_01.xIm_w           = firCxMul_01_xIm_w;
  defparam firCxMul_01.xRePlIm_w       = firCxMul_01_xRePlIm_w;
  defparam firCxMul_01.yRe_w           = firCxMul_01_yRe_w;
  defparam firCxMul_01.yIm_w           = firCxMul_01_yIm_w;
  defparam firCxMul_01.run1_w          = firCxMul_01_run1_w;
  defparam firCxMul_01.cRe_w           = firCxMul_01_cRe_w;
  defparam firCxMul_01.cRe_r           = firCxMul_01_cRe_r;
  defparam firCxMul_01.cRe_s           = firCxMul_01_cRe_s;
  defparam firCxMul_01.cRePlIm_w       = firCxMul_01_cRePlIm_w;
  defparam firCxMul_01.cRePlIm_r       = firCxMul_01_cRePlIm_r;
  defparam firCxMul_01.cRePlIm_s       = firCxMul_01_cRePlIm_s;
  defparam firCxMul_01.cReMiIm_w       = firCxMul_01_cReMiIm_w;
  defparam firCxMul_01.cReMiIm_r       = firCxMul_01_cReMiIm_r;
  defparam firCxMul_01.cReMiIm_s       = firCxMul_01_cReMiIm_s;
  defparam firCxMul_01.w               = firCxMul_01_w;
  defparam firCxMul_01.qc              = firCxMul_01_qc;
  defparam firCxMul_01.mA_w            = firCxMul_01_mA_w;
  defparam firCxMul_01.mA_n            = firCxMul_01_mA_n;
  defparam firCxMul_01.mA_m            = firCxMul_01_mA_m;
  defparam firCxMul_01.mB_w            = firCxMul_01_mB_w;
  defparam firCxMul_01.mB_n            = firCxMul_01_mB_n;
  defparam firCxMul_01.mB_m            = firCxMul_01_mB_m;
  defparam firCxMul_01.mC_w            = firCxMul_01_mC_w;
  defparam firCxMul_01.mC_n            = firCxMul_01_mC_n;
  defparam firCxMul_01.mC_m            = firCxMul_01_mC_m;
  defparam firCxMul_01.yReR_w          = firCxMul_01_yReR_w;
  defparam firCxMul_01.yReR_n          = firCxMul_01_yReR_n;
  defparam firCxMul_01.yReR_m          = firCxMul_01_yReR_m;
  defparam firCxMul_01.yImR_w          = firCxMul_01_yImR_w;
  defparam firCxMul_01.yImR_n          = firCxMul_01_yImR_n;
  defparam firCxMul_01.yImR_m          = firCxMul_01_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_01_cRe                                            = 0;
  defparam  firCxMul_01.R_cRe                                            = R_firCxMul_01_cRe;
  parameter R_firCxMul_01_cRePlIm                                        = 1;
  defparam  firCxMul_01.R_cRePlIm                                        = R_firCxMul_01_cRePlIm;
  parameter R_firCxMul_01_cReMiIm                                        = 2;
  defparam  firCxMul_01.R_cReMiIm                                        = R_firCxMul_01_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_01_yRe_w-1:0]  firCxMul_01_yRe;
  wire                                      firCxMul_01_yRe_or;
  wire                                      firCxMul_01_yRe_ff;
  wire                                      firCxMul_01_yRe_we;

  wire             [firCxMul_01_yIm_w-1:0]  firCxMul_01_yIm;
  wire                                      firCxMul_01_yIm_or;
  wire                                      firCxMul_01_yIm_ff;
  wire                                      firCxMul_01_yIm_we;

  wire             [firCxMul_01_xRe_w-1:0]  firCxMul_01_xRe;
  wire                                      firCxMul_01_xRe_ir;
  wire                                      firCxMul_01_xRe_fe;
  wire                                      firCxMul_01_xRe_re;

  wire             [firCxMul_01_xIm_w-1:0]  firCxMul_01_xIm;
  wire                                      firCxMul_01_xIm_ir;
  wire                                      firCxMul_01_xIm_fe;
  wire                                      firCxMul_01_xIm_re;

  wire         [firCxMul_01_xRePlIm_w-1:0]  firCxMul_01_xRePlIm;
  wire                                      firCxMul_01_xRePlIm_ir;
  wire                                      firCxMul_01_xRePlIm_fe;
  wire                                      firCxMul_01_xRePlIm_re;

  wire            [firCxMul_01_run1_w-1:0]  firCxMul_01_run1;

  wire                                      firCxMul_01_regWe;
  wire                                      firCxMul_01_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_01(firCxMul_01_yRe, firCxMul_01_yRe_or, firCxMul_01_yRe_ff, firCxMul_01_yRe_we,
                       firCxMul_01_yIm, firCxMul_01_yIm_or, firCxMul_01_yIm_ff, firCxMul_01_yIm_we,
                       firCxMul_01_xRe, firCxMul_01_xRe_ir, firCxMul_01_xRe_fe, firCxMul_01_xRe_re, 
                       firCxMul_01_xIm, firCxMul_01_xIm_ir, firCxMul_01_xIm_fe, firCxMul_01_xIm_re, 
                       firCxMul_01_xRePlIm, firCxMul_01_xRePlIm_ir, firCxMul_01_xRePlIm_fe, firCxMul_01_xRePlIm_re, 
                       firCxMul_01_run1, 
                       regBus, regWe, regRe, firCxMul_01_regWe, firCxMul_01_regRe, clk, clk2, reset);


//==============================================================================
