//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter firCxMul_00_xRe_w           = 16;
  parameter firCxMul_00_xIm_w           = 16;
  parameter firCxMul_00_xRePlIm_w       = 17;

  // Outputs
  parameter firCxMul_00_yRe_w           = 16;
  parameter firCxMul_00_yIm_w           = 16;

  // Input control lines
  parameter firCxMul_00_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter firCxMul_00_cRe_w           = 16;
  parameter firCxMul_00_cRe_r           = 8192;
  parameter firCxMul_00_cRe_s           = 0;
  parameter firCxMul_00_cRePlIm_w       = 16;
  parameter firCxMul_00_cRePlIm_r       = 8192;
  parameter firCxMul_00_cRePlIm_s       = 0;
  parameter firCxMul_00_cReMiIm_w       = 16;
  parameter firCxMul_00_cReMiIm_r       = 8192;
  parameter firCxMul_00_cReMiIm_s       = 0;

  // Parameters
  parameter firCxMul_00_w               = 16;
  parameter firCxMul_00_qc              = 13;

  // Iregs
  parameter firCxMul_00_mA_w            = 21;
  parameter firCxMul_00_mA_n            = 1;
  parameter firCxMul_00_mA_m            = `CLOG2(1);
  parameter firCxMul_00_mB_w            = 21;
  parameter firCxMul_00_mB_n            = 1;
  parameter firCxMul_00_mB_m            = `CLOG2(1);
  parameter firCxMul_00_mC_w            = 21;
  parameter firCxMul_00_mC_n            = 1;
  parameter firCxMul_00_mC_m            = `CLOG2(1);
  parameter firCxMul_00_yReR_w          = 16;
  parameter firCxMul_00_yReR_n          = 1;
  parameter firCxMul_00_yReR_m          = `CLOG2(1);
  parameter firCxMul_00_yImR_w          = 16;
  parameter firCxMul_00_yImR_n          = 1;
  parameter firCxMul_00_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam firCxMul_00.xRe_w           = firCxMul_00_xRe_w;
  defparam firCxMul_00.xIm_w           = firCxMul_00_xIm_w;
  defparam firCxMul_00.xRePlIm_w       = firCxMul_00_xRePlIm_w;
  defparam firCxMul_00.yRe_w           = firCxMul_00_yRe_w;
  defparam firCxMul_00.yIm_w           = firCxMul_00_yIm_w;
  defparam firCxMul_00.run1_w          = firCxMul_00_run1_w;
  defparam firCxMul_00.cRe_w           = firCxMul_00_cRe_w;
  defparam firCxMul_00.cRe_r           = firCxMul_00_cRe_r;
  defparam firCxMul_00.cRe_s           = firCxMul_00_cRe_s;
  defparam firCxMul_00.cRePlIm_w       = firCxMul_00_cRePlIm_w;
  defparam firCxMul_00.cRePlIm_r       = firCxMul_00_cRePlIm_r;
  defparam firCxMul_00.cRePlIm_s       = firCxMul_00_cRePlIm_s;
  defparam firCxMul_00.cReMiIm_w       = firCxMul_00_cReMiIm_w;
  defparam firCxMul_00.cReMiIm_r       = firCxMul_00_cReMiIm_r;
  defparam firCxMul_00.cReMiIm_s       = firCxMul_00_cReMiIm_s;
  defparam firCxMul_00.w               = firCxMul_00_w;
  defparam firCxMul_00.qc              = firCxMul_00_qc;
  defparam firCxMul_00.mA_w            = firCxMul_00_mA_w;
  defparam firCxMul_00.mA_n            = firCxMul_00_mA_n;
  defparam firCxMul_00.mA_m            = firCxMul_00_mA_m;
  defparam firCxMul_00.mB_w            = firCxMul_00_mB_w;
  defparam firCxMul_00.mB_n            = firCxMul_00_mB_n;
  defparam firCxMul_00.mB_m            = firCxMul_00_mB_m;
  defparam firCxMul_00.mC_w            = firCxMul_00_mC_w;
  defparam firCxMul_00.mC_n            = firCxMul_00_mC_n;
  defparam firCxMul_00.mC_m            = firCxMul_00_mC_m;
  defparam firCxMul_00.yReR_w          = firCxMul_00_yReR_w;
  defparam firCxMul_00.yReR_n          = firCxMul_00_yReR_n;
  defparam firCxMul_00.yReR_m          = firCxMul_00_yReR_m;
  defparam firCxMul_00.yImR_w          = firCxMul_00_yImR_w;
  defparam firCxMul_00.yImR_n          = firCxMul_00_yImR_n;
  defparam firCxMul_00.yImR_m          = firCxMul_00_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_firCxMul_00_cRe                                            = 0;
  defparam  firCxMul_00.R_cRe                                            = R_firCxMul_00_cRe;
  parameter R_firCxMul_00_cRePlIm                                        = 1;
  defparam  firCxMul_00.R_cRePlIm                                        = R_firCxMul_00_cRePlIm;
  parameter R_firCxMul_00_cReMiIm                                        = 2;
  defparam  firCxMul_00.R_cReMiIm                                        = R_firCxMul_00_cReMiIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [firCxMul_00_yRe_w-1:0]  firCxMul_00_yRe;
  wire                                      firCxMul_00_yRe_or;
  wire                                      firCxMul_00_yRe_ff;
  wire                                      firCxMul_00_yRe_we;

  wire             [firCxMul_00_yIm_w-1:0]  firCxMul_00_yIm;
  wire                                      firCxMul_00_yIm_or;
  wire                                      firCxMul_00_yIm_ff;
  wire                                      firCxMul_00_yIm_we;

  wire             [firCxMul_00_xRe_w-1:0]  firCxMul_00_xRe;
  wire                                      firCxMul_00_xRe_ir;
  wire                                      firCxMul_00_xRe_fe;
  wire                                      firCxMul_00_xRe_re;

  wire             [firCxMul_00_xIm_w-1:0]  firCxMul_00_xIm;
  wire                                      firCxMul_00_xIm_ir;
  wire                                      firCxMul_00_xIm_fe;
  wire                                      firCxMul_00_xIm_re;

  wire         [firCxMul_00_xRePlIm_w-1:0]  firCxMul_00_xRePlIm;
  wire                                      firCxMul_00_xRePlIm_ir;
  wire                                      firCxMul_00_xRePlIm_fe;
  wire                                      firCxMul_00_xRePlIm_re;

  wire            [firCxMul_00_run1_w-1:0]  firCxMul_00_run1;

  wire                                      firCxMul_00_regWe;
  wire                                      firCxMul_00_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  firCxMul firCxMul_00(firCxMul_00_yRe, firCxMul_00_yRe_or, firCxMul_00_yRe_ff, firCxMul_00_yRe_we,
                       firCxMul_00_yIm, firCxMul_00_yIm_or, firCxMul_00_yIm_ff, firCxMul_00_yIm_we,
                       firCxMul_00_xRe, firCxMul_00_xRe_ir, firCxMul_00_xRe_fe, firCxMul_00_xRe_re, 
                       firCxMul_00_xIm, firCxMul_00_xIm_ir, firCxMul_00_xIm_fe, firCxMul_00_xIm_re, 
                       firCxMul_00_xRePlIm, firCxMul_00_xRePlIm_ir, firCxMul_00_xRePlIm_fe, firCxMul_00_xRePlIm_re, 
                       firCxMul_00_run1, 
                       regBus, regWe, regRe, firCxMul_00_regWe, firCxMul_00_regRe, clk, clk2, reset);


//==============================================================================
