//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter extIf_phy1_rx_w            = 16;

  // Outputs
  parameter extIf_phy1_tx_w            = 16;

  // Input control lines

  // Output control lines
  parameter extIf_phy1_resetOut_w      = 1;
  parameter extIf_phy1_irqRx_w         = 1;
  parameter extIf_phy1_irqTx_w         = 1;

  // Eregs
  parameter extIf_phy1_rxDat_w         = 16;
  parameter extIf_phy1_rxDat_r         = 0;
  parameter extIf_phy1_rxDat_s         = 0;
  parameter extIf_phy1_rxSt_w          = 1;
  parameter extIf_phy1_rxSt_r          = 0;
  parameter extIf_phy1_rxSt_s          = 0;
  parameter extIf_phy1_txDat_w         = 16;
  parameter extIf_phy1_txDat_r         = 0;
  parameter extIf_phy1_txDat_s         = 0;
  parameter extIf_phy1_txSt_w          = 1;
  parameter extIf_phy1_txSt_r          = 0;
  parameter extIf_phy1_txSt_s          = 0;
  parameter extIf_phy1_ctrlOn_w        = 1;
  parameter extIf_phy1_ctrlOn_r        = 1;
  parameter extIf_phy1_ctrlOn_s        = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam extIf_phy1.rx_w            = extIf_phy1_rx_w;
  defparam extIf_phy1.tx_w            = extIf_phy1_tx_w;
  defparam extIf_phy1.resetOut_w      = extIf_phy1_resetOut_w;
  defparam extIf_phy1.irqRx_w         = extIf_phy1_irqRx_w;
  defparam extIf_phy1.irqTx_w         = extIf_phy1_irqTx_w;
  defparam extIf_phy1.rxDat_w         = extIf_phy1_rxDat_w;
  defparam extIf_phy1.rxDat_r         = extIf_phy1_rxDat_r;
  defparam extIf_phy1.rxDat_s         = extIf_phy1_rxDat_s;
  defparam extIf_phy1.rxSt_w          = extIf_phy1_rxSt_w;
  defparam extIf_phy1.rxSt_r          = extIf_phy1_rxSt_r;
  defparam extIf_phy1.rxSt_s          = extIf_phy1_rxSt_s;
  defparam extIf_phy1.txDat_w         = extIf_phy1_txDat_w;
  defparam extIf_phy1.txDat_r         = extIf_phy1_txDat_r;
  defparam extIf_phy1.txDat_s         = extIf_phy1_txDat_s;
  defparam extIf_phy1.txSt_w          = extIf_phy1_txSt_w;
  defparam extIf_phy1.txSt_r          = extIf_phy1_txSt_r;
  defparam extIf_phy1.txSt_s          = extIf_phy1_txSt_s;
  defparam extIf_phy1.ctrlOn_w        = extIf_phy1_ctrlOn_w;
  defparam extIf_phy1.ctrlOn_r        = extIf_phy1_ctrlOn_r;
  defparam extIf_phy1.ctrlOn_s        = extIf_phy1_ctrlOn_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_extIf_phy1_rxDat                                           = 0;
  defparam  extIf_phy1.R_rxDat                                           = R_extIf_phy1_rxDat;
  parameter R_extIf_phy1_rxSt                                            = 1;
  defparam  extIf_phy1.R_rxSt                                            = R_extIf_phy1_rxSt;
  parameter R_extIf_phy1_txDat                                           = 2;
  defparam  extIf_phy1.R_txDat                                           = R_extIf_phy1_txDat;
  parameter R_extIf_phy1_txSt                                            = 3;
  defparam  extIf_phy1.R_txSt                                            = R_extIf_phy1_txSt;
  parameter R_extIf_phy1_ctrlOn                                          = 4;
  defparam  extIf_phy1.R_ctrlOn                                          = R_extIf_phy1_ctrlOn;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [extIf_phy1_tx_w-1:0]  extIf_phy1_tx;
  wire                                      extIf_phy1_tx_or;
  wire                                      extIf_phy1_tx_ff;
  wire                                      extIf_phy1_tx_we;

  wire               [extIf_phy1_rx_w-1:0]  extIf_phy1_rx;
  wire                                      extIf_phy1_rx_ir;
  wire                                      extIf_phy1_rx_fe;
  wire                                      extIf_phy1_rx_re;

  wire         [extIf_phy1_resetOut_w-1:0]  extIf_phy1_resetOut;
  wire            [extIf_phy1_irqRx_w-1:0]  extIf_phy1_irqRx;
  wire            [extIf_phy1_irqTx_w-1:0]  extIf_phy1_irqTx;

  wire                                      extIf_phy1_regWe;
  wire                                      extIf_phy1_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  extIf extIf_phy1(extIf_phy1_tx, extIf_phy1_tx_or, extIf_phy1_tx_ff, extIf_phy1_tx_we,
                   extIf_phy1_rx, extIf_phy1_rx_ir, extIf_phy1_rx_fe, extIf_phy1_rx_re, 
                   extIf_phy1_resetOut, 
                   extIf_phy1_irqRx, 
                   extIf_phy1_irqTx, 
                   regBus, regWe, regRe, extIf_phy1_regWe, extIf_phy1_regRe, clk, clk2, reset);


//==============================================================================
