//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter extIf_phy0_rx_w            = 16;

  // Outputs
  parameter extIf_phy0_tx_w            = 16;

  // Input control lines

  // Output control lines
  parameter extIf_phy0_resetOut_w      = 1;
  parameter extIf_phy0_irqRx_w         = 1;
  parameter extIf_phy0_irqTx_w         = 1;

  // Eregs
  parameter extIf_phy0_rxDat_w         = 16;
  parameter extIf_phy0_rxDat_r         = 0;
  parameter extIf_phy0_rxDat_s         = 0;
  parameter extIf_phy0_rxSt_w          = 1;
  parameter extIf_phy0_rxSt_r          = 0;
  parameter extIf_phy0_rxSt_s          = 0;
  parameter extIf_phy0_txDat_w         = 16;
  parameter extIf_phy0_txDat_r         = 0;
  parameter extIf_phy0_txDat_s         = 0;
  parameter extIf_phy0_txSt_w          = 1;
  parameter extIf_phy0_txSt_r          = 0;
  parameter extIf_phy0_txSt_s          = 0;
  parameter extIf_phy0_ctrlOn_w        = 1;
  parameter extIf_phy0_ctrlOn_r        = 1;
  parameter extIf_phy0_ctrlOn_s        = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam extIf_phy0.rx_w            = extIf_phy0_rx_w;
  defparam extIf_phy0.tx_w            = extIf_phy0_tx_w;
  defparam extIf_phy0.resetOut_w      = extIf_phy0_resetOut_w;
  defparam extIf_phy0.irqRx_w         = extIf_phy0_irqRx_w;
  defparam extIf_phy0.irqTx_w         = extIf_phy0_irqTx_w;
  defparam extIf_phy0.rxDat_w         = extIf_phy0_rxDat_w;
  defparam extIf_phy0.rxDat_r         = extIf_phy0_rxDat_r;
  defparam extIf_phy0.rxDat_s         = extIf_phy0_rxDat_s;
  defparam extIf_phy0.rxSt_w          = extIf_phy0_rxSt_w;
  defparam extIf_phy0.rxSt_r          = extIf_phy0_rxSt_r;
  defparam extIf_phy0.rxSt_s          = extIf_phy0_rxSt_s;
  defparam extIf_phy0.txDat_w         = extIf_phy0_txDat_w;
  defparam extIf_phy0.txDat_r         = extIf_phy0_txDat_r;
  defparam extIf_phy0.txDat_s         = extIf_phy0_txDat_s;
  defparam extIf_phy0.txSt_w          = extIf_phy0_txSt_w;
  defparam extIf_phy0.txSt_r          = extIf_phy0_txSt_r;
  defparam extIf_phy0.txSt_s          = extIf_phy0_txSt_s;
  defparam extIf_phy0.ctrlOn_w        = extIf_phy0_ctrlOn_w;
  defparam extIf_phy0.ctrlOn_r        = extIf_phy0_ctrlOn_r;
  defparam extIf_phy0.ctrlOn_s        = extIf_phy0_ctrlOn_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_extIf_phy0_rxDat                                           = 0;
  defparam  extIf_phy0.R_rxDat                                           = R_extIf_phy0_rxDat;
  parameter R_extIf_phy0_rxSt                                            = 1;
  defparam  extIf_phy0.R_rxSt                                            = R_extIf_phy0_rxSt;
  parameter R_extIf_phy0_txDat                                           = 2;
  defparam  extIf_phy0.R_txDat                                           = R_extIf_phy0_txDat;
  parameter R_extIf_phy0_txSt                                            = 3;
  defparam  extIf_phy0.R_txSt                                            = R_extIf_phy0_txSt;
  parameter R_extIf_phy0_ctrlOn                                          = 4;
  defparam  extIf_phy0.R_ctrlOn                                          = R_extIf_phy0_ctrlOn;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [extIf_phy0_tx_w-1:0]  extIf_phy0_tx;
  wire                                      extIf_phy0_tx_or;
  wire                                      extIf_phy0_tx_ff;
  wire                                      extIf_phy0_tx_we;

  wire               [extIf_phy0_rx_w-1:0]  extIf_phy0_rx;
  wire                                      extIf_phy0_rx_ir;
  wire                                      extIf_phy0_rx_fe;
  wire                                      extIf_phy0_rx_re;

  wire         [extIf_phy0_resetOut_w-1:0]  extIf_phy0_resetOut;
  wire            [extIf_phy0_irqRx_w-1:0]  extIf_phy0_irqRx;
  wire            [extIf_phy0_irqTx_w-1:0]  extIf_phy0_irqTx;

  wire                                      extIf_phy0_regWe;
  wire                                      extIf_phy0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  extIf extIf_phy0(extIf_phy0_tx, extIf_phy0_tx_or, extIf_phy0_tx_ff, extIf_phy0_tx_we,
                   extIf_phy0_rx, extIf_phy0_rx_ir, extIf_phy0_rx_fe, extIf_phy0_rx_re, 
                   extIf_phy0_resetOut, 
                   extIf_phy0_irqRx, 
                   extIf_phy0_irqTx, 
                   regBus, regWe, regRe, extIf_phy0_regWe, extIf_phy0_regRe, clk, clk2, reset);


//==============================================================================
