//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dcOff_0_xRe_w           = 16;
  parameter dcOff_0_xIm_w           = 16;

  // Outputs
  parameter dcOff_0_yRe_w           = 16;
  parameter dcOff_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter dcOff_0_run1_w          = 1;
  parameter dcOff_0_run1_r          = 0;
  parameter dcOff_0_run1_s          = 0;
  parameter dcOff_0_dcRe_w          = 16;
  parameter dcOff_0_dcRe_r          = 0;
  parameter dcOff_0_dcRe_s          = 1;
  parameter dcOff_0_dcIm_w          = 16;
  parameter dcOff_0_dcIm_r          = 0;
  parameter dcOff_0_dcIm_s          = 1;

  // Parameters
  parameter dcOff_0_w               = 16;

  // Iregs
  parameter dcOff_0_yReR_w          = 16;
  parameter dcOff_0_yReR_n          = 1;
  parameter dcOff_0_yReR_m          = `CLOG2(1);
  parameter dcOff_0_yImR_w          = 16;
  parameter dcOff_0_yImR_n          = 1;
  parameter dcOff_0_yImR_m          = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dcOff_0.xRe_w           = dcOff_0_xRe_w;
  defparam dcOff_0.xIm_w           = dcOff_0_xIm_w;
  defparam dcOff_0.yRe_w           = dcOff_0_yRe_w;
  defparam dcOff_0.yIm_w           = dcOff_0_yIm_w;
  defparam dcOff_0.run1_w          = dcOff_0_run1_w;
  defparam dcOff_0.run1_r          = dcOff_0_run1_r;
  defparam dcOff_0.run1_s          = dcOff_0_run1_s;
  defparam dcOff_0.dcRe_w          = dcOff_0_dcRe_w;
  defparam dcOff_0.dcRe_r          = dcOff_0_dcRe_r;
  defparam dcOff_0.dcRe_s          = dcOff_0_dcRe_s;
  defparam dcOff_0.dcIm_w          = dcOff_0_dcIm_w;
  defparam dcOff_0.dcIm_r          = dcOff_0_dcIm_r;
  defparam dcOff_0.dcIm_s          = dcOff_0_dcIm_s;
  defparam dcOff_0.w               = dcOff_0_w;
  defparam dcOff_0.yReR_w          = dcOff_0_yReR_w;
  defparam dcOff_0.yReR_n          = dcOff_0_yReR_n;
  defparam dcOff_0.yReR_m          = dcOff_0_yReR_m;
  defparam dcOff_0.yImR_w          = dcOff_0_yImR_w;
  defparam dcOff_0.yImR_n          = dcOff_0_yImR_n;
  defparam dcOff_0.yImR_m          = dcOff_0_yImR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dcOff_0_run1                                               = 0;
  defparam  dcOff_0.R_run1                                               = R_dcOff_0_run1;
  parameter R_dcOff_0_dcRe                                               = 1;
  defparam  dcOff_0.R_dcRe                                               = R_dcOff_0_dcRe;
  parameter R_dcOff_0_dcIm                                               = 2;
  defparam  dcOff_0.R_dcIm                                               = R_dcOff_0_dcIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [dcOff_0_yRe_w-1:0]  dcOff_0_yRe;
  wire                                      dcOff_0_yRe_or;
  wire                                      dcOff_0_yRe_ff;
  wire                                      dcOff_0_yRe_we;

  wire                 [dcOff_0_yIm_w-1:0]  dcOff_0_yIm;
  wire                                      dcOff_0_yIm_or;
  wire                                      dcOff_0_yIm_ff;
  wire                                      dcOff_0_yIm_we;

  wire                 [dcOff_0_xRe_w-1:0]  dcOff_0_xRe;
  wire                                      dcOff_0_xRe_ir;
  wire                                      dcOff_0_xRe_fe;
  wire                                      dcOff_0_xRe_re;

  wire                 [dcOff_0_xIm_w-1:0]  dcOff_0_xIm;
  wire                                      dcOff_0_xIm_ir;
  wire                                      dcOff_0_xIm_fe;
  wire                                      dcOff_0_xIm_re;

  wire                                      dcOff_0_regWe;
  wire                                      dcOff_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dcOff dcOff_0(dcOff_0_yRe, dcOff_0_yRe_or, dcOff_0_yRe_ff, dcOff_0_yRe_we,
                dcOff_0_yIm, dcOff_0_yIm_or, dcOff_0_yIm_ff, dcOff_0_yIm_we,
                dcOff_0_xRe, dcOff_0_xRe_ir, dcOff_0_xRe_fe, dcOff_0_xRe_re, 
                dcOff_0_xIm, dcOff_0_xIm_ir, dcOff_0_xIm_fe, dcOff_0_xIm_re, 
                regBus, regWe, regRe, dcOff_0_regWe, dcOff_0_regRe, clk, clk2, reset);


//==============================================================================
