//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dataBuf_phy0_x_w             = VrfDataWidth_C;

  // Outputs
  parameter dataBuf_phy0_y_w             = VrfDataWidth_C;

  // Input control lines

  // Output control lines

  // Eregs
  parameter dataBuf_phy0_run1_w          = 3;
  parameter dataBuf_phy0_run1_r          = 0;
  parameter dataBuf_phy0_run1_s          = 0;
  parameter dataBuf_phy0_datAdr_w        = VrfRxTxBufAdrWidth_C;
  parameter dataBuf_phy0_datAdr_r        = 0;
  parameter dataBuf_phy0_datAdr_s        = 0;
  parameter dataBuf_phy0_datVal_w        = VrfDataWidth_C;
  parameter dataBuf_phy0_datVal_r        = 0;
  parameter dataBuf_phy0_datVal_s        = 0;

  // Parameters
  parameter dataBuf_phy0_w               = VrfDataWidth_C;
  parameter dataBuf_phy0_m               = VrfRxTxBufAdrWidth_C;
  parameter dataBuf_phy0_ModeReset       = 0;
  parameter dataBuf_phy0_ModeWrReg       = 1;
  parameter dataBuf_phy0_ModeWrPort      = 2;
  parameter dataBuf_phy0_ModeRdReg       = 5;
  parameter dataBuf_phy0_ModeRdPort      = 6;
  parameter dataBuf_phy0_ModeRdPortMult  = 7;

  // Iregs

  // Single ported memories
  parameter dataBuf_phy0_buf0_w          = VrfDataWidth_C;
  parameter dataBuf_phy0_buf0_n          = VrfRxTxBufNum_C;
  parameter dataBuf_phy0_buf0_m          = `CLOG2(VrfRxTxBufNum_C);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dataBuf_phy0.x_w             = dataBuf_phy0_x_w;
  defparam dataBuf_phy0.y_w             = dataBuf_phy0_y_w;
  defparam dataBuf_phy0.run1_w          = dataBuf_phy0_run1_w;
  defparam dataBuf_phy0.run1_r          = dataBuf_phy0_run1_r;
  defparam dataBuf_phy0.run1_s          = dataBuf_phy0_run1_s;
  defparam dataBuf_phy0.datAdr_w        = dataBuf_phy0_datAdr_w;
  defparam dataBuf_phy0.datAdr_r        = dataBuf_phy0_datAdr_r;
  defparam dataBuf_phy0.datAdr_s        = dataBuf_phy0_datAdr_s;
  defparam dataBuf_phy0.datVal_w        = dataBuf_phy0_datVal_w;
  defparam dataBuf_phy0.datVal_r        = dataBuf_phy0_datVal_r;
  defparam dataBuf_phy0.datVal_s        = dataBuf_phy0_datVal_s;
  defparam dataBuf_phy0.w               = dataBuf_phy0_w;
  defparam dataBuf_phy0.m               = dataBuf_phy0_m;
  defparam dataBuf_phy0.ModeReset       = dataBuf_phy0_ModeReset;
  defparam dataBuf_phy0.ModeWrReg       = dataBuf_phy0_ModeWrReg;
  defparam dataBuf_phy0.ModeWrPort      = dataBuf_phy0_ModeWrPort;
  defparam dataBuf_phy0.ModeRdReg       = dataBuf_phy0_ModeRdReg;
  defparam dataBuf_phy0.ModeRdPort      = dataBuf_phy0_ModeRdPort;
  defparam dataBuf_phy0.ModeRdPortMult  = dataBuf_phy0_ModeRdPortMult;
  defparam dataBuf_phy0.buf0_w          = dataBuf_phy0_buf0_w;
  defparam dataBuf_phy0.buf0_n          = dataBuf_phy0_buf0_n;
  defparam dataBuf_phy0.buf0_m          = dataBuf_phy0_buf0_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dataBuf_phy0_run1                                          = 0;
  defparam  dataBuf_phy0.R_run1                                          = R_dataBuf_phy0_run1;
  parameter R_dataBuf_phy0_datAdr                                        = 1;
  defparam  dataBuf_phy0.R_datAdr                                        = R_dataBuf_phy0_datAdr;
  parameter R_dataBuf_phy0_datVal                                        = 2;
  defparam  dataBuf_phy0.R_datVal                                        = R_dataBuf_phy0_datVal;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [dataBuf_phy0_y_w-1:0]  dataBuf_phy0_y;
  wire                                      dataBuf_phy0_y_or;
  wire                                      dataBuf_phy0_y_ff;
  wire                                      dataBuf_phy0_y_we;

  wire              [dataBuf_phy0_x_w-1:0]  dataBuf_phy0_x;
  wire                                      dataBuf_phy0_x_ir;
  wire                                      dataBuf_phy0_x_fe;
  wire                                      dataBuf_phy0_x_re;

  wire                                      dataBuf_phy0_regWe;
  wire                                      dataBuf_phy0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dataBuf dataBuf_phy0(dataBuf_phy0_y, dataBuf_phy0_y_or, dataBuf_phy0_y_ff, dataBuf_phy0_y_we,
                       dataBuf_phy0_x, dataBuf_phy0_x_ir, dataBuf_phy0_x_fe, dataBuf_phy0_x_re, 
                       regBus, regWe, regRe, dataBuf_phy0_regWe, dataBuf_phy0_regRe, clk, clk2, reset);


//==============================================================================
