//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dacSim_0_xRe_w           = 16;
  parameter dacSim_0_xIm_w           = 16;

  // Outputs
  parameter dacSim_0_yRe_w           = 16;
  parameter dacSim_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter dacSim_0_run1_w          = 2;
  parameter dacSim_0_run1_r          = 0;
  parameter dacSim_0_run1_s          = 0;
  parameter dacSim_0_pLo16_w         = 16;
  parameter dacSim_0_pLo16_r         = 1;
  parameter dacSim_0_pLo16_s         = 0;
  parameter dacSim_0_pHi16_w         = 16;
  parameter dacSim_0_pHi16_r         = 0;
  parameter dacSim_0_pHi16_s         = 0;
  parameter dacSim_0_qLo16_w         = 16;
  parameter dacSim_0_qLo16_r         = 1;
  parameter dacSim_0_qLo16_s         = 0;
  parameter dacSim_0_qHi16_w         = 16;
  parameter dacSim_0_qHi16_r         = 0;
  parameter dacSim_0_qHi16_s         = 0;

  // Parameters
  parameter dacSim_0_w               = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dacSim_0.xRe_w           = dacSim_0_xRe_w;
  defparam dacSim_0.xIm_w           = dacSim_0_xIm_w;
  defparam dacSim_0.yRe_w           = dacSim_0_yRe_w;
  defparam dacSim_0.yIm_w           = dacSim_0_yIm_w;
  defparam dacSim_0.run1_w          = dacSim_0_run1_w;
  defparam dacSim_0.run1_r          = dacSim_0_run1_r;
  defparam dacSim_0.run1_s          = dacSim_0_run1_s;
  defparam dacSim_0.pLo16_w         = dacSim_0_pLo16_w;
  defparam dacSim_0.pLo16_r         = dacSim_0_pLo16_r;
  defparam dacSim_0.pLo16_s         = dacSim_0_pLo16_s;
  defparam dacSim_0.pHi16_w         = dacSim_0_pHi16_w;
  defparam dacSim_0.pHi16_r         = dacSim_0_pHi16_r;
  defparam dacSim_0.pHi16_s         = dacSim_0_pHi16_s;
  defparam dacSim_0.qLo16_w         = dacSim_0_qLo16_w;
  defparam dacSim_0.qLo16_r         = dacSim_0_qLo16_r;
  defparam dacSim_0.qLo16_s         = dacSim_0_qLo16_s;
  defparam dacSim_0.qHi16_w         = dacSim_0_qHi16_w;
  defparam dacSim_0.qHi16_r         = dacSim_0_qHi16_r;
  defparam dacSim_0.qHi16_s         = dacSim_0_qHi16_s;
  defparam dacSim_0.w               = dacSim_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dacSim_0_run1                                              = 0;
  defparam  dacSim_0.R_run1                                              = R_dacSim_0_run1;
  parameter R_dacSim_0_pLo16                                             = 1;
  defparam  dacSim_0.R_pLo16                                             = R_dacSim_0_pLo16;
  parameter R_dacSim_0_pHi16                                             = 2;
  defparam  dacSim_0.R_pHi16                                             = R_dacSim_0_pHi16;
  parameter R_dacSim_0_qLo16                                             = 3;
  defparam  dacSim_0.R_qLo16                                             = R_dacSim_0_qLo16;
  parameter R_dacSim_0_qHi16                                             = 4;
  defparam  dacSim_0.R_qHi16                                             = R_dacSim_0_qHi16;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [dacSim_0_yRe_w-1:0]  dacSim_0_yRe;
  wire                                      dacSim_0_yRe_or;
  wire                                      dacSim_0_yRe_ff;
  wire                                      dacSim_0_yRe_we;

  wire                [dacSim_0_yIm_w-1:0]  dacSim_0_yIm;
  wire                                      dacSim_0_yIm_or;
  wire                                      dacSim_0_yIm_ff;
  wire                                      dacSim_0_yIm_we;

  wire                [dacSim_0_xRe_w-1:0]  dacSim_0_xRe;
  wire                                      dacSim_0_xRe_ir;
  wire                                      dacSim_0_xRe_fe;
  wire                                      dacSim_0_xRe_re;

  wire                [dacSim_0_xIm_w-1:0]  dacSim_0_xIm;
  wire                                      dacSim_0_xIm_ir;
  wire                                      dacSim_0_xIm_fe;
  wire                                      dacSim_0_xIm_re;

  wire                                      dacSim_0_regWe;
  wire                                      dacSim_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dacSim dacSim_0(dacSim_0_yRe, dacSim_0_yRe_or, dacSim_0_yRe_ff, dacSim_0_yRe_we,
                  dacSim_0_yIm, dacSim_0_yIm_or, dacSim_0_yIm_ff, dacSim_0_yIm_we,
                  dacSim_0_xRe, dacSim_0_xRe_ir, dacSim_0_xRe_fe, dacSim_0_xRe_re, 
                  dacSim_0_xIm, dacSim_0_xIm_ir, dacSim_0_xIm_fe, dacSim_0_xIm_re, 
                  regBus, regWe, regRe, dacSim_0_regWe, dacSim_0_regRe, clk, clk2, reset);


//==============================================================================
