//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter crdcPhRot_0_xRe_w           = 16;
  parameter crdcPhRot_0_xIm_w           = 16;
  parameter crdcPhRot_0_ph_w            = 20;

  // Outputs
  parameter crdcPhRot_0_yRe_w           = 16;
  parameter crdcPhRot_0_yIm_w           = 16;

  // Input control lines
  parameter crdcPhRot_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter crdcPhRot_0_w               = 16;
  parameter crdcPhRot_0_wp              = 20;
  parameter crdcPhRot_0_wi              = 20;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam crdcPhRot_0.xRe_w           = crdcPhRot_0_xRe_w;
  defparam crdcPhRot_0.xIm_w           = crdcPhRot_0_xIm_w;
  defparam crdcPhRot_0.ph_w            = crdcPhRot_0_ph_w;
  defparam crdcPhRot_0.yRe_w           = crdcPhRot_0_yRe_w;
  defparam crdcPhRot_0.yIm_w           = crdcPhRot_0_yIm_w;
  defparam crdcPhRot_0.run1_w          = crdcPhRot_0_run1_w;
  defparam crdcPhRot_0.w               = crdcPhRot_0_w;
  defparam crdcPhRot_0.wp              = crdcPhRot_0_wp;
  defparam crdcPhRot_0.wi              = crdcPhRot_0_wi;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [crdcPhRot_0_yRe_w-1:0]  crdcPhRot_0_yRe;
  wire                                      crdcPhRot_0_yRe_or;
  wire                                      crdcPhRot_0_yRe_ff;
  wire                                      crdcPhRot_0_yRe_we;

  wire             [crdcPhRot_0_yIm_w-1:0]  crdcPhRot_0_yIm;
  wire                                      crdcPhRot_0_yIm_or;
  wire                                      crdcPhRot_0_yIm_ff;
  wire                                      crdcPhRot_0_yIm_we;

  wire             [crdcPhRot_0_xRe_w-1:0]  crdcPhRot_0_xRe;
  wire                                      crdcPhRot_0_xRe_ir;
  wire                                      crdcPhRot_0_xRe_fe;
  wire                                      crdcPhRot_0_xRe_re;

  wire             [crdcPhRot_0_xIm_w-1:0]  crdcPhRot_0_xIm;
  wire                                      crdcPhRot_0_xIm_ir;
  wire                                      crdcPhRot_0_xIm_fe;
  wire                                      crdcPhRot_0_xIm_re;

  wire              [crdcPhRot_0_ph_w-1:0]  crdcPhRot_0_ph;
  wire                                      crdcPhRot_0_ph_ir;
  wire                                      crdcPhRot_0_ph_fe;
  wire                                      crdcPhRot_0_ph_re;

  wire            [crdcPhRot_0_run1_w-1:0]  crdcPhRot_0_run1;

  wire                                      crdcPhRot_0_regWe;
  wire                                      crdcPhRot_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  crdcPhRot crdcPhRot_0(crdcPhRot_0_yRe, crdcPhRot_0_yRe_or, crdcPhRot_0_yRe_ff, crdcPhRot_0_yRe_we,
                        crdcPhRot_0_yIm, crdcPhRot_0_yIm_or, crdcPhRot_0_yIm_ff, crdcPhRot_0_yIm_we,
                        crdcPhRot_0_xRe, crdcPhRot_0_xRe_ir, crdcPhRot_0_xRe_fe, crdcPhRot_0_xRe_re, 
                        crdcPhRot_0_xIm, crdcPhRot_0_xIm_ir, crdcPhRot_0_xIm_fe, crdcPhRot_0_xIm_re, 
                        crdcPhRot_0_ph, crdcPhRot_0_ph_ir, crdcPhRot_0_ph_fe, crdcPhRot_0_ph_re, 
                        crdcPhRot_0_run1, 
                        regBus, regWe, regRe, crdcPhRot_0_regWe, crdcPhRot_0_regRe, clk, clk2, reset);


//==============================================================================
