//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter crdcAbs_0_xRe_w           = 16;
  parameter crdcAbs_0_xIm_w           = 16;

  // Outputs
  parameter crdcAbs_0_yAbs_w          = 15;
  parameter crdcAbs_0_yPh_w           = 16;

  // Input control lines
  parameter crdcAbs_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter crdcAbs_0_w               = 16;
  parameter crdcAbs_0_wa              = 15;
  parameter crdcAbs_0_wp              = 20;
  parameter crdcAbs_0_wi              = 20;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam crdcAbs_0.xRe_w           = crdcAbs_0_xRe_w;
  defparam crdcAbs_0.xIm_w           = crdcAbs_0_xIm_w;
  defparam crdcAbs_0.yAbs_w          = crdcAbs_0_yAbs_w;
  defparam crdcAbs_0.yPh_w           = crdcAbs_0_yPh_w;
  defparam crdcAbs_0.run1_w          = crdcAbs_0_run1_w;
  defparam crdcAbs_0.w               = crdcAbs_0_w;
  defparam crdcAbs_0.wa              = crdcAbs_0_wa;
  defparam crdcAbs_0.wp              = crdcAbs_0_wp;
  defparam crdcAbs_0.wi              = crdcAbs_0_wi;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [crdcAbs_0_yAbs_w-1:0]  crdcAbs_0_yAbs;
  wire                                      crdcAbs_0_yAbs_or;
  wire                                      crdcAbs_0_yAbs_ff;
  wire                                      crdcAbs_0_yAbs_we;

  wire               [crdcAbs_0_yPh_w-1:0]  crdcAbs_0_yPh;
  wire                                      crdcAbs_0_yPh_or;
  wire                                      crdcAbs_0_yPh_ff;
  wire                                      crdcAbs_0_yPh_we;

  wire               [crdcAbs_0_xRe_w-1:0]  crdcAbs_0_xRe;
  wire                                      crdcAbs_0_xRe_ir;
  wire                                      crdcAbs_0_xRe_fe;
  wire                                      crdcAbs_0_xRe_re;

  wire               [crdcAbs_0_xIm_w-1:0]  crdcAbs_0_xIm;
  wire                                      crdcAbs_0_xIm_ir;
  wire                                      crdcAbs_0_xIm_fe;
  wire                                      crdcAbs_0_xIm_re;

  wire              [crdcAbs_0_run1_w-1:0]  crdcAbs_0_run1;

  wire                                      crdcAbs_0_regWe;
  wire                                      crdcAbs_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  crdcAbs crdcAbs_0(crdcAbs_0_yAbs, crdcAbs_0_yAbs_or, crdcAbs_0_yAbs_ff, crdcAbs_0_yAbs_we,
                    crdcAbs_0_yPh, crdcAbs_0_yPh_or, crdcAbs_0_yPh_ff, crdcAbs_0_yPh_we,
                    crdcAbs_0_xRe, crdcAbs_0_xRe_ir, crdcAbs_0_xRe_fe, crdcAbs_0_xRe_re, 
                    crdcAbs_0_xIm, crdcAbs_0_xIm_ir, crdcAbs_0_xIm_fe, crdcAbs_0_xIm_re, 
                    crdcAbs_0_run1, 
                    regBus, regWe, regRe, crdcAbs_0_regWe, crdcAbs_0_regRe, clk, clk2, reset);


//==============================================================================
