//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter awgn_0_xRe_w           = 32;
  parameter awgn_0_xIm_w           = 32;

  // Outputs
  parameter awgn_0_yRe_w           = 32;
  parameter awgn_0_yIm_w           = 32;

  // Input control lines

  // Output control lines

  // Eregs
  parameter awgn_0_run1_w          = 1;
  parameter awgn_0_run1_r          = 0;
  parameter awgn_0_run1_s          = 0;

  // Parameters
  parameter awgn_0_w               = 32;
  parameter awgn_0_wn              = 14;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam awgn_0.xRe_w           = awgn_0_xRe_w;
  defparam awgn_0.xIm_w           = awgn_0_xIm_w;
  defparam awgn_0.yRe_w           = awgn_0_yRe_w;
  defparam awgn_0.yIm_w           = awgn_0_yIm_w;
  defparam awgn_0.run1_w          = awgn_0_run1_w;
  defparam awgn_0.run1_r          = awgn_0_run1_r;
  defparam awgn_0.run1_s          = awgn_0_run1_s;
  defparam awgn_0.w               = awgn_0_w;
  defparam awgn_0.wn              = awgn_0_wn;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_awgn_0_run1                                                = 0;
  defparam  awgn_0.R_run1                                                = R_awgn_0_run1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [awgn_0_yRe_w-1:0]  awgn_0_yRe;
  wire                                      awgn_0_yRe_or;
  wire                                      awgn_0_yRe_ff;
  wire                                      awgn_0_yRe_we;

  wire                  [awgn_0_yIm_w-1:0]  awgn_0_yIm;
  wire                                      awgn_0_yIm_or;
  wire                                      awgn_0_yIm_ff;
  wire                                      awgn_0_yIm_we;

  wire                  [awgn_0_xRe_w-1:0]  awgn_0_xRe;
  wire                                      awgn_0_xRe_ir;
  wire                                      awgn_0_xRe_fe;
  wire                                      awgn_0_xRe_re;

  wire                  [awgn_0_xIm_w-1:0]  awgn_0_xIm;
  wire                                      awgn_0_xIm_ir;
  wire                                      awgn_0_xIm_fe;
  wire                                      awgn_0_xIm_re;

  wire                                      awgn_0_regWe;
  wire                                      awgn_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  awgn awgn_0(awgn_0_yRe, awgn_0_yRe_or, awgn_0_yRe_ff, awgn_0_yRe_we,
              awgn_0_yIm, awgn_0_yIm_or, awgn_0_yIm_ff, awgn_0_yIm_we,
              awgn_0_xRe, awgn_0_xRe_ir, awgn_0_xRe_fe, awgn_0_xRe_re, 
              awgn_0_xIm, awgn_0_xIm_ir, awgn_0_xIm_fe, awgn_0_xIm_re, 
              regBus, regWe, regRe, awgn_0_regWe, awgn_0_regRe, clk, clk2, reset);


//==============================================================================
