//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines
  parameter X16_rf_irqExt_w        = 1;

  // Output control lines

  // Eregs
  parameter X16_rf_cmd_w           = 16;
  parameter X16_rf_cmd_r           = 0;
  parameter X16_rf_cmd_s           = 0;
  parameter X16_rf_pramAdr_w       = 0;
  parameter X16_rf_pramAdr_r       = 0;
  parameter X16_rf_pramAdr_s       = 0;
  parameter X16_rf_pramDat_w       = 0;
  parameter X16_rf_pramDat_r       = 0;
  parameter X16_rf_pramDat_s       = 0;
  parameter X16_rf_dramAdr_w       = 0;
  parameter X16_rf_dramAdr_r       = 0;
  parameter X16_rf_dramAdr_s       = 0;
  parameter X16_rf_dramDat_w       = 0;
  parameter X16_rf_dramDat_r       = 0;
  parameter X16_rf_dramDat_s       = 0;

  // Parameters
  parameter X16_rf_RegStart        = 0;
  parameter X16_rf_RegLen          = 512;
  parameter X16_rf_RegEnd          = 511;
  parameter X16_rf_DramStart       = 512;
  parameter X16_rf_DramLen         = 512;
  parameter X16_rf_DramEnd         = 1023;
  parameter X16_rf_DramAdrWidth    = 9;
  parameter X16_rf_PramStart       = 0;
  parameter X16_rf_PramLen         = 2048;
  parameter X16_rf_PramLen32       = 512;
  parameter X16_rf_PramEnd         = 2047;
  parameter X16_rf_PramAdrWidth    = 9;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam X16_rf.irqExt_w        = X16_rf_irqExt_w;
  defparam X16_rf.cmd_w           = X16_rf_cmd_w;
  defparam X16_rf.cmd_r           = X16_rf_cmd_r;
  defparam X16_rf.cmd_s           = X16_rf_cmd_s;
  defparam X16_rf.pramAdr_w       = X16_rf_pramAdr_w;
  defparam X16_rf.pramAdr_r       = X16_rf_pramAdr_r;
  defparam X16_rf.pramAdr_s       = X16_rf_pramAdr_s;
  defparam X16_rf.pramDat_w       = X16_rf_pramDat_w;
  defparam X16_rf.pramDat_r       = X16_rf_pramDat_r;
  defparam X16_rf.pramDat_s       = X16_rf_pramDat_s;
  defparam X16_rf.dramAdr_w       = X16_rf_dramAdr_w;
  defparam X16_rf.dramAdr_r       = X16_rf_dramAdr_r;
  defparam X16_rf.dramAdr_s       = X16_rf_dramAdr_s;
  defparam X16_rf.dramDat_w       = X16_rf_dramDat_w;
  defparam X16_rf.dramDat_r       = X16_rf_dramDat_r;
  defparam X16_rf.dramDat_s       = X16_rf_dramDat_s;
  defparam X16_rf.RegStart        = X16_rf_RegStart;
  defparam X16_rf.RegLen          = X16_rf_RegLen;
  defparam X16_rf.RegEnd          = X16_rf_RegEnd;
  defparam X16_rf.DramStart       = X16_rf_DramStart;
  defparam X16_rf.DramLen         = X16_rf_DramLen;
  defparam X16_rf.DramEnd         = X16_rf_DramEnd;
  defparam X16_rf.DramAdrWidth    = X16_rf_DramAdrWidth;
  defparam X16_rf.PramStart       = X16_rf_PramStart;
  defparam X16_rf.PramLen         = X16_rf_PramLen;
  defparam X16_rf.PramLen32       = X16_rf_PramLen32;
  defparam X16_rf.PramEnd         = X16_rf_PramEnd;
  defparam X16_rf.PramAdrWidth    = X16_rf_PramAdrWidth;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_X16_rf_cmd                                                 = 0;
  defparam  X16_rf.R_cmd                                                 = R_X16_rf_cmd;
  parameter R_X16_rf_pramAdr                                             = 1;
  defparam  X16_rf.R_pramAdr                                             = R_X16_rf_pramAdr;
  parameter R_X16_rf_pramDat                                             = 2;
  defparam  X16_rf.R_pramDat                                             = R_X16_rf_pramDat;
  parameter R_X16_rf_dramAdr                                             = 3;
  defparam  X16_rf.R_dramAdr                                             = R_X16_rf_dramAdr;
  parameter R_X16_rf_dramDat                                             = 4;
  defparam  X16_rf.R_dramDat                                             = R_X16_rf_dramDat;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [X16_rf_irqExt_w-1:0]  X16_rf_irqExt;

  wire                                      X16_rf_regWe;
  wire                                      X16_rf_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  X16 X16_rf(X16_rf_irqExt, 
             regBus, regWe, regRe, X16_rf_regWe, X16_rf_regRe, clk, clk2, reset);


//==============================================================================
