//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   gainCtrl
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module gainCtrl(yRe, yRe_or, yRe_ff, yRe_we, 
                yIm, yIm_or, yIm_ff, yIm_we, 
                xRe, xRe_ir, xRe_fe, xRe_re, 
                xIm, xIm_ir, xIm_fe, xIm_re, 
                gainSel, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;

  parameter gainSel_w         = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter gainDelay_w       = 0;
  parameter gainDelay_r       = 0;
  parameter gainDelay_s       = 0;
  parameter R_gainDelay       = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter wg                = 0;
  parameter wf                = 0;
  parameter ws                = 0;

  parameter gainSetting_w     = 0;
  parameter gainSetting_n     = 0;
  parameter gainSetting_m     = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input       [gainSel_w-1:0]  gainSel;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire      [gainDelay_w-1:0]  gainDelay_q;
  wire      [gainDelay_w-1:0]  gainDelay_d;
  wire                         gainDelay_weint;
  assign                       gainDelay_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg gainDelay(gainDelay_q, regBus, gainDelay_d, gainDelay_weint, regWe, regRe, clk, reset);
  defparam gainDelay.w    = gainDelay_w;
  defparam gainDelay.rval = gainDelay_r;
  defparam gainDelay.sgn  = gainDelay_s;
  defparam gainDelay.adr  = R_gainDelay;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg     [gainSetting_w-1:0]  gainSetting;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "lut_gc.v"
  `include "gain_re.v"
  `include "gain_im.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | lut_gc_regWe | gain_re_regWe | gain_im_regWe;
  assign regReOut = 0 | lut_gc_regRe | gain_re_regRe | gain_im_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg           [wy-1:0]  yReR, yImR;
  wire          [wy-1:0]  ySatRe, ySatIm;
  reg                     yOr;
  reg  [gainDelay_w-1:0]  cnt;
  reg           [wg-1:0]  gainSelD;
  
  // --------------------------------------------------------------------------------------
  // Assign input control
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  
  // Assign LUT input
  assign lut_gc_adr = gainSel;

  // Assign gain data  + control inputs
  assign gain_re_x          = xRe;
  assign gain_im_x          = xIm;
  assign gain_re_gainFactor = gainSetting[wf-1:0];
  assign gain_re_gainShift  = gainSetting[ws+wf-1:wf];
  assign gain_im_gainFactor = gainSetting[wf-1:0];
  assign gain_im_gainShift  = gainSetting[ws+wf-1:wf];
  
  // Saturation to 16 bit
  sat satRe(ySatRe, gain_re_y);
  defparam satRe.x_w = wx;
  defparam satRe.y_w = wy;

  sat satIm(ySatIm, gain_im_y);
  defparam satIm.x_w = wx;
  defparam satIm.y_w = wy;
  
  // Assign output
  assign yRe    = yReR;
  assign yIm    = yImR;
  assign yRe_or = yOr;
  assign yIm_or = yOr;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      cnt         <= 0;
      yOr         <= 0;
      gainSelD    <= 0;
      gainSetting <= 0;
      
    // Normal operation
    end else begin
      
      // Gain change FSM
      gainSelD <= gainSel;
      if (gainSel != gainSelD) begin
        cnt <= gainDelay_q;
      end else if (cnt != 0 && xRe_re & xIm_re) begin
        cnt <= cnt - 1;
      end
      if (cnt == 0 || (cnt == 1 && xRe_re & xIm_re)) begin
        gainSetting <= lut_gc_dat;
      end
      
      // Data processing 
      yReR  <= ySatRe;
      yImR  <= ySatIm;
      yOr   <= xRe_re & xIm_re;

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

