//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   gainChan
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module gainChan(yRe, yRe_or, yRe_ff, yRe_we, 
                yIm, yIm_or, yIm_ff, yIm_we, 
                xRe, xRe_ir, xRe_fe, xRe_re, 
                xIm, xIm_ir, xIm_fe, xIm_re, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter gainFactor_w      = 0;
  parameter gainFactor_r      = 0;
  parameter gainFactor_s      = 0;
  parameter R_gainFactor      = 0;
  parameter gainShift_w       = 0;
  parameter gainShift_r       = 0;
  parameter gainShift_s       = 0;
  parameter R_gainShift       = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter wf                = 0;
  parameter ws                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire     [gainFactor_w-1:0]  gainFactor_q;
  wire     [gainFactor_w-1:0]  gainFactor_d;
  wire                         gainFactor_weint;
  assign                       gainFactor_weint = 0;

  wire      [gainShift_w-1:0]  gainShift_q;
  wire      [gainShift_w-1:0]  gainShift_d;
  wire                         gainShift_weint;
  assign                       gainShift_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg gainFactor(gainFactor_q, regBus, gainFactor_d, gainFactor_weint, regWe, regRe, clk, reset);
  defparam gainFactor.w    = gainFactor_w;
  defparam gainFactor.rval = gainFactor_r;
  defparam gainFactor.sgn  = gainFactor_s;
  defparam gainFactor.adr  = R_gainFactor;

  ereg gainShift(gainShift_q, regBus, gainShift_d, gainShift_weint, regWe, regRe, clk, reset);
  defparam gainShift.w    = gainShift_w;
  defparam gainShift.rval = gainShift_r;
  defparam gainShift.sgn  = gainShift_s;
  defparam gainShift.adr  = R_gainShift;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "gain_re.v"
  `include "gain_im.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | gain_re_regWe | gain_im_regWe;
  assign regReOut = 0 | gain_re_regRe | gain_im_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire          [wy-1:0]  x32Re, x32Im;
  reg           [wy-1:0]  yReR, yImR;
  reg                     yOr;
  
  // --------------------------------------------------------------------------------------
  // Assign input control
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  
  // Sign extend input data
  assign x32Re = {{wy-wx{xRe[wx-1]}}, xRe};
  assign x32Im = {{wy-wx{xIm[wx-1]}}, xIm};

  // Assign gain data  + control inputs
  assign gain_re_x          = x32Re;
  assign gain_im_x          = x32Im;
  assign gain_re_gainFactor = gainFactor_q;
  assign gain_re_gainShift  = gainShift_q;
  assign gain_im_gainFactor = gainFactor_q;
  assign gain_im_gainShift  = gainShift_q;
    
  // Assign output
  assign yRe    = yReR;
  assign yIm    = yImR;
  assign yRe_or = yOr;
  assign yIm_or = yOr;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      yOr  <= 0;
      
    // Normal operation
    end else begin
      
      // Data processing 
      yReR  <= gain_re_y;
      yImR  <= gain_im_y;
      yOr   <= xRe_re & xIm_re;

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

