//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   gain
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module gain(y, y_or, y_ff, y_we, 
            x, x_ir, x_fe, x_re, 
            gainShift, 
            gainFactor, 
            regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter gainShift_w       = 0;
  parameter gainFactor_w      = 0;

  parameter w                 = 0;
  parameter wf                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input     [gainShift_w-1:0]  gainShift;
  input    [gainFactor_w-1:0]  gainFactor;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
// Register definitions
wire signed   [w+wf-1:0] x0;
wire signed   [w+wf+9:0] x1;
reg  signed   [w+wf+9:0] x2;

// --------------------------------------------------------------------------------------
// Signal processing behaviour

// Multiply xf = x*gainFac
mulSi mul1(x0, x, {1'b0, gainFactor});
defparam mul1.c_w  = w+wf;
defparam mul1.a_w  = 32;
defparam mul1.b_w  = 9;

// Sign extend, +10 bit
assign x1 = {{10{x0[w+wf-1]}}, x0};

// Shift according to input gainShift
always @(*) begin

  case (gainShift)
         32: x2 =  x1 >>> 40;    // << -32-8
         33: x2 =  x1 >>> 39;    // << -31-8
         34: x2 =  x1 >>> 38;    // << -30-8
         35: x2 =  x1 >>> 37;    // << -29-8
         36: x2 =  x1 >>> 36;    // << -28-8
         37: x2 =  x1 >>> 35;    // << -27-8
         38: x2 =  x1 >>> 34;    // << -26-8
         39: x2 =  x1 >>> 33;    // << -25-8
         40: x2 =  x1 >>> 32;    // << -24-8
         41: x2 =  x1 >>> 31;    // << -23-8
         42: x2 =  x1 >>> 30;    // << -22-8
         43: x2 =  x1 >>> 29;    // << -21-8
         44: x2 =  x1 >>> 28;    // << -20-8
         45: x2 =  x1 >>> 27;    // << -19-8
         46: x2 =  x1 >>> 26;    // << -18-8
         47: x2 =  x1 >>> 25;    // << -17-8
         48: x2 =  x1 >>> 24;    // << -16-8
         49: x2 =  x1 >>> 23;    // << -15-8
         50: x2 =  x1 >>> 22;    // << -14-8
         51: x2 =  x1 >>> 21;    // << -13-8
         52: x2 =  x1 >>> 20;    // << -12-8
         53: x2 =  x1 >>> 19;    // << -11-8
         54: x2 =  x1 >>> 18;    // << -10-8
         55: x2 =  x1 >>> 17;    // <<  -9-8
         56: x2 =  x1 >>> 16;    // <<  -8-8
         57: x2 =  x1 >>> 15;    // <<  -7-8
         58: x2 =  x1 >>> 14;    // <<  -6-8
         59: x2 =  x1 >>> 13;    // <<  -5-8
         60: x2 =  x1 >>> 12;    // <<  -4-8
         61: x2 =  x1 >>> 11;    // <<  -3-8
         62: x2 =  x1 >>> 10;    // <<  -2-8
         63: x2 =  x1 >>>  9;    // <<  -1-8
          0: x2 =  x1 >>>  8;    // <<    -8
          1: x2 =  x1 >>>  7;    // <<  +1-8
          2: x2 =  x1 >>>  6;    // <<  +2-8
          3: x2 =  x1 >>>  5;    // <<  +3-8
          4: x2 =  x1 >>>  4;    // <<  +4-8
          5: x2 =  x1 >>>  3;    // <<  +5-8
          6: x2 =  x1 >>>  2;    // <<  +6-8
          7: x2 =  x1 >>>  1;    // <<  +7-8
          8: x2 =  x1;           // <<  +8-8
          9: x2 =  x1 <<<  1;    // <<  +9-8
         10: x2 =  x1 <<<  2;    // << +10-8
         11: x2 =  x1 <<<  3;    // << +11-8
         12: x2 =  x1 <<<  4;    // << +12-8
         13: x2 =  x1 <<<  5;    // << +13-8
         14: x2 =  x1 <<<  6;    // << +14-8
         15: x2 =  x1 <<<  7;    // << +15-8
         16: x2 =  x1 <<<  8;    // << +16-8
         17: x2 =  x1 <<<  9;    // << +17-8
         18: x2 =  x1 <<< 10;    // << +18-8
    default: x2 =  x1 <<< 10;    // << +18-8
  endcase
end

// Saturation 50 bit -> 32 bit 
  sat sat0(y, x2);
  defparam sat0.x_w = w+wf+10;
  defparam sat0.y_w = w;

  // --------------------------------------------------------------------------------------

endmodule
//=========================================================================================

