//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   freqOff
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module freqOff(yRe, yRe_or, yRe_ff, yRe_we, 
               yIm, yIm_or, yIm_ff, yIm_we, 
               xRe, xRe_ir, xRe_fe, xRe_re, 
               xIm, xIm_ir, xIm_fe, xIm_re, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter freqOffLo16_w     = 0;
  parameter freqOffLo16_r     = 0;
  parameter freqOffLo16_s     = 0;
  parameter R_freqOffLo16     = 0;
  parameter freqOffMi16_w     = 0;
  parameter freqOffMi16_r     = 0;
  parameter freqOffMi16_s     = 0;
  parameter R_freqOffMi16     = 0;
  parameter freqOffHi16_w     = 0;
  parameter freqOffHi16_r     = 0;
  parameter freqOffHi16_s     = 0;
  parameter R_freqOffHi16     = 0;

  parameter w                 = 0;
  parameter wp                = 0;

  parameter phAcc_w           = 0;
  parameter phAcc_n           = 0;
  parameter phAcc_m           = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire    [freqOffLo16_w-1:0]  freqOffLo16_q;
  wire    [freqOffLo16_w-1:0]  freqOffLo16_d;
  wire                         freqOffLo16_weint;
  assign                       freqOffLo16_weint = 0;

  wire    [freqOffMi16_w-1:0]  freqOffMi16_q;
  wire    [freqOffMi16_w-1:0]  freqOffMi16_d;
  wire                         freqOffMi16_weint;
  assign                       freqOffMi16_weint = 0;

  wire    [freqOffHi16_w-1:0]  freqOffHi16_q;
  wire    [freqOffHi16_w-1:0]  freqOffHi16_d;
  wire                         freqOffHi16_weint;
  assign                       freqOffHi16_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg freqOffLo16(freqOffLo16_q, regBus, freqOffLo16_d, freqOffLo16_weint, regWe, regRe, clk, reset);
  defparam freqOffLo16.w    = freqOffLo16_w;
  defparam freqOffLo16.rval = freqOffLo16_r;
  defparam freqOffLo16.sgn  = freqOffLo16_s;
  defparam freqOffLo16.adr  = R_freqOffLo16;

  ereg freqOffMi16(freqOffMi16_q, regBus, freqOffMi16_d, freqOffMi16_weint, regWe, regRe, clk, reset);
  defparam freqOffMi16.w    = freqOffMi16_w;
  defparam freqOffMi16.rval = freqOffMi16_r;
  defparam freqOffMi16.sgn  = freqOffMi16_s;
  defparam freqOffMi16.adr  = R_freqOffMi16;

  ereg freqOffHi16(freqOffHi16_q, regBus, freqOffHi16_d, freqOffHi16_weint, regWe, regRe, clk, reset);
  defparam freqOffHi16.w    = freqOffHi16_w;
  defparam freqOffHi16.rval = freqOffHi16_r;
  defparam freqOffHi16.sgn  = freqOffHi16_s;
  defparam freqOffHi16.adr  = R_freqOffHi16;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg           [phAcc_w-1:0]  phAcc;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "crdcPhRot_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign crdcPhRot_0_xRe           = xRe;
  assign crdcPhRot_0_xRe_fe        = xRe_fe;
  assign xRe_ir                    = crdcPhRot_0_xRe_ir;

  assign crdcPhRot_0_xIm           = xIm;
  assign crdcPhRot_0_xIm_fe        = xIm_fe;
  assign xIm_ir                    = crdcPhRot_0_xIm_ir;

  assign yRe                       = crdcPhRot_0_yRe;
  assign yRe_or                    = crdcPhRot_0_yRe_or;
  assign crdcPhRot_0_yRe_ff        = yRe_ff;

  assign yIm                       = crdcPhRot_0_yIm;
  assign yIm_or                    = crdcPhRot_0_yIm_or;
  assign crdcPhRot_0_yIm_ff        = yIm_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | crdcPhRot_0_regWe;
  assign regReOut = 0 | crdcPhRot_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire            x_re;
  wire     [47:0] freqOff48;
  
  // --------------------------------------------------------------------------------------
  // Assign input control
//  assign xRe_ir = run1_q;   // Driven internally by crdcPhRot
//  assign xIm_ir = run1_q;   // via autoconnect definition
  assign x_re   = xRe_re && xIm_re;
  
  // Phase accumulator
  assign freqOff48 = {freqOffHi16_q, freqOffMi16_q, freqOffLo16_q};
  always @(posedge clk) begin
    if (run1_q==0) begin
      phAcc <= 0;
    end else begin
      if (x_re) begin
        phAcc <= phAcc - freqOff48;
      end
    end
  end
  
  // Connect control of crdcPhRot
  assign crdcPhRot_0_run1   = run1_q;
  assign crdcPhRot_0_ph     = phAcc[47:47-wp+1];
  assign crdcPhRot_0_ph_fe  = ~x_re;

endmodule
//=========================================================================================

