//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   firToff
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module firToff(yRe, yRe_or, yRe_ff, yRe_we, 
               yIm, yIm_or, yIm_ff, yIm_we, 
               xRe, xRe_ir, xRe_fe, xRe_re, 
               xIm, xIm_ir, xIm_fe, xIm_re, 
               ioCtrl, ioCtrl_ir, ioCtrl_fe, ioCtrl_re, 
               cf00, cf00_ir, cf00_fe, cf00_re, 
               cf01, cf01_ir, cf01_fe, cf01_re, 
               cf02, cf02_ir, cf02_fe, cf02_re, 
               cf03, cf03_ir, cf03_fe, cf03_re, 
               cf04, cf04_ir, cf04_fe, cf04_re, 
               cf05, cf05_ir, cf05_fe, cf05_re, 
               cf06, cf06_ir, cf06_fe, cf06_re, 
               cf07, cf07_ir, cf07_fe, cf07_re, 
               cf08, cf08_ir, cf08_fe, cf08_re, 
               cf09, cf09_ir, cf09_fe, cf09_re, 
               cf10, cf10_ir, cf10_fe, cf10_re, 
               cf11, cf11_ir, cf11_fe, cf11_re, 
               cf12, cf12_ir, cf12_fe, cf12_re, 
               cf13, cf13_ir, cf13_fe, cf13_re, 
               cf14, cf14_ir, cf14_fe, cf14_re, 
               cf15, cf15_ir, cf15_fe, cf15_re, 
               cf16, cf16_ir, cf16_fe, cf16_re, 
               cf17, cf17_ir, cf17_fe, cf17_re, 
               cf18, cf18_ir, cf18_fe, cf18_re, 
               cf19, cf19_ir, cf19_fe, cf19_re, 
               cf20, cf20_ir, cf20_fe, cf20_re, 
               cf21, cf21_ir, cf21_fe, cf21_re, 
               cf22, cf22_ir, cf22_fe, cf22_re, 
               cf23, cf23_ir, cf23_fe, cf23_re, 
               cf24, cf24_ir, cf24_fe, cf24_re, 
               cf25, cf25_ir, cf25_fe, cf25_re, 
               cf26, cf26_ir, cf26_fe, cf26_re, 
               cf27, cf27_ir, cf27_fe, cf27_re, 
               cf28, cf28_ir, cf28_fe, cf28_re, 
               cf29, cf29_ir, cf29_fe, cf29_re, 
               cf30, cf30_ir, cf30_fe, cf30_re, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;
  parameter ioCtrl_w          = 0;
  parameter cf00_w            = 0;
  parameter cf01_w            = 0;
  parameter cf02_w            = 0;
  parameter cf03_w            = 0;
  parameter cf04_w            = 0;
  parameter cf05_w            = 0;
  parameter cf06_w            = 0;
  parameter cf07_w            = 0;
  parameter cf08_w            = 0;
  parameter cf09_w            = 0;
  parameter cf10_w            = 0;
  parameter cf11_w            = 0;
  parameter cf12_w            = 0;
  parameter cf13_w            = 0;
  parameter cf14_w            = 0;
  parameter cf15_w            = 0;
  parameter cf16_w            = 0;
  parameter cf17_w            = 0;
  parameter cf18_w            = 0;
  parameter cf19_w            = 0;
  parameter cf20_w            = 0;
  parameter cf21_w            = 0;
  parameter cf22_w            = 0;
  parameter cf23_w            = 0;
  parameter cf24_w            = 0;
  parameter cf25_w            = 0;
  parameter cf26_w            = 0;
  parameter cf27_w            = 0;
  parameter cf28_w            = 0;
  parameter cf29_w            = 0;
  parameter cf30_w            = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;
  parameter wc                = 0;

  parameter cnt_w             = 0;
  parameter cnt_n             = 0;
  parameter cnt_m             = 0;
  parameter xDRe_w            = 0;
  parameter xDRe_n            = 0;
  parameter xDRe_m            = 0;
  parameter xDIm_w            = 0;
  parameter xDIm_n            = 0;
  parameter xDIm_m            = 0;
  parameter cfR_w             = 0;
  parameter cfR_n             = 0;
  parameter cfR_m             = 0;
  parameter mRe_w             = 0;
  parameter mRe_n             = 0;
  parameter mRe_m             = 0;
  parameter mIm_w             = 0;
  parameter mIm_n             = 0;
  parameter mIm_m             = 0;
  parameter a1Re_w            = 0;
  parameter a1Re_n            = 0;
  parameter a1Re_m            = 0;
  parameter a1Im_w            = 0;
  parameter a1Im_n            = 0;
  parameter a1Im_m            = 0;
  parameter a2Re_w            = 0;
  parameter a2Re_n            = 0;
  parameter a2Re_m            = 0;
  parameter a2Im_w            = 0;
  parameter a2Im_n            = 0;
  parameter a2Im_m            = 0;
  parameter yReR_w            = 0;
  parameter yReR_n            = 0;
  parameter yReR_m            = 0;
  parameter yImR_w            = 0;
  parameter yImR_n            = 0;
  parameter yImR_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input        [ioCtrl_w-1:0]  ioCtrl;
  output                       ioCtrl_ir;
  input                        ioCtrl_fe;
  output                       ioCtrl_re;
  assign                       ioCtrl_re = ioCtrl_ir & ~ioCtrl_fe;

  input          [cf00_w-1:0]  cf00;
  output                       cf00_ir;
  input                        cf00_fe;
  output                       cf00_re;
  assign                       cf00_re = cf00_ir & ~cf00_fe;

  input          [cf01_w-1:0]  cf01;
  output                       cf01_ir;
  input                        cf01_fe;
  output                       cf01_re;
  assign                       cf01_re = cf01_ir & ~cf01_fe;

  input          [cf02_w-1:0]  cf02;
  output                       cf02_ir;
  input                        cf02_fe;
  output                       cf02_re;
  assign                       cf02_re = cf02_ir & ~cf02_fe;

  input          [cf03_w-1:0]  cf03;
  output                       cf03_ir;
  input                        cf03_fe;
  output                       cf03_re;
  assign                       cf03_re = cf03_ir & ~cf03_fe;

  input          [cf04_w-1:0]  cf04;
  output                       cf04_ir;
  input                        cf04_fe;
  output                       cf04_re;
  assign                       cf04_re = cf04_ir & ~cf04_fe;

  input          [cf05_w-1:0]  cf05;
  output                       cf05_ir;
  input                        cf05_fe;
  output                       cf05_re;
  assign                       cf05_re = cf05_ir & ~cf05_fe;

  input          [cf06_w-1:0]  cf06;
  output                       cf06_ir;
  input                        cf06_fe;
  output                       cf06_re;
  assign                       cf06_re = cf06_ir & ~cf06_fe;

  input          [cf07_w-1:0]  cf07;
  output                       cf07_ir;
  input                        cf07_fe;
  output                       cf07_re;
  assign                       cf07_re = cf07_ir & ~cf07_fe;

  input          [cf08_w-1:0]  cf08;
  output                       cf08_ir;
  input                        cf08_fe;
  output                       cf08_re;
  assign                       cf08_re = cf08_ir & ~cf08_fe;

  input          [cf09_w-1:0]  cf09;
  output                       cf09_ir;
  input                        cf09_fe;
  output                       cf09_re;
  assign                       cf09_re = cf09_ir & ~cf09_fe;

  input          [cf10_w-1:0]  cf10;
  output                       cf10_ir;
  input                        cf10_fe;
  output                       cf10_re;
  assign                       cf10_re = cf10_ir & ~cf10_fe;

  input          [cf11_w-1:0]  cf11;
  output                       cf11_ir;
  input                        cf11_fe;
  output                       cf11_re;
  assign                       cf11_re = cf11_ir & ~cf11_fe;

  input          [cf12_w-1:0]  cf12;
  output                       cf12_ir;
  input                        cf12_fe;
  output                       cf12_re;
  assign                       cf12_re = cf12_ir & ~cf12_fe;

  input          [cf13_w-1:0]  cf13;
  output                       cf13_ir;
  input                        cf13_fe;
  output                       cf13_re;
  assign                       cf13_re = cf13_ir & ~cf13_fe;

  input          [cf14_w-1:0]  cf14;
  output                       cf14_ir;
  input                        cf14_fe;
  output                       cf14_re;
  assign                       cf14_re = cf14_ir & ~cf14_fe;

  input          [cf15_w-1:0]  cf15;
  output                       cf15_ir;
  input                        cf15_fe;
  output                       cf15_re;
  assign                       cf15_re = cf15_ir & ~cf15_fe;

  input          [cf16_w-1:0]  cf16;
  output                       cf16_ir;
  input                        cf16_fe;
  output                       cf16_re;
  assign                       cf16_re = cf16_ir & ~cf16_fe;

  input          [cf17_w-1:0]  cf17;
  output                       cf17_ir;
  input                        cf17_fe;
  output                       cf17_re;
  assign                       cf17_re = cf17_ir & ~cf17_fe;

  input          [cf18_w-1:0]  cf18;
  output                       cf18_ir;
  input                        cf18_fe;
  output                       cf18_re;
  assign                       cf18_re = cf18_ir & ~cf18_fe;

  input          [cf19_w-1:0]  cf19;
  output                       cf19_ir;
  input                        cf19_fe;
  output                       cf19_re;
  assign                       cf19_re = cf19_ir & ~cf19_fe;

  input          [cf20_w-1:0]  cf20;
  output                       cf20_ir;
  input                        cf20_fe;
  output                       cf20_re;
  assign                       cf20_re = cf20_ir & ~cf20_fe;

  input          [cf21_w-1:0]  cf21;
  output                       cf21_ir;
  input                        cf21_fe;
  output                       cf21_re;
  assign                       cf21_re = cf21_ir & ~cf21_fe;

  input          [cf22_w-1:0]  cf22;
  output                       cf22_ir;
  input                        cf22_fe;
  output                       cf22_re;
  assign                       cf22_re = cf22_ir & ~cf22_fe;

  input          [cf23_w-1:0]  cf23;
  output                       cf23_ir;
  input                        cf23_fe;
  output                       cf23_re;
  assign                       cf23_re = cf23_ir & ~cf23_fe;

  input          [cf24_w-1:0]  cf24;
  output                       cf24_ir;
  input                        cf24_fe;
  output                       cf24_re;
  assign                       cf24_re = cf24_ir & ~cf24_fe;

  input          [cf25_w-1:0]  cf25;
  output                       cf25_ir;
  input                        cf25_fe;
  output                       cf25_re;
  assign                       cf25_re = cf25_ir & ~cf25_fe;

  input          [cf26_w-1:0]  cf26;
  output                       cf26_ir;
  input                        cf26_fe;
  output                       cf26_re;
  assign                       cf26_re = cf26_ir & ~cf26_fe;

  input          [cf27_w-1:0]  cf27;
  output                       cf27_ir;
  input                        cf27_fe;
  output                       cf27_re;
  assign                       cf27_re = cf27_ir & ~cf27_fe;

  input          [cf28_w-1:0]  cf28;
  output                       cf28_ir;
  input                        cf28_fe;
  output                       cf28_re;
  assign                       cf28_re = cf28_ir & ~cf28_fe;

  input          [cf29_w-1:0]  cf29;
  output                       cf29_ir;
  input                        cf29_fe;
  output                       cf29_re;
  assign                       cf29_re = cf29_ir & ~cf29_fe;

  input          [cf30_w-1:0]  cf30;
  output                       cf30_ir;
  input                        cf30_fe;
  output                       cf30_re;
  assign                       cf30_re = cf30_ir & ~cf30_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg             [cnt_w-1:0]  cnt;
  reg            [xDRe_w-1:0]  xDRe[xDRe_n-1:0];
  reg            [xDIm_w-1:0]  xDIm[xDIm_n-1:0];
  reg             [cfR_w-1:0]  cfR[cfR_n-1:0];
  reg             [mRe_w-1:0]  mRe[mRe_n-1:0];
  reg             [mIm_w-1:0]  mIm[mIm_n-1:0];
  reg            [a1Re_w-1:0]  a1Re[a1Re_n-1:0];
  reg            [a1Im_w-1:0]  a1Im[a1Im_n-1:0];
  reg            [a2Re_w-1:0]  a2Re[a2Re_n-1:0];
  reg            [a2Im_w-1:0]  a2Im[a2Im_n-1:0];
  reg            [yReR_w-1:0]  yReR;
  reg            [yImR_w-1:0]  yImR;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // -------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  assign yRe_or = ~xRe_fe;
  assign yIm_or = ~xIm_fe;
  assign yRe    = xRe;
  assign yIm    = xIm;

endmodule
//=========================================================================================

