//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   firMuxAdd
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module firMuxAdd(yRe, yRe_or, yRe_ff, yRe_we, 
                 yIm, yIm_or, yIm_ff, yIm_we, 
                 xRe, xRe_ir, xRe_fe, xRe_re, 
                 xIm, xIm_ir, xIm_fe, xIm_re, 
                 xM00Re, xM00Re_ir, xM00Re_fe, xM00Re_re, 
                 xM00Im, xM00Im_ir, xM00Im_fe, xM00Im_re, 
                 xM01Re, xM01Re_ir, xM01Re_fe, xM01Re_re, 
                 xM01Im, xM01Im_ir, xM01Im_fe, xM01Im_re, 
                 xM02Re, xM02Re_ir, xM02Re_fe, xM02Re_re, 
                 xM02Im, xM02Im_ir, xM02Im_fe, xM02Im_re, 
                 xM03Re, xM03Re_ir, xM03Re_fe, xM03Re_re, 
                 xM03Im, xM03Im_ir, xM03Im_fe, xM03Im_re, 
                 xM04Re, xM04Re_ir, xM04Re_fe, xM04Re_re, 
                 xM04Im, xM04Im_ir, xM04Im_fe, xM04Im_re, 
                 xM05Re, xM05Re_ir, xM05Re_fe, xM05Re_re, 
                 xM05Im, xM05Im_ir, xM05Im_fe, xM05Im_re, 
                 xM06Re, xM06Re_ir, xM06Re_fe, xM06Re_re, 
                 xM06Im, xM06Im_ir, xM06Im_fe, xM06Im_re, 
                 xM07Re, xM07Re_ir, xM07Re_fe, xM07Re_re, 
                 xM07Im, xM07Im_ir, xM07Im_fe, xM07Im_re, 
                 xM08Re, xM08Re_ir, xM08Re_fe, xM08Re_re, 
                 xM08Im, xM08Im_ir, xM08Im_fe, xM08Im_re, 
                 xM09Re, xM09Re_ir, xM09Re_fe, xM09Re_re, 
                 xM09Im, xM09Im_ir, xM09Im_fe, xM09Im_re, 
                 run1, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;
  parameter xM00Re_w          = 0;
  parameter xM00Im_w          = 0;
  parameter xM01Re_w          = 0;
  parameter xM01Im_w          = 0;
  parameter xM02Re_w          = 0;
  parameter xM02Im_w          = 0;
  parameter xM03Re_w          = 0;
  parameter xM03Im_w          = 0;
  parameter xM04Re_w          = 0;
  parameter xM04Im_w          = 0;
  parameter xM05Re_w          = 0;
  parameter xM05Im_w          = 0;
  parameter xM06Re_w          = 0;
  parameter xM06Im_w          = 0;
  parameter xM07Re_w          = 0;
  parameter xM07Im_w          = 0;
  parameter xM08Re_w          = 0;
  parameter xM08Im_w          = 0;
  parameter xM09Re_w          = 0;
  parameter xM09Im_w          = 0;

  parameter run1_w            = 0;

  parameter inpSel_w          = 0;
  parameter inpSel_r          = 0;
  parameter inpSel_s          = 0;
  parameter R_inpSel          = 0;

  parameter w                 = 0;
  parameter nc                = 0;
  parameter wc                = 0;

  parameter yReR_w            = 0;
  parameter yReR_n            = 0;
  parameter yReR_m            = 0;
  parameter yImR_w            = 0;
  parameter yImR_n            = 0;
  parameter yImR_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input        [xM00Re_w-1:0]  xM00Re;
  output                       xM00Re_ir;
  input                        xM00Re_fe;
  output                       xM00Re_re;
  assign                       xM00Re_re = xM00Re_ir & ~xM00Re_fe;

  input        [xM00Im_w-1:0]  xM00Im;
  output                       xM00Im_ir;
  input                        xM00Im_fe;
  output                       xM00Im_re;
  assign                       xM00Im_re = xM00Im_ir & ~xM00Im_fe;

  input        [xM01Re_w-1:0]  xM01Re;
  output                       xM01Re_ir;
  input                        xM01Re_fe;
  output                       xM01Re_re;
  assign                       xM01Re_re = xM01Re_ir & ~xM01Re_fe;

  input        [xM01Im_w-1:0]  xM01Im;
  output                       xM01Im_ir;
  input                        xM01Im_fe;
  output                       xM01Im_re;
  assign                       xM01Im_re = xM01Im_ir & ~xM01Im_fe;

  input        [xM02Re_w-1:0]  xM02Re;
  output                       xM02Re_ir;
  input                        xM02Re_fe;
  output                       xM02Re_re;
  assign                       xM02Re_re = xM02Re_ir & ~xM02Re_fe;

  input        [xM02Im_w-1:0]  xM02Im;
  output                       xM02Im_ir;
  input                        xM02Im_fe;
  output                       xM02Im_re;
  assign                       xM02Im_re = xM02Im_ir & ~xM02Im_fe;

  input        [xM03Re_w-1:0]  xM03Re;
  output                       xM03Re_ir;
  input                        xM03Re_fe;
  output                       xM03Re_re;
  assign                       xM03Re_re = xM03Re_ir & ~xM03Re_fe;

  input        [xM03Im_w-1:0]  xM03Im;
  output                       xM03Im_ir;
  input                        xM03Im_fe;
  output                       xM03Im_re;
  assign                       xM03Im_re = xM03Im_ir & ~xM03Im_fe;

  input        [xM04Re_w-1:0]  xM04Re;
  output                       xM04Re_ir;
  input                        xM04Re_fe;
  output                       xM04Re_re;
  assign                       xM04Re_re = xM04Re_ir & ~xM04Re_fe;

  input        [xM04Im_w-1:0]  xM04Im;
  output                       xM04Im_ir;
  input                        xM04Im_fe;
  output                       xM04Im_re;
  assign                       xM04Im_re = xM04Im_ir & ~xM04Im_fe;

  input        [xM05Re_w-1:0]  xM05Re;
  output                       xM05Re_ir;
  input                        xM05Re_fe;
  output                       xM05Re_re;
  assign                       xM05Re_re = xM05Re_ir & ~xM05Re_fe;

  input        [xM05Im_w-1:0]  xM05Im;
  output                       xM05Im_ir;
  input                        xM05Im_fe;
  output                       xM05Im_re;
  assign                       xM05Im_re = xM05Im_ir & ~xM05Im_fe;

  input        [xM06Re_w-1:0]  xM06Re;
  output                       xM06Re_ir;
  input                        xM06Re_fe;
  output                       xM06Re_re;
  assign                       xM06Re_re = xM06Re_ir & ~xM06Re_fe;

  input        [xM06Im_w-1:0]  xM06Im;
  output                       xM06Im_ir;
  input                        xM06Im_fe;
  output                       xM06Im_re;
  assign                       xM06Im_re = xM06Im_ir & ~xM06Im_fe;

  input        [xM07Re_w-1:0]  xM07Re;
  output                       xM07Re_ir;
  input                        xM07Re_fe;
  output                       xM07Re_re;
  assign                       xM07Re_re = xM07Re_ir & ~xM07Re_fe;

  input        [xM07Im_w-1:0]  xM07Im;
  output                       xM07Im_ir;
  input                        xM07Im_fe;
  output                       xM07Im_re;
  assign                       xM07Im_re = xM07Im_ir & ~xM07Im_fe;

  input        [xM08Re_w-1:0]  xM08Re;
  output                       xM08Re_ir;
  input                        xM08Re_fe;
  output                       xM08Re_re;
  assign                       xM08Re_re = xM08Re_ir & ~xM08Re_fe;

  input        [xM08Im_w-1:0]  xM08Im;
  output                       xM08Im_ir;
  input                        xM08Im_fe;
  output                       xM08Im_re;
  assign                       xM08Im_re = xM08Im_ir & ~xM08Im_fe;

  input        [xM09Re_w-1:0]  xM09Re;
  output                       xM09Re_ir;
  input                        xM09Re_fe;
  output                       xM09Re_re;
  assign                       xM09Re_re = xM09Re_ir & ~xM09Re_fe;

  input        [xM09Im_w-1:0]  xM09Im;
  output                       xM09Im_ir;
  input                        xM09Im_fe;
  output                       xM09Im_re;
  assign                       xM09Im_re = xM09Im_ir & ~xM09Im_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire         [inpSel_w-1:0]  inpSel_q;
  wire         [inpSel_w-1:0]  inpSel_d;
  wire                         inpSel_weint;
  assign                       inpSel_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg inpSel(inpSel_q, regBus, inpSel_d, inpSel_weint, regWe, regRe, clk, reset);
  defparam inpSel.w    = inpSel_w;
  defparam inpSel.rval = inpSel_r;
  defparam inpSel.sgn  = inpSel_s;
  defparam inpSel.adr  = R_inpSel;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg            [yReR_w-1:0]  yReR;
  reg            [yImR_w-1:0]  yImR;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1;
  assign xIm_ir = run1;
  assign yRe_or = 0;
  assign yIm_or = 0;
  assign yRe    = 0;
  assign yIm    = 0;
 
endmodule
//=========================================================================================

