//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   firCxMul
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module firCxMul(yRe, yRe_or, yRe_ff, yRe_we, 
                yIm, yIm_or, yIm_ff, yIm_we, 
                xRe, xRe_ir, xRe_fe, xRe_re, 
                xIm, xIm_ir, xIm_fe, xIm_re, 
                xRePlIm, xRePlIm_ir, xRePlIm_fe, xRePlIm_re, 
                run1, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;
  parameter xRePlIm_w         = 0;

  parameter run1_w            = 0;

  parameter cRe_w             = 0;
  parameter cRe_r             = 0;
  parameter cRe_s             = 0;
  parameter R_cRe             = 0;
  parameter cRePlIm_w         = 0;
  parameter cRePlIm_r         = 0;
  parameter cRePlIm_s         = 0;
  parameter R_cRePlIm         = 0;
  parameter cReMiIm_w         = 0;
  parameter cReMiIm_r         = 0;
  parameter cReMiIm_s         = 0;
  parameter R_cReMiIm         = 0;

  parameter w                 = 0;
  parameter qc                = 0;

  parameter mA_w              = 0;
  parameter mA_n              = 0;
  parameter mA_m              = 0;
  parameter mB_w              = 0;
  parameter mB_n              = 0;
  parameter mB_m              = 0;
  parameter mC_w              = 0;
  parameter mC_n              = 0;
  parameter mC_m              = 0;
  parameter yReR_w            = 0;
  parameter yReR_n            = 0;
  parameter yReR_m            = 0;
  parameter yImR_w            = 0;
  parameter yImR_n            = 0;
  parameter yImR_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input       [xRePlIm_w-1:0]  xRePlIm;
  output                       xRePlIm_ir;
  input                        xRePlIm_fe;
  output                       xRePlIm_re;
  assign                       xRePlIm_re = xRePlIm_ir & ~xRePlIm_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire            [cRe_w-1:0]  cRe_q;
  wire            [cRe_w-1:0]  cRe_d;
  wire                         cRe_weint;
  assign                       cRe_weint = 0;

  wire        [cRePlIm_w-1:0]  cRePlIm_q;
  wire        [cRePlIm_w-1:0]  cRePlIm_d;
  wire                         cRePlIm_weint;
  assign                       cRePlIm_weint = 0;

  wire        [cReMiIm_w-1:0]  cReMiIm_q;
  wire        [cReMiIm_w-1:0]  cReMiIm_d;
  wire                         cReMiIm_weint;
  assign                       cReMiIm_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg cRe(cRe_q, regBus, cRe_d, cRe_weint, regWe, regRe, clk, reset);
  defparam cRe.w    = cRe_w;
  defparam cRe.rval = cRe_r;
  defparam cRe.sgn  = cRe_s;
  defparam cRe.adr  = R_cRe;

  ereg cRePlIm(cRePlIm_q, regBus, cRePlIm_d, cRePlIm_weint, regWe, regRe, clk, reset);
  defparam cRePlIm.w    = cRePlIm_w;
  defparam cRePlIm.rval = cRePlIm_r;
  defparam cRePlIm.sgn  = cRePlIm_s;
  defparam cRePlIm.adr  = R_cRePlIm;

  ereg cReMiIm(cReMiIm_q, regBus, cReMiIm_d, cReMiIm_weint, regWe, regRe, clk, reset);
  defparam cReMiIm.w    = cReMiIm_w;
  defparam cReMiIm.rval = cReMiIm_r;
  defparam cReMiIm.sgn  = cReMiIm_s;
  defparam cReMiIm.adr  = R_cReMiIm;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [mA_w-1:0]  mA;
  reg              [mB_w-1:0]  mB;
  reg              [mC_w-1:0]  mC;
  reg            [yReR_w-1:0]  yReR;
  reg            [yImR_w-1:0]  yImR;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir     = run1;
  assign xIm_ir     = run1;
  assign xRePlIm_ir = run1;
  assign yRe        = 0;
  assign yIm        = 0;
  assign yRe_or     = 0;
  assign yIm_or     = 0;
  
endmodule
//=========================================================================================

