//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   dcOff
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dcOff(yRe, yRe_or, yRe_ff, yRe_we, 
             yIm, yIm_or, yIm_ff, yIm_we, 
             xRe, xRe_ir, xRe_fe, xRe_re, 
             xIm, xIm_ir, xIm_fe, xIm_re, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter dcRe_w            = 0;
  parameter dcRe_r            = 0;
  parameter dcRe_s            = 0;
  parameter R_dcRe            = 0;
  parameter dcIm_w            = 0;
  parameter dcIm_r            = 0;
  parameter dcIm_s            = 0;
  parameter R_dcIm            = 0;

  parameter w                 = 0;

  parameter yReR_w            = 0;
  parameter yReR_n            = 0;
  parameter yReR_m            = 0;
  parameter yImR_w            = 0;
  parameter yImR_n            = 0;
  parameter yImR_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire           [dcRe_w-1:0]  dcRe_q;
  wire           [dcRe_w-1:0]  dcRe_d;
  wire                         dcRe_weint;
  assign                       dcRe_weint = 0;

  wire           [dcIm_w-1:0]  dcIm_q;
  wire           [dcIm_w-1:0]  dcIm_d;
  wire                         dcIm_weint;
  assign                       dcIm_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg dcRe(dcRe_q, regBus, dcRe_d, dcRe_weint, regWe, regRe, clk, reset);
  defparam dcRe.w    = dcRe_w;
  defparam dcRe.rval = dcRe_r;
  defparam dcRe.sgn  = dcRe_s;
  defparam dcRe.adr  = R_dcRe;

  ereg dcIm(dcIm_q, regBus, dcIm_d, dcIm_weint, regWe, regRe, clk, reset);
  defparam dcIm.w    = dcIm_w;
  defparam dcIm.rval = dcIm_r;
  defparam dcIm.sgn  = dcIm_s;
  defparam dcIm.adr  = R_dcIm;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg            [yReR_w-1:0]  yReR;
  reg            [yImR_w-1:0]  yImR;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  assign yRe_or = xRe_re;
  assign yIm_or = xIm_re;
  assign yRe    = xRe;
  assign yIm    = xIm;
  
endmodule
//=========================================================================================

