//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   datSnk
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module datSnk(y, y_or, y_ff, y_we, 
              x, x_ir, x_fe, x_re, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter cntRnd_w          = 0;
  parameter cntRnd_r          = 0;
  parameter cntRnd_s          = 0;
  parameter R_cntRnd          = 0;
  parameter endZero_w         = 0;
  parameter endZero_r         = 0;
  parameter endZero_s         = 0;
  parameter R_endZero         = 0;
  parameter dat_w             = 0;
  parameter dat_r             = 0;
  parameter dat_s             = 0;
  parameter R_dat             = 0;
  parameter numDat_w          = 0;
  parameter numDat_r          = 0;
  parameter numDat_s          = 0;
  parameter R_numDat          = 0;
  parameter err_w             = 0;
  parameter err_r             = 0;
  parameter err_s             = 0;
  parameter R_err             = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire         [cntRnd_w-1:0]  cntRnd_q;
  wire         [cntRnd_w-1:0]  cntRnd_d;
  wire                         cntRnd_weint;
  assign                       cntRnd_weint = 0;

  wire        [endZero_w-1:0]  endZero_q;
  wire        [endZero_w-1:0]  endZero_d;
  wire                         endZero_weint;
  assign                       endZero_weint = 0;

  wire            [dat_w-1:0]  dat_q;
  wire            [dat_w-1:0]  dat_d;
  wire                         dat_weint;

  wire         [numDat_w-1:0]  numDat_q;
  wire         [numDat_w-1:0]  numDat_d;
  wire                         numDat_weint;

  wire            [err_w-1:0]  err_q;
  wire            [err_w-1:0]  err_d;
  wire                         err_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg cntRnd(cntRnd_q, regBus, cntRnd_d, cntRnd_weint, regWe, regRe, clk, reset);
  defparam cntRnd.w    = cntRnd_w;
  defparam cntRnd.rval = cntRnd_r;
  defparam cntRnd.sgn  = cntRnd_s;
  defparam cntRnd.adr  = R_cntRnd;

  ereg endZero(endZero_q, regBus, endZero_d, endZero_weint, regWe, regRe, clk, reset);
  defparam endZero.w    = endZero_w;
  defparam endZero.rval = endZero_r;
  defparam endZero.sgn  = endZero_s;
  defparam endZero.adr  = R_endZero;

  ereg dat(dat_q, regBus, dat_d, dat_weint, regWe, regRe, clk, reset);
  defparam dat.w    = dat_w;
  defparam dat.rval = dat_r;
  defparam dat.sgn  = dat_s;
  defparam dat.adr  = R_dat;

  ereg numDat(numDat_q, regBus, numDat_d, numDat_weint, regWe, regRe, clk, reset);
  defparam numDat.w    = numDat_w;
  defparam numDat.rval = numDat_r;
  defparam numDat.sgn  = numDat_s;
  defparam numDat.adr  = R_numDat;

  ereg err(err_q, regBus, err_d, err_weint, regWe, regRe, clk, reset);
  defparam err.w    = err_w;
  defparam err.rval = err_r;
  defparam err.sgn  = err_s;
  defparam err.adr  = R_err;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================


//-----------------------------------------------------------------------------------------
  
  // Assign input enables
  assign x_ir           = numDat_q!=0 & run1_q;
  
  // Assign feedback to eregs
  assign dat_weint      = x_re;
  assign dat_d          = (numDat_q <= 5 && endZero_q == 1) ? 0                 : 
                          (cntRnd_q == 0)                   ? dat_q + 1         : 
                          (dat_q[0]                         ? (dat_q>>1)^51115  : 
                          dat_q>>1);
  
  assign numDat_weint   = x_re;
  assign numDat_d       = numDat_q - 1;

  // Catch error
  assign err_weint      = x_re;
  assign err_d          = |(x^dat_q[y_w-1:0]) | err_q;

  // Assign output - debug only
  assign y              = x^dat_q[y_w-1:0];
  assign y_or           = x_re;

endmodule
//=========================================================================================

