//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   dacSim
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dacSim(yRe, yRe_or, yRe_ff, yRe_we, 
              yIm, yIm_or, yIm_ff, yIm_we, 
              xRe, xRe_ir, xRe_fe, xRe_re, 
              xIm, xIm_ir, xIm_fe, xIm_re, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter pLo16_w           = 0;
  parameter pLo16_r           = 0;
  parameter pLo16_s           = 0;
  parameter R_pLo16           = 0;
  parameter pHi16_w           = 0;
  parameter pHi16_r           = 0;
  parameter pHi16_s           = 0;
  parameter R_pHi16           = 0;
  parameter qLo16_w           = 0;
  parameter qLo16_r           = 0;
  parameter qLo16_s           = 0;
  parameter R_qLo16           = 0;
  parameter qHi16_w           = 0;
  parameter qHi16_r           = 0;
  parameter qHi16_s           = 0;
  parameter R_qHi16           = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire          [pLo16_w-1:0]  pLo16_q;
  wire          [pLo16_w-1:0]  pLo16_d;
  wire                         pLo16_weint;
  assign                       pLo16_weint = 0;

  wire          [pHi16_w-1:0]  pHi16_q;
  wire          [pHi16_w-1:0]  pHi16_d;
  wire                         pHi16_weint;
  assign                       pHi16_weint = 0;

  wire          [qLo16_w-1:0]  qLo16_q;
  wire          [qLo16_w-1:0]  qLo16_d;
  wire                         qLo16_weint;
  assign                       qLo16_weint = 0;

  wire          [qHi16_w-1:0]  qHi16_q;
  wire          [qHi16_w-1:0]  qHi16_d;
  wire                         qHi16_weint;
  assign                       qHi16_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg pLo16(pLo16_q, regBus, pLo16_d, pLo16_weint, regWe, regRe, clk, reset);
  defparam pLo16.w    = pLo16_w;
  defparam pLo16.rval = pLo16_r;
  defparam pLo16.sgn  = pLo16_s;
  defparam pLo16.adr  = R_pLo16;

  ereg pHi16(pHi16_q, regBus, pHi16_d, pHi16_weint, regWe, regRe, clk, reset);
  defparam pHi16.w    = pHi16_w;
  defparam pHi16.rval = pHi16_r;
  defparam pHi16.sgn  = pHi16_s;
  defparam pHi16.adr  = R_pHi16;

  ereg qLo16(qLo16_q, regBus, qLo16_d, qLo16_weint, regWe, regRe, clk, reset);
  defparam qLo16.w    = qLo16_w;
  defparam qLo16.rval = qLo16_r;
  defparam qLo16.sgn  = qLo16_s;
  defparam qLo16.adr  = R_qLo16;

  ereg qHi16(qHi16_q, regBus, qHi16_d, qHi16_weint, regWe, regRe, clk, reset);
  defparam qHi16.w    = qHi16_w;
  defparam qHi16.rval = qHi16_r;
  defparam qHi16.sgn  = qHi16_s;
  defparam qHi16.adr  = R_qHi16;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q==1;
  assign xIm_ir = run1_q==1;
  assign yRe_or = xRe_re;
  assign yIm_or = xIm_re;
  assign yRe    = xRe;
  assign yIm    = xIm;

endmodule
//=========================================================================================

