//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   crdcPhRot
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module crdcPhRot(yRe, yRe_or, yRe_ff, yRe_we, 
                 yIm, yIm_or, yIm_ff, yIm_we, 
                 xRe, xRe_ir, xRe_fe, xRe_re, 
                 xIm, xIm_ir, xIm_fe, xIm_re, 
                 ph, ph_ir, ph_fe, ph_re, 
                 run1, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;
  parameter ph_w              = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;
  parameter wp                = 0;
  parameter wi                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input            [ph_w-1:0]  ph;
  output                       ph_ir;
  input                        ph_fe;
  output                       ph_re;
  assign                       ph_re = ph_ir & ~ph_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "crdcCore_00x20x20.v"
  `include "crdcCore_01x20x20.v"
  `include "crdcCore_02x20x20.v"
  `include "crdcCore_03x20x20.v"
  `include "crdcCore_04x20x20.v"
  `include "crdcCore_05x20x20.v"
  `include "crdcCore_06x20x20.v"
  `include "crdcCore_07x20x20.v"
  `include "crdcCore_08x20x20.v"
  `include "crdcCore_09x20x20.v"
  `include "crdcCore_10x20x20.v"
  `include "crdcCore_11x20x20.v"
  `include "crdcCore_12x20x20.v"
  `include "crdcCore_13x20x20.v"
  `include "crdcCore_14x20x20.v"
  `include "crdcCore_15x20x20.v"
  `include "crdcCore_16x20x20.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | crdcCore_00x20x20_regWe | crdcCore_01x20x20_regWe | crdcCore_02x20x20_regWe
                      | crdcCore_03x20x20_regWe | crdcCore_04x20x20_regWe | crdcCore_05x20x20_regWe
                      | crdcCore_06x20x20_regWe | crdcCore_07x20x20_regWe | crdcCore_08x20x20_regWe
                      | crdcCore_09x20x20_regWe | crdcCore_10x20x20_regWe | crdcCore_11x20x20_regWe
                      | crdcCore_12x20x20_regWe | crdcCore_13x20x20_regWe | crdcCore_14x20x20_regWe
                      | crdcCore_15x20x20_regWe | crdcCore_16x20x20_regWe;
  assign regReOut = 0 | crdcCore_00x20x20_regRe | crdcCore_01x20x20_regRe | crdcCore_02x20x20_regRe
                      | crdcCore_03x20x20_regRe | crdcCore_04x20x20_regRe | crdcCore_05x20x20_regRe
                      | crdcCore_06x20x20_regRe | crdcCore_07x20x20_regRe | crdcCore_08x20x20_regRe
                      | crdcCore_09x20x20_regRe | crdcCore_10x20x20_regRe | crdcCore_11x20x20_regRe
                      | crdcCore_12x20x20_regRe | crdcCore_13x20x20_regRe | crdcCore_14x20x20_regRe
                      | crdcCore_15x20x20_regRe | crdcCore_16x20x20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  
  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1;
  assign xIm_ir = run1;
  assign yRe_or = xRe_re;
  assign yIm_or = xIm_re;
  assign yRe    = xRe;
  assign yIm    = xIm;

endmodule
//=========================================================================================

