//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   crdcCore
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module crdcCore(xReOut, xReOut_or, xReOut_ff, xReOut_we, 
                xImOut, xImOut_or, xImOut_ff, xImOut_we, 
                phOut, phOut_or, phOut_ff, phOut_we, 
                xReIn, xReIn_ir, xReIn_fe, xReIn_re, 
                xImIn, xImIn_ir, xImIn_fe, xImIn_re, 
                phIn, phIn_ir, phIn_fe, phIn_re, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter xReOut_w          = 0;
  parameter xImOut_w          = 0;
  parameter phOut_w           = 0;
  parameter xReIn_w           = 0;
  parameter xImIn_w           = 0;
  parameter phIn_w            = 0;


  parameter wx                = 0;
  parameter wp                = 0;
  parameter it                = 0;
  parameter cf                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output       [xReOut_w-1:0]  xReOut;
  output                       xReOut_or;
  input                        xReOut_ff;
  output                       xReOut_we;
  assign                       xReOut_we = xReOut_or & ~xReOut_ff;

  output       [xImOut_w-1:0]  xImOut;
  output                       xImOut_or;
  input                        xImOut_ff;
  output                       xImOut_we;
  assign                       xImOut_we = xImOut_or & ~xImOut_ff;

  output        [phOut_w-1:0]  phOut;
  output                       phOut_or;
  input                        phOut_ff;
  output                       phOut_we;
  assign                       phOut_we = phOut_or & ~phOut_ff;

  input         [xReIn_w-1:0]  xReIn;
  output                       xReIn_ir;
  input                        xReIn_fe;
  output                       xReIn_re;
  assign                       xReIn_re = xReIn_ir & ~xReIn_fe;

  input         [xImIn_w-1:0]  xImIn;
  output                       xImIn_ir;
  input                        xImIn_fe;
  output                       xImIn_re;
  assign                       xImIn_re = xImIn_ir & ~xImIn_fe;

  input          [phIn_w-1:0]  phIn;
  output                       phIn_ir;
  input                        phIn_fe;
  output                       phIn_re;
  assign                       phIn_re = phIn_ir & ~phIn_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg signed  [wx-1:0]  xRe, xIm, xRe_nxt, xIm_nxt;
  reg signed  [wp-1:0]  ph, ph_nxt;
  reg                   s;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
    
    // Get inputs, use signed values
    xRe = xReIn;
    xIm = xImIn;
    ph  = phIn;
    
    // Get sign of phase and execute Cordic rotation
    s = ph[wp-1];
    if (s) begin
      if (it==0) begin
        xRe_nxt =  xIm;
        xIm_nxt = -xRe;
      end else begin
        xRe_nxt = xRe + (xIm >>> (it-1));
        xIm_nxt = xIm - (xRe >>> (it-1));
      end
      ph_nxt  = ph  + cf;
    end else begin
      if (it==0) begin
        xRe_nxt = -xIm;
        xIm_nxt = +xRe;
      end else begin
        xRe_nxt = xRe - (xIm >>> (it-1));
        xIm_nxt = xIm + (xRe >>> (it-1));
      end
      ph_nxt  = ph  - cf;
    end
  end

  // Assign outputs
  assign xReOut = xRe_nxt;
  assign xImOut = xIm_nxt;
  assign phOut  = ph_nxt;

endmodule
//=========================================================================================

